/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.xxhash;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct XXH32_state_t")
public class XXH32State
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TOTAL_LEN_32;
    public static final int LARGE_LEN;
    public static final int V;
    public static final int MEM32;
    public static final int MEMSIZE;
    public static final int RESERVED;

    public XXH32State(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XXH32State.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XXH32_hash_t")
    public int total_len_32() {
        return XXH32State.ntotal_len_32(this.address());
    }

    @NativeType(value="XXH32_hash_t")
    public int large_len() {
        return XXH32State.nlarge_len(this.address());
    }

    @NativeType(value="XXH32_hash_t[4]")
    public IntBuffer v() {
        return XXH32State.nv(this.address());
    }

    @NativeType(value="XXH32_hash_t")
    public int v(int index) {
        return XXH32State.nv(this.address(), index);
    }

    @NativeType(value="XXH32_hash_t[4]")
    public IntBuffer mem32() {
        return XXH32State.nmem32(this.address());
    }

    @NativeType(value="XXH32_hash_t")
    public int mem32(int index) {
        return XXH32State.nmem32(this.address(), index);
    }

    @NativeType(value="XXH32_hash_t")
    public int memsize() {
        return XXH32State.nmemsize(this.address());
    }

    @NativeType(value="XXH32_hash_t")
    public int reserved() {
        return XXH32State.nreserved(this.address());
    }

    public static XXH32State malloc() {
        return XXH32State.wrap(XXH32State.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XXH32State calloc() {
        return XXH32State.wrap(XXH32State.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XXH32State create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XXH32State.wrap(XXH32State.class, MemoryUtil.memAddress(container), container);
    }

    public static XXH32State create(long address) {
        return XXH32State.wrap(XXH32State.class, address);
    }

    @Nullable
    public static XXH32State createSafe(long address) {
        return address == 0L ? null : XXH32State.wrap(XXH32State.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XXH32State.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XXH32State.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XXH32State.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XXH32State.__create(capacity, SIZEOF);
        return XXH32State.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XXH32State.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XXH32State.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static XXH32State mallocStack() {
        return XXH32State.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static XXH32State callocStack() {
        return XXH32State.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static XXH32State mallocStack(MemoryStack stack) {
        return XXH32State.malloc(stack);
    }

    @Deprecated
    public static XXH32State callocStack(MemoryStack stack) {
        return XXH32State.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return XXH32State.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return XXH32State.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return XXH32State.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return XXH32State.calloc(capacity, stack);
    }

    public static XXH32State malloc(MemoryStack stack) {
        return XXH32State.wrap(XXH32State.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XXH32State calloc(MemoryStack stack) {
        return XXH32State.wrap(XXH32State.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XXH32State.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XXH32State.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntotal_len_32(long struct) {
        return UNSAFE.getInt(null, struct + (long)TOTAL_LEN_32);
    }

    public static int nlarge_len(long struct) {
        return UNSAFE.getInt(null, struct + (long)LARGE_LEN);
    }

    public static IntBuffer nv(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)V, 4);
    }

    public static int nv(long struct, int index) {
        return UNSAFE.getInt(null, struct + (long)V + Checks.check(index, 4) * 4L);
    }

    public static IntBuffer nmem32(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)MEM32, 4);
    }

    public static int nmem32(long struct, int index) {
        return UNSAFE.getInt(null, struct + (long)MEM32 + Checks.check(index, 4) * 4L);
    }

    public static int nmemsize(long struct) {
        return UNSAFE.getInt(null, struct + (long)MEMSIZE);
    }

    public static int nreserved(long struct) {
        return UNSAFE.getInt(null, struct + (long)RESERVED);
    }

    static {
        Struct.Layout layout = XXH32State.__struct(XXH32State.__member(4), XXH32State.__member(4), XXH32State.__array(4, 4), XXH32State.__array(4, 4), XXH32State.__member(4), XXH32State.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TOTAL_LEN_32 = layout.offsetof(0);
        LARGE_LEN = layout.offsetof(1);
        V = layout.offsetof(2);
        MEM32 = layout.offsetof(3);
        MEMSIZE = layout.offsetof(4);
        RESERVED = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XXH32State, Buffer>
    implements NativeResource {
        private static final XXH32State ELEMENT_FACTORY = XXH32State.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XXH32State getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XXH32_hash_t")
        public int total_len_32() {
            return XXH32State.ntotal_len_32(this.address());
        }

        @NativeType(value="XXH32_hash_t")
        public int large_len() {
            return XXH32State.nlarge_len(this.address());
        }

        @NativeType(value="XXH32_hash_t[4]")
        public IntBuffer v() {
            return XXH32State.nv(this.address());
        }

        @NativeType(value="XXH32_hash_t")
        public int v(int index) {
            return XXH32State.nv(this.address(), index);
        }

        @NativeType(value="XXH32_hash_t[4]")
        public IntBuffer mem32() {
            return XXH32State.nmem32(this.address());
        }

        @NativeType(value="XXH32_hash_t")
        public int mem32(int index) {
            return XXH32State.nmem32(this.address(), index);
        }

        @NativeType(value="XXH32_hash_t")
        public int memsize() {
            return XXH32State.nmemsize(this.address());
        }

        @NativeType(value="XXH32_hash_t")
        public int reserved() {
            return XXH32State.nreserved(this.address());
        }
    }
}

