/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.xxhash;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct XXH128_hash_t")
public class XXH128Hash
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LOW64;
    public static final int HIGH64;

    public XXH128Hash(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XXH128Hash.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XXH64_hash_t")
    public long low64() {
        return XXH128Hash.nlow64(this.address());
    }

    @NativeType(value="XXH64_hash_t")
    public long high64() {
        return XXH128Hash.nhigh64(this.address());
    }

    public static XXH128Hash malloc() {
        return XXH128Hash.wrap(XXH128Hash.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XXH128Hash calloc() {
        return XXH128Hash.wrap(XXH128Hash.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XXH128Hash create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XXH128Hash.wrap(XXH128Hash.class, MemoryUtil.memAddress(container), container);
    }

    public static XXH128Hash create(long address) {
        return XXH128Hash.wrap(XXH128Hash.class, address);
    }

    @Nullable
    public static XXH128Hash createSafe(long address) {
        return address == 0L ? null : XXH128Hash.wrap(XXH128Hash.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XXH128Hash.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XXH128Hash.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XXH128Hash.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XXH128Hash.__create(capacity, SIZEOF);
        return XXH128Hash.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XXH128Hash.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XXH128Hash.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static XXH128Hash mallocStack() {
        return XXH128Hash.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static XXH128Hash callocStack() {
        return XXH128Hash.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static XXH128Hash mallocStack(MemoryStack stack) {
        return XXH128Hash.malloc(stack);
    }

    @Deprecated
    public static XXH128Hash callocStack(MemoryStack stack) {
        return XXH128Hash.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return XXH128Hash.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return XXH128Hash.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return XXH128Hash.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return XXH128Hash.calloc(capacity, stack);
    }

    public static XXH128Hash malloc(MemoryStack stack) {
        return XXH128Hash.wrap(XXH128Hash.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XXH128Hash calloc(MemoryStack stack) {
        return XXH128Hash.wrap(XXH128Hash.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XXH128Hash.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XXH128Hash.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nlow64(long struct) {
        return UNSAFE.getLong(null, struct + (long)LOW64);
    }

    public static long nhigh64(long struct) {
        return UNSAFE.getLong(null, struct + (long)HIGH64);
    }

    static {
        Struct.Layout layout = XXH128Hash.__struct(XXH128Hash.__member(8), XXH128Hash.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LOW64 = layout.offsetof(0);
        HIGH64 = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XXH128Hash, Buffer>
    implements NativeResource {
        private static final XXH128Hash ELEMENT_FACTORY = XXH128Hash.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XXH128Hash getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XXH64_hash_t")
        public long low64() {
            return XXH128Hash.nlow64(this.address());
        }

        @NativeType(value="XXH64_hash_t")
        public long high64() {
            return XXH128Hash.nhigh64(this.address());
        }
    }
}

