/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VmaVirtualAllocationCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SIZE;
    public static final int ALIGNMENT;
    public static final int FLAGS;
    public static final int PUSERDATA;

    public VmaVirtualAllocationCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VmaVirtualAllocationCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VmaVirtualAllocationCreateInfo.nsize(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long alignment() {
        return VmaVirtualAllocationCreateInfo.nalignment(this.address());
    }

    @NativeType(value="VmaVirtualAllocationCreateFlags")
    public int flags() {
        return VmaVirtualAllocationCreateInfo.nflags(this.address());
    }

    @NativeType(value="void *")
    public long pUserData() {
        return VmaVirtualAllocationCreateInfo.npUserData(this.address());
    }

    public VmaVirtualAllocationCreateInfo size(@NativeType(value="VkDeviceSize") long value) {
        VmaVirtualAllocationCreateInfo.nsize(this.address(), value);
        return this;
    }

    public VmaVirtualAllocationCreateInfo alignment(@NativeType(value="VkDeviceSize") long value) {
        VmaVirtualAllocationCreateInfo.nalignment(this.address(), value);
        return this;
    }

    public VmaVirtualAllocationCreateInfo flags(@NativeType(value="VmaVirtualAllocationCreateFlags") int value) {
        VmaVirtualAllocationCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VmaVirtualAllocationCreateInfo pUserData(@NativeType(value="void *") long value) {
        VmaVirtualAllocationCreateInfo.npUserData(this.address(), value);
        return this;
    }

    public VmaVirtualAllocationCreateInfo set(long size, long alignment, int flags, long pUserData) {
        this.size(size);
        this.alignment(alignment);
        this.flags(flags);
        this.pUserData(pUserData);
        return this;
    }

    public VmaVirtualAllocationCreateInfo set(VmaVirtualAllocationCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VmaVirtualAllocationCreateInfo malloc() {
        return VmaVirtualAllocationCreateInfo.wrap(VmaVirtualAllocationCreateInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VmaVirtualAllocationCreateInfo calloc() {
        return VmaVirtualAllocationCreateInfo.wrap(VmaVirtualAllocationCreateInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VmaVirtualAllocationCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VmaVirtualAllocationCreateInfo.wrap(VmaVirtualAllocationCreateInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static VmaVirtualAllocationCreateInfo create(long address) {
        return VmaVirtualAllocationCreateInfo.wrap(VmaVirtualAllocationCreateInfo.class, address);
    }

    @Nullable
    public static VmaVirtualAllocationCreateInfo createSafe(long address) {
        return address == 0L ? null : VmaVirtualAllocationCreateInfo.wrap(VmaVirtualAllocationCreateInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VmaVirtualAllocationCreateInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VmaVirtualAllocationCreateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VmaVirtualAllocationCreateInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VmaVirtualAllocationCreateInfo.__create(capacity, SIZEOF);
        return VmaVirtualAllocationCreateInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VmaVirtualAllocationCreateInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VmaVirtualAllocationCreateInfo.wrap(Buffer.class, address, capacity);
    }

    public static VmaVirtualAllocationCreateInfo malloc(MemoryStack stack) {
        return VmaVirtualAllocationCreateInfo.wrap(VmaVirtualAllocationCreateInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VmaVirtualAllocationCreateInfo calloc(MemoryStack stack) {
        return VmaVirtualAllocationCreateInfo.wrap(VmaVirtualAllocationCreateInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VmaVirtualAllocationCreateInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VmaVirtualAllocationCreateInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nsize(long struct) {
        return UNSAFE.getLong(null, struct + (long)SIZE);
    }

    public static long nalignment(long struct) {
        return UNSAFE.getLong(null, struct + (long)ALIGNMENT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static long npUserData(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PUSERDATA);
    }

    public static void nsize(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SIZE, value);
    }

    public static void nalignment(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)ALIGNMENT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void npUserData(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PUSERDATA, value);
    }

    static {
        Struct.Layout layout = VmaVirtualAllocationCreateInfo.__struct(VmaVirtualAllocationCreateInfo.__member(8), VmaVirtualAllocationCreateInfo.__member(8), VmaVirtualAllocationCreateInfo.__member(4), VmaVirtualAllocationCreateInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SIZE = layout.offsetof(0);
        ALIGNMENT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        PUSERDATA = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VmaVirtualAllocationCreateInfo, Buffer>
    implements NativeResource {
        private static final VmaVirtualAllocationCreateInfo ELEMENT_FACTORY = VmaVirtualAllocationCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VmaVirtualAllocationCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VmaVirtualAllocationCreateInfo.nsize(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long alignment() {
            return VmaVirtualAllocationCreateInfo.nalignment(this.address());
        }

        @NativeType(value="VmaVirtualAllocationCreateFlags")
        public int flags() {
            return VmaVirtualAllocationCreateInfo.nflags(this.address());
        }

        @NativeType(value="void *")
        public long pUserData() {
            return VmaVirtualAllocationCreateInfo.npUserData(this.address());
        }

        public Buffer size(@NativeType(value="VkDeviceSize") long value) {
            VmaVirtualAllocationCreateInfo.nsize(this.address(), value);
            return this;
        }

        public Buffer alignment(@NativeType(value="VkDeviceSize") long value) {
            VmaVirtualAllocationCreateInfo.nalignment(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VmaVirtualAllocationCreateFlags") int value) {
            VmaVirtualAllocationCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer pUserData(@NativeType(value="void *") long value) {
            VmaVirtualAllocationCreateInfo.npUserData(this.address(), value);
            return this;
        }
    }
}

