/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VmaStatInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BLOCKCOUNT;
    public static final int ALLOCATIONCOUNT;
    public static final int UNUSEDRANGECOUNT;
    public static final int USEDBYTES;
    public static final int UNUSEDBYTES;
    public static final int ALLOCATIONSIZEMIN;
    public static final int ALLOCATIONSIZEAVG;
    public static final int ALLOCATIONSIZEMAX;
    public static final int UNUSEDRANGESIZEMIN;
    public static final int UNUSEDRANGESIZEAVG;
    public static final int UNUSEDRANGESIZEMAX;

    public VmaStatInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VmaStatInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int blockCount() {
        return VmaStatInfo.nblockCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int allocationCount() {
        return VmaStatInfo.nallocationCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int unusedRangeCount() {
        return VmaStatInfo.nunusedRangeCount(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long usedBytes() {
        return VmaStatInfo.nusedBytes(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long unusedBytes() {
        return VmaStatInfo.nunusedBytes(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long allocationSizeMin() {
        return VmaStatInfo.nallocationSizeMin(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long allocationSizeAvg() {
        return VmaStatInfo.nallocationSizeAvg(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long allocationSizeMax() {
        return VmaStatInfo.nallocationSizeMax(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long unusedRangeSizeMin() {
        return VmaStatInfo.nunusedRangeSizeMin(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long unusedRangeSizeAvg() {
        return VmaStatInfo.nunusedRangeSizeAvg(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long unusedRangeSizeMax() {
        return VmaStatInfo.nunusedRangeSizeMax(this.address());
    }

    public static VmaStatInfo malloc() {
        return VmaStatInfo.wrap(VmaStatInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VmaStatInfo calloc() {
        return VmaStatInfo.wrap(VmaStatInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VmaStatInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VmaStatInfo.wrap(VmaStatInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static VmaStatInfo create(long address) {
        return VmaStatInfo.wrap(VmaStatInfo.class, address);
    }

    @Nullable
    public static VmaStatInfo createSafe(long address) {
        return address == 0L ? null : VmaStatInfo.wrap(VmaStatInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VmaStatInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VmaStatInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VmaStatInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VmaStatInfo.__create(capacity, SIZEOF);
        return VmaStatInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VmaStatInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VmaStatInfo.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VmaStatInfo mallocStack() {
        return VmaStatInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VmaStatInfo callocStack() {
        return VmaStatInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VmaStatInfo mallocStack(MemoryStack stack) {
        return VmaStatInfo.malloc(stack);
    }

    @Deprecated
    public static VmaStatInfo callocStack(MemoryStack stack) {
        return VmaStatInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VmaStatInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VmaStatInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VmaStatInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VmaStatInfo.calloc(capacity, stack);
    }

    public static VmaStatInfo malloc(MemoryStack stack) {
        return VmaStatInfo.wrap(VmaStatInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VmaStatInfo calloc(MemoryStack stack) {
        return VmaStatInfo.wrap(VmaStatInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VmaStatInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VmaStatInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nblockCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)BLOCKCOUNT);
    }

    public static int nallocationCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)ALLOCATIONCOUNT);
    }

    public static int nunusedRangeCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)UNUSEDRANGECOUNT);
    }

    public static long nusedBytes(long struct) {
        return UNSAFE.getLong(null, struct + (long)USEDBYTES);
    }

    public static long nunusedBytes(long struct) {
        return UNSAFE.getLong(null, struct + (long)UNUSEDBYTES);
    }

    public static long nallocationSizeMin(long struct) {
        return UNSAFE.getLong(null, struct + (long)ALLOCATIONSIZEMIN);
    }

    public static long nallocationSizeAvg(long struct) {
        return UNSAFE.getLong(null, struct + (long)ALLOCATIONSIZEAVG);
    }

    public static long nallocationSizeMax(long struct) {
        return UNSAFE.getLong(null, struct + (long)ALLOCATIONSIZEMAX);
    }

    public static long nunusedRangeSizeMin(long struct) {
        return UNSAFE.getLong(null, struct + (long)UNUSEDRANGESIZEMIN);
    }

    public static long nunusedRangeSizeAvg(long struct) {
        return UNSAFE.getLong(null, struct + (long)UNUSEDRANGESIZEAVG);
    }

    public static long nunusedRangeSizeMax(long struct) {
        return UNSAFE.getLong(null, struct + (long)UNUSEDRANGESIZEMAX);
    }

    static {
        Struct.Layout layout = VmaStatInfo.__struct(VmaStatInfo.__member(4), VmaStatInfo.__member(4), VmaStatInfo.__member(4), VmaStatInfo.__member(8), VmaStatInfo.__member(8), VmaStatInfo.__member(8), VmaStatInfo.__member(8), VmaStatInfo.__member(8), VmaStatInfo.__member(8), VmaStatInfo.__member(8), VmaStatInfo.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BLOCKCOUNT = layout.offsetof(0);
        ALLOCATIONCOUNT = layout.offsetof(1);
        UNUSEDRANGECOUNT = layout.offsetof(2);
        USEDBYTES = layout.offsetof(3);
        UNUSEDBYTES = layout.offsetof(4);
        ALLOCATIONSIZEMIN = layout.offsetof(5);
        ALLOCATIONSIZEAVG = layout.offsetof(6);
        ALLOCATIONSIZEMAX = layout.offsetof(7);
        UNUSEDRANGESIZEMIN = layout.offsetof(8);
        UNUSEDRANGESIZEAVG = layout.offsetof(9);
        UNUSEDRANGESIZEMAX = layout.offsetof(10);
    }

    public static class Buffer
    extends StructBuffer<VmaStatInfo, Buffer>
    implements NativeResource {
        private static final VmaStatInfo ELEMENT_FACTORY = VmaStatInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VmaStatInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int blockCount() {
            return VmaStatInfo.nblockCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int allocationCount() {
            return VmaStatInfo.nallocationCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int unusedRangeCount() {
            return VmaStatInfo.nunusedRangeCount(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long usedBytes() {
            return VmaStatInfo.nusedBytes(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long unusedBytes() {
            return VmaStatInfo.nunusedBytes(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long allocationSizeMin() {
            return VmaStatInfo.nallocationSizeMin(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long allocationSizeAvg() {
            return VmaStatInfo.nallocationSizeAvg(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long allocationSizeMax() {
            return VmaStatInfo.nallocationSizeMax(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long unusedRangeSizeMin() {
            return VmaStatInfo.nunusedRangeSizeMin(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long unusedRangeSizeAvg() {
            return VmaStatInfo.nunusedRangeSizeAvg(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long unusedRangeSizeMax() {
            return VmaStatInfo.nunusedRangeSizeMax(this.address());
        }
    }
}

