/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VmaRecordSettings
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int PFILEPATH;

    public VmaRecordSettings(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VmaRecordSettings.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VmaRecordFlags")
    public int flags() {
        return VmaRecordSettings.nflags(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer pFilePath() {
        return VmaRecordSettings.npFilePath(this.address());
    }

    @NativeType(value="char const *")
    public String pFilePathString() {
        return VmaRecordSettings.npFilePathString(this.address());
    }

    public VmaRecordSettings flags(@NativeType(value="VmaRecordFlags") int value) {
        VmaRecordSettings.nflags(this.address(), value);
        return this;
    }

    public VmaRecordSettings pFilePath(@NativeType(value="char const *") ByteBuffer value) {
        VmaRecordSettings.npFilePath(this.address(), value);
        return this;
    }

    public VmaRecordSettings set(int flags, ByteBuffer pFilePath) {
        this.flags(flags);
        this.pFilePath(pFilePath);
        return this;
    }

    public VmaRecordSettings set(VmaRecordSettings src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VmaRecordSettings malloc() {
        return VmaRecordSettings.wrap(VmaRecordSettings.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VmaRecordSettings calloc() {
        return VmaRecordSettings.wrap(VmaRecordSettings.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VmaRecordSettings create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VmaRecordSettings.wrap(VmaRecordSettings.class, MemoryUtil.memAddress(container), container);
    }

    public static VmaRecordSettings create(long address) {
        return VmaRecordSettings.wrap(VmaRecordSettings.class, address);
    }

    @Nullable
    public static VmaRecordSettings createSafe(long address) {
        return address == 0L ? null : VmaRecordSettings.wrap(VmaRecordSettings.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VmaRecordSettings.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VmaRecordSettings.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VmaRecordSettings.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VmaRecordSettings.__create(capacity, SIZEOF);
        return VmaRecordSettings.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VmaRecordSettings.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VmaRecordSettings.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VmaRecordSettings mallocStack() {
        return VmaRecordSettings.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VmaRecordSettings callocStack() {
        return VmaRecordSettings.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VmaRecordSettings mallocStack(MemoryStack stack) {
        return VmaRecordSettings.malloc(stack);
    }

    @Deprecated
    public static VmaRecordSettings callocStack(MemoryStack stack) {
        return VmaRecordSettings.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VmaRecordSettings.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VmaRecordSettings.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VmaRecordSettings.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VmaRecordSettings.calloc(capacity, stack);
    }

    public static VmaRecordSettings malloc(MemoryStack stack) {
        return VmaRecordSettings.wrap(VmaRecordSettings.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VmaRecordSettings calloc(MemoryStack stack) {
        return VmaRecordSettings.wrap(VmaRecordSettings.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VmaRecordSettings.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VmaRecordSettings.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static ByteBuffer npFilePath(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)PFILEPATH));
    }

    public static String npFilePathString(long struct) {
        return MemoryUtil.memASCII(MemoryUtil.memGetAddress(struct + (long)PFILEPATH));
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void npFilePath(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
        }
        MemoryUtil.memPutAddress(struct + (long)PFILEPATH, MemoryUtil.memAddress(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PFILEPATH));
    }

    static {
        Struct.Layout layout = VmaRecordSettings.__struct(VmaRecordSettings.__member(4), VmaRecordSettings.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        PFILEPATH = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VmaRecordSettings, Buffer>
    implements NativeResource {
        private static final VmaRecordSettings ELEMENT_FACTORY = VmaRecordSettings.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VmaRecordSettings getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VmaRecordFlags")
        public int flags() {
            return VmaRecordSettings.nflags(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer pFilePath() {
            return VmaRecordSettings.npFilePath(this.address());
        }

        @NativeType(value="char const *")
        public String pFilePathString() {
            return VmaRecordSettings.npFilePathString(this.address());
        }

        public Buffer flags(@NativeType(value="VmaRecordFlags") int value) {
            VmaRecordSettings.nflags(this.address(), value);
            return this;
        }

        public Buffer pFilePath(@NativeType(value="char const *") ByteBuffer value) {
            VmaRecordSettings.npFilePath(this.address(), value);
            return this;
        }
    }
}

