/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VmaDefragmentationStats
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BYTESMOVED;
    public static final int BYTESFREED;
    public static final int ALLOCATIONSMOVED;
    public static final int DEVICEMEMORYBLOCKSFREED;

    public VmaDefragmentationStats(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VmaDefragmentationStats.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceSize")
    public long bytesMoved() {
        return VmaDefragmentationStats.nbytesMoved(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long bytesFreed() {
        return VmaDefragmentationStats.nbytesFreed(this.address());
    }

    @NativeType(value="uint32_t")
    public int allocationsMoved() {
        return VmaDefragmentationStats.nallocationsMoved(this.address());
    }

    @NativeType(value="uint32_t")
    public int deviceMemoryBlocksFreed() {
        return VmaDefragmentationStats.ndeviceMemoryBlocksFreed(this.address());
    }

    public static VmaDefragmentationStats malloc() {
        return VmaDefragmentationStats.wrap(VmaDefragmentationStats.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VmaDefragmentationStats calloc() {
        return VmaDefragmentationStats.wrap(VmaDefragmentationStats.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VmaDefragmentationStats create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VmaDefragmentationStats.wrap(VmaDefragmentationStats.class, MemoryUtil.memAddress(container), container);
    }

    public static VmaDefragmentationStats create(long address) {
        return VmaDefragmentationStats.wrap(VmaDefragmentationStats.class, address);
    }

    @Nullable
    public static VmaDefragmentationStats createSafe(long address) {
        return address == 0L ? null : VmaDefragmentationStats.wrap(VmaDefragmentationStats.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VmaDefragmentationStats.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VmaDefragmentationStats.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VmaDefragmentationStats.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VmaDefragmentationStats.__create(capacity, SIZEOF);
        return VmaDefragmentationStats.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VmaDefragmentationStats.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VmaDefragmentationStats.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VmaDefragmentationStats mallocStack() {
        return VmaDefragmentationStats.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VmaDefragmentationStats callocStack() {
        return VmaDefragmentationStats.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VmaDefragmentationStats mallocStack(MemoryStack stack) {
        return VmaDefragmentationStats.malloc(stack);
    }

    @Deprecated
    public static VmaDefragmentationStats callocStack(MemoryStack stack) {
        return VmaDefragmentationStats.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VmaDefragmentationStats.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VmaDefragmentationStats.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VmaDefragmentationStats.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VmaDefragmentationStats.calloc(capacity, stack);
    }

    public static VmaDefragmentationStats malloc(MemoryStack stack) {
        return VmaDefragmentationStats.wrap(VmaDefragmentationStats.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VmaDefragmentationStats calloc(MemoryStack stack) {
        return VmaDefragmentationStats.wrap(VmaDefragmentationStats.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VmaDefragmentationStats.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VmaDefragmentationStats.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nbytesMoved(long struct) {
        return UNSAFE.getLong(null, struct + (long)BYTESMOVED);
    }

    public static long nbytesFreed(long struct) {
        return UNSAFE.getLong(null, struct + (long)BYTESFREED);
    }

    public static int nallocationsMoved(long struct) {
        return UNSAFE.getInt(null, struct + (long)ALLOCATIONSMOVED);
    }

    public static int ndeviceMemoryBlocksFreed(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEVICEMEMORYBLOCKSFREED);
    }

    static {
        Struct.Layout layout = VmaDefragmentationStats.__struct(VmaDefragmentationStats.__member(8), VmaDefragmentationStats.__member(8), VmaDefragmentationStats.__member(4), VmaDefragmentationStats.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BYTESMOVED = layout.offsetof(0);
        BYTESFREED = layout.offsetof(1);
        ALLOCATIONSMOVED = layout.offsetof(2);
        DEVICEMEMORYBLOCKSFREED = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VmaDefragmentationStats, Buffer>
    implements NativeResource {
        private static final VmaDefragmentationStats ELEMENT_FACTORY = VmaDefragmentationStats.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VmaDefragmentationStats getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceSize")
        public long bytesMoved() {
            return VmaDefragmentationStats.nbytesMoved(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long bytesFreed() {
            return VmaDefragmentationStats.nbytesFreed(this.address());
        }

        @NativeType(value="uint32_t")
        public int allocationsMoved() {
            return VmaDefragmentationStats.nallocationsMoved(this.address());
        }

        @NativeType(value="uint32_t")
        public int deviceMemoryBlocksFreed() {
            return VmaDefragmentationStats.ndeviceMemoryBlocksFreed(this.address());
        }
    }
}

