/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkCommandBuffer;

public class VmaDefragmentationInfo2
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int ALLOCATIONCOUNT;
    public static final int PALLOCATIONS;
    public static final int PALLOCATIONSCHANGED;
    public static final int POOLCOUNT;
    public static final int PPOOLS;
    public static final int MAXCPUBYTESTOMOVE;
    public static final int MAXCPUALLOCATIONSTOMOVE;
    public static final int MAXGPUBYTESTOMOVE;
    public static final int MAXGPUALLOCATIONSTOMOVE;
    public static final int COMMANDBUFFER;

    public VmaDefragmentationInfo2(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VmaDefragmentationInfo2.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VmaDefragmentationFlags")
    public int flags() {
        return VmaDefragmentationInfo2.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int allocationCount() {
        return VmaDefragmentationInfo2.nallocationCount(this.address());
    }

    @NativeType(value="VmaAllocation *")
    public PointerBuffer pAllocations() {
        return VmaDefragmentationInfo2.npAllocations(this.address());
    }

    @Nullable
    @NativeType(value="VkBool32 *")
    public IntBuffer pAllocationsChanged() {
        return VmaDefragmentationInfo2.npAllocationsChanged(this.address());
    }

    @NativeType(value="uint32_t")
    public int poolCount() {
        return VmaDefragmentationInfo2.npoolCount(this.address());
    }

    @Nullable
    @NativeType(value="VmaPool const *")
    public PointerBuffer pPools() {
        return VmaDefragmentationInfo2.npPools(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long maxCpuBytesToMove() {
        return VmaDefragmentationInfo2.nmaxCpuBytesToMove(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxCpuAllocationsToMove() {
        return VmaDefragmentationInfo2.nmaxCpuAllocationsToMove(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long maxGpuBytesToMove() {
        return VmaDefragmentationInfo2.nmaxGpuBytesToMove(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxGpuAllocationsToMove() {
        return VmaDefragmentationInfo2.nmaxGpuAllocationsToMove(this.address());
    }

    @Nullable
    @NativeType(value="VkCommandBuffer")
    public long commandBuffer() {
        return VmaDefragmentationInfo2.ncommandBuffer(this.address());
    }

    public VmaDefragmentationInfo2 flags(@NativeType(value="VmaDefragmentationFlags") int value) {
        VmaDefragmentationInfo2.nflags(this.address(), value);
        return this;
    }

    public VmaDefragmentationInfo2 allocationCount(@NativeType(value="uint32_t") int value) {
        VmaDefragmentationInfo2.nallocationCount(this.address(), value);
        return this;
    }

    public VmaDefragmentationInfo2 pAllocations(@NativeType(value="VmaAllocation *") PointerBuffer value) {
        VmaDefragmentationInfo2.npAllocations(this.address(), value);
        return this;
    }

    public VmaDefragmentationInfo2 pAllocationsChanged(@Nullable @NativeType(value="VkBool32 *") IntBuffer value) {
        VmaDefragmentationInfo2.npAllocationsChanged(this.address(), value);
        return this;
    }

    public VmaDefragmentationInfo2 poolCount(@NativeType(value="uint32_t") int value) {
        VmaDefragmentationInfo2.npoolCount(this.address(), value);
        return this;
    }

    public VmaDefragmentationInfo2 pPools(@Nullable @NativeType(value="VmaPool const *") PointerBuffer value) {
        VmaDefragmentationInfo2.npPools(this.address(), value);
        return this;
    }

    public VmaDefragmentationInfo2 maxCpuBytesToMove(@NativeType(value="VkDeviceSize") long value) {
        VmaDefragmentationInfo2.nmaxCpuBytesToMove(this.address(), value);
        return this;
    }

    public VmaDefragmentationInfo2 maxCpuAllocationsToMove(@NativeType(value="uint32_t") int value) {
        VmaDefragmentationInfo2.nmaxCpuAllocationsToMove(this.address(), value);
        return this;
    }

    public VmaDefragmentationInfo2 maxGpuBytesToMove(@NativeType(value="VkDeviceSize") long value) {
        VmaDefragmentationInfo2.nmaxGpuBytesToMove(this.address(), value);
        return this;
    }

    public VmaDefragmentationInfo2 maxGpuAllocationsToMove(@NativeType(value="uint32_t") int value) {
        VmaDefragmentationInfo2.nmaxGpuAllocationsToMove(this.address(), value);
        return this;
    }

    public VmaDefragmentationInfo2 commandBuffer(@Nullable VkCommandBuffer value) {
        VmaDefragmentationInfo2.ncommandBuffer(this.address(), value);
        return this;
    }

    public VmaDefragmentationInfo2 set(int flags, int allocationCount, PointerBuffer pAllocations, @Nullable IntBuffer pAllocationsChanged, int poolCount, @Nullable PointerBuffer pPools, long maxCpuBytesToMove, int maxCpuAllocationsToMove, long maxGpuBytesToMove, int maxGpuAllocationsToMove, @Nullable VkCommandBuffer commandBuffer) {
        this.flags(flags);
        this.allocationCount(allocationCount);
        this.pAllocations(pAllocations);
        this.pAllocationsChanged(pAllocationsChanged);
        this.poolCount(poolCount);
        this.pPools(pPools);
        this.maxCpuBytesToMove(maxCpuBytesToMove);
        this.maxCpuAllocationsToMove(maxCpuAllocationsToMove);
        this.maxGpuBytesToMove(maxGpuBytesToMove);
        this.maxGpuAllocationsToMove(maxGpuAllocationsToMove);
        this.commandBuffer(commandBuffer);
        return this;
    }

    public VmaDefragmentationInfo2 set(VmaDefragmentationInfo2 src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VmaDefragmentationInfo2 malloc() {
        return VmaDefragmentationInfo2.wrap(VmaDefragmentationInfo2.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VmaDefragmentationInfo2 calloc() {
        return VmaDefragmentationInfo2.wrap(VmaDefragmentationInfo2.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VmaDefragmentationInfo2 create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VmaDefragmentationInfo2.wrap(VmaDefragmentationInfo2.class, MemoryUtil.memAddress(container), container);
    }

    public static VmaDefragmentationInfo2 create(long address) {
        return VmaDefragmentationInfo2.wrap(VmaDefragmentationInfo2.class, address);
    }

    @Nullable
    public static VmaDefragmentationInfo2 createSafe(long address) {
        return address == 0L ? null : VmaDefragmentationInfo2.wrap(VmaDefragmentationInfo2.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VmaDefragmentationInfo2.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VmaDefragmentationInfo2.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VmaDefragmentationInfo2.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VmaDefragmentationInfo2.__create(capacity, SIZEOF);
        return VmaDefragmentationInfo2.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VmaDefragmentationInfo2.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VmaDefragmentationInfo2.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VmaDefragmentationInfo2 mallocStack() {
        return VmaDefragmentationInfo2.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VmaDefragmentationInfo2 callocStack() {
        return VmaDefragmentationInfo2.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VmaDefragmentationInfo2 mallocStack(MemoryStack stack) {
        return VmaDefragmentationInfo2.malloc(stack);
    }

    @Deprecated
    public static VmaDefragmentationInfo2 callocStack(MemoryStack stack) {
        return VmaDefragmentationInfo2.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VmaDefragmentationInfo2.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VmaDefragmentationInfo2.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VmaDefragmentationInfo2.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VmaDefragmentationInfo2.calloc(capacity, stack);
    }

    public static VmaDefragmentationInfo2 malloc(MemoryStack stack) {
        return VmaDefragmentationInfo2.wrap(VmaDefragmentationInfo2.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VmaDefragmentationInfo2 calloc(MemoryStack stack) {
        return VmaDefragmentationInfo2.wrap(VmaDefragmentationInfo2.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VmaDefragmentationInfo2.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VmaDefragmentationInfo2.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int nallocationCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)ALLOCATIONCOUNT);
    }

    public static PointerBuffer npAllocations(long struct) {
        return MemoryUtil.memPointerBuffer(MemoryUtil.memGetAddress(struct + (long)PALLOCATIONS), VmaDefragmentationInfo2.nallocationCount(struct));
    }

    @Nullable
    public static IntBuffer npAllocationsChanged(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)PALLOCATIONSCHANGED), VmaDefragmentationInfo2.nallocationCount(struct));
    }

    public static int npoolCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)POOLCOUNT);
    }

    @Nullable
    public static PointerBuffer npPools(long struct) {
        return MemoryUtil.memPointerBufferSafe(MemoryUtil.memGetAddress(struct + (long)PPOOLS), VmaDefragmentationInfo2.npoolCount(struct));
    }

    public static long nmaxCpuBytesToMove(long struct) {
        return UNSAFE.getLong(null, struct + (long)MAXCPUBYTESTOMOVE);
    }

    public static int nmaxCpuAllocationsToMove(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXCPUALLOCATIONSTOMOVE);
    }

    public static long nmaxGpuBytesToMove(long struct) {
        return UNSAFE.getLong(null, struct + (long)MAXGPUBYTESTOMOVE);
    }

    public static int nmaxGpuAllocationsToMove(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXGPUALLOCATIONSTOMOVE);
    }

    public static long ncommandBuffer(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)COMMANDBUFFER);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nallocationCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ALLOCATIONCOUNT, value);
    }

    public static void npAllocations(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PALLOCATIONS, MemoryUtil.memAddress(value));
    }

    public static void npAllocationsChanged(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PALLOCATIONSCHANGED, MemoryUtil.memAddressSafe(value));
    }

    public static void npoolCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)POOLCOUNT, value);
    }

    public static void npPools(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PPOOLS, MemoryUtil.memAddressSafe(value));
        VmaDefragmentationInfo2.npoolCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nmaxCpuBytesToMove(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MAXCPUBYTESTOMOVE, value);
    }

    public static void nmaxCpuAllocationsToMove(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXCPUALLOCATIONSTOMOVE, value);
    }

    public static void nmaxGpuBytesToMove(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MAXGPUBYTESTOMOVE, value);
    }

    public static void nmaxGpuAllocationsToMove(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXGPUALLOCATIONSTOMOVE, value);
    }

    public static void ncommandBuffer(long struct, @Nullable VkCommandBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)COMMANDBUFFER, MemoryUtil.memAddressSafe(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PALLOCATIONS));
    }

    static {
        Struct.Layout layout = VmaDefragmentationInfo2.__struct(VmaDefragmentationInfo2.__member(4), VmaDefragmentationInfo2.__member(4), VmaDefragmentationInfo2.__member(POINTER_SIZE), VmaDefragmentationInfo2.__member(POINTER_SIZE), VmaDefragmentationInfo2.__member(4), VmaDefragmentationInfo2.__member(POINTER_SIZE), VmaDefragmentationInfo2.__member(8), VmaDefragmentationInfo2.__member(4), VmaDefragmentationInfo2.__member(8), VmaDefragmentationInfo2.__member(4), VmaDefragmentationInfo2.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        ALLOCATIONCOUNT = layout.offsetof(1);
        PALLOCATIONS = layout.offsetof(2);
        PALLOCATIONSCHANGED = layout.offsetof(3);
        POOLCOUNT = layout.offsetof(4);
        PPOOLS = layout.offsetof(5);
        MAXCPUBYTESTOMOVE = layout.offsetof(6);
        MAXCPUALLOCATIONSTOMOVE = layout.offsetof(7);
        MAXGPUBYTESTOMOVE = layout.offsetof(8);
        MAXGPUALLOCATIONSTOMOVE = layout.offsetof(9);
        COMMANDBUFFER = layout.offsetof(10);
    }

    public static class Buffer
    extends StructBuffer<VmaDefragmentationInfo2, Buffer>
    implements NativeResource {
        private static final VmaDefragmentationInfo2 ELEMENT_FACTORY = VmaDefragmentationInfo2.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VmaDefragmentationInfo2 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VmaDefragmentationFlags")
        public int flags() {
            return VmaDefragmentationInfo2.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int allocationCount() {
            return VmaDefragmentationInfo2.nallocationCount(this.address());
        }

        @NativeType(value="VmaAllocation *")
        public PointerBuffer pAllocations() {
            return VmaDefragmentationInfo2.npAllocations(this.address());
        }

        @Nullable
        @NativeType(value="VkBool32 *")
        public IntBuffer pAllocationsChanged() {
            return VmaDefragmentationInfo2.npAllocationsChanged(this.address());
        }

        @NativeType(value="uint32_t")
        public int poolCount() {
            return VmaDefragmentationInfo2.npoolCount(this.address());
        }

        @Nullable
        @NativeType(value="VmaPool const *")
        public PointerBuffer pPools() {
            return VmaDefragmentationInfo2.npPools(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long maxCpuBytesToMove() {
            return VmaDefragmentationInfo2.nmaxCpuBytesToMove(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxCpuAllocationsToMove() {
            return VmaDefragmentationInfo2.nmaxCpuAllocationsToMove(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long maxGpuBytesToMove() {
            return VmaDefragmentationInfo2.nmaxGpuBytesToMove(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxGpuAllocationsToMove() {
            return VmaDefragmentationInfo2.nmaxGpuAllocationsToMove(this.address());
        }

        @Nullable
        @NativeType(value="VkCommandBuffer")
        public long commandBuffer() {
            return VmaDefragmentationInfo2.ncommandBuffer(this.address());
        }

        public Buffer flags(@NativeType(value="VmaDefragmentationFlags") int value) {
            VmaDefragmentationInfo2.nflags(this.address(), value);
            return this;
        }

        public Buffer allocationCount(@NativeType(value="uint32_t") int value) {
            VmaDefragmentationInfo2.nallocationCount(this.address(), value);
            return this;
        }

        public Buffer pAllocations(@NativeType(value="VmaAllocation *") PointerBuffer value) {
            VmaDefragmentationInfo2.npAllocations(this.address(), value);
            return this;
        }

        public Buffer pAllocationsChanged(@Nullable @NativeType(value="VkBool32 *") IntBuffer value) {
            VmaDefragmentationInfo2.npAllocationsChanged(this.address(), value);
            return this;
        }

        public Buffer poolCount(@NativeType(value="uint32_t") int value) {
            VmaDefragmentationInfo2.npoolCount(this.address(), value);
            return this;
        }

        public Buffer pPools(@Nullable @NativeType(value="VmaPool const *") PointerBuffer value) {
            VmaDefragmentationInfo2.npPools(this.address(), value);
            return this;
        }

        public Buffer maxCpuBytesToMove(@NativeType(value="VkDeviceSize") long value) {
            VmaDefragmentationInfo2.nmaxCpuBytesToMove(this.address(), value);
            return this;
        }

        public Buffer maxCpuAllocationsToMove(@NativeType(value="uint32_t") int value) {
            VmaDefragmentationInfo2.nmaxCpuAllocationsToMove(this.address(), value);
            return this;
        }

        public Buffer maxGpuBytesToMove(@NativeType(value="VkDeviceSize") long value) {
            VmaDefragmentationInfo2.nmaxGpuBytesToMove(this.address(), value);
            return this;
        }

        public Buffer maxGpuAllocationsToMove(@NativeType(value="uint32_t") int value) {
            VmaDefragmentationInfo2.nmaxGpuAllocationsToMove(this.address(), value);
            return this;
        }

        public Buffer commandBuffer(@Nullable VkCommandBuffer value) {
            VmaDefragmentationInfo2.ncommandBuffer(this.address(), value);
            return this;
        }
    }
}

