/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VmaDefragmentationInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MAXBYTESTOMOVE;
    public static final int MAXALLOCATIONSTOMOVE;

    public VmaDefragmentationInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VmaDefragmentationInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceSize")
    public long maxBytesToMove() {
        return VmaDefragmentationInfo.nmaxBytesToMove(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxAllocationsToMove() {
        return VmaDefragmentationInfo.nmaxAllocationsToMove(this.address());
    }

    public VmaDefragmentationInfo maxBytesToMove(@NativeType(value="VkDeviceSize") long value) {
        VmaDefragmentationInfo.nmaxBytesToMove(this.address(), value);
        return this;
    }

    public VmaDefragmentationInfo maxAllocationsToMove(@NativeType(value="uint32_t") int value) {
        VmaDefragmentationInfo.nmaxAllocationsToMove(this.address(), value);
        return this;
    }

    public VmaDefragmentationInfo set(long maxBytesToMove, int maxAllocationsToMove) {
        this.maxBytesToMove(maxBytesToMove);
        this.maxAllocationsToMove(maxAllocationsToMove);
        return this;
    }

    public VmaDefragmentationInfo set(VmaDefragmentationInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VmaDefragmentationInfo malloc() {
        return VmaDefragmentationInfo.wrap(VmaDefragmentationInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static VmaDefragmentationInfo calloc() {
        return VmaDefragmentationInfo.wrap(VmaDefragmentationInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static VmaDefragmentationInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return VmaDefragmentationInfo.wrap(VmaDefragmentationInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static VmaDefragmentationInfo create(long address) {
        return VmaDefragmentationInfo.wrap(VmaDefragmentationInfo.class, address);
    }

    @Nullable
    public static VmaDefragmentationInfo createSafe(long address) {
        return address == 0L ? null : VmaDefragmentationInfo.wrap(VmaDefragmentationInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return VmaDefragmentationInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(VmaDefragmentationInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VmaDefragmentationInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VmaDefragmentationInfo.__create(capacity, SIZEOF);
        return VmaDefragmentationInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return VmaDefragmentationInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : VmaDefragmentationInfo.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static VmaDefragmentationInfo mallocStack() {
        return VmaDefragmentationInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VmaDefragmentationInfo callocStack() {
        return VmaDefragmentationInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VmaDefragmentationInfo mallocStack(MemoryStack stack) {
        return VmaDefragmentationInfo.malloc(stack);
    }

    @Deprecated
    public static VmaDefragmentationInfo callocStack(MemoryStack stack) {
        return VmaDefragmentationInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VmaDefragmentationInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VmaDefragmentationInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VmaDefragmentationInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VmaDefragmentationInfo.calloc(capacity, stack);
    }

    public static VmaDefragmentationInfo malloc(MemoryStack stack) {
        return VmaDefragmentationInfo.wrap(VmaDefragmentationInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VmaDefragmentationInfo calloc(MemoryStack stack) {
        return VmaDefragmentationInfo.wrap(VmaDefragmentationInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return VmaDefragmentationInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return VmaDefragmentationInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nmaxBytesToMove(long struct) {
        return UNSAFE.getLong(null, struct + (long)MAXBYTESTOMOVE);
    }

    public static int nmaxAllocationsToMove(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXALLOCATIONSTOMOVE);
    }

    public static void nmaxBytesToMove(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MAXBYTESTOMOVE, value);
    }

    public static void nmaxAllocationsToMove(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXALLOCATIONSTOMOVE, value);
    }

    static {
        Struct.Layout layout = VmaDefragmentationInfo.__struct(VmaDefragmentationInfo.__member(8), VmaDefragmentationInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MAXBYTESTOMOVE = layout.offsetof(0);
        MAXALLOCATIONSTOMOVE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VmaDefragmentationInfo, Buffer>
    implements NativeResource {
        private static final VmaDefragmentationInfo ELEMENT_FACTORY = VmaDefragmentationInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VmaDefragmentationInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceSize")
        public long maxBytesToMove() {
            return VmaDefragmentationInfo.nmaxBytesToMove(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxAllocationsToMove() {
            return VmaDefragmentationInfo.nmaxAllocationsToMove(this.address());
        }

        public Buffer maxBytesToMove(@NativeType(value="VkDeviceSize") long value) {
            VmaDefragmentationInfo.nmaxBytesToMove(this.address(), value);
            return this;
        }

        public Buffer maxAllocationsToMove(@NativeType(value="uint32_t") int value) {
            VmaDefragmentationInfo.nmaxAllocationsToMove(this.address(), value);
            return this;
        }
    }
}

