/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spvc;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct spvc_specialization_constant")
public class SpvcSpecializationConstant
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ID;
    public static final int CONSTANT_ID;

    public SpvcSpecializationConstant(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SpvcSpecializationConstant.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="spvc_constant_id")
    public int id() {
        return SpvcSpecializationConstant.nid(this.address());
    }

    @NativeType(value="unsigned int")
    public int constant_id() {
        return SpvcSpecializationConstant.nconstant_id(this.address());
    }

    public SpvcSpecializationConstant id(@NativeType(value="spvc_constant_id") int value) {
        SpvcSpecializationConstant.nid(this.address(), value);
        return this;
    }

    public SpvcSpecializationConstant constant_id(@NativeType(value="unsigned int") int value) {
        SpvcSpecializationConstant.nconstant_id(this.address(), value);
        return this;
    }

    public SpvcSpecializationConstant set(int id, int constant_id) {
        this.id(id);
        this.constant_id(constant_id);
        return this;
    }

    public SpvcSpecializationConstant set(SpvcSpecializationConstant src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SpvcSpecializationConstant malloc() {
        return SpvcSpecializationConstant.wrap(SpvcSpecializationConstant.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static SpvcSpecializationConstant calloc() {
        return SpvcSpecializationConstant.wrap(SpvcSpecializationConstant.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static SpvcSpecializationConstant create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return SpvcSpecializationConstant.wrap(SpvcSpecializationConstant.class, MemoryUtil.memAddress(container), container);
    }

    public static SpvcSpecializationConstant create(long address) {
        return SpvcSpecializationConstant.wrap(SpvcSpecializationConstant.class, address);
    }

    @Nullable
    public static SpvcSpecializationConstant createSafe(long address) {
        return address == 0L ? null : SpvcSpecializationConstant.wrap(SpvcSpecializationConstant.class, address);
    }

    public static Buffer malloc(int capacity) {
        return SpvcSpecializationConstant.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(SpvcSpecializationConstant.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return SpvcSpecializationConstant.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SpvcSpecializationConstant.__create(capacity, SIZEOF);
        return SpvcSpecializationConstant.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return SpvcSpecializationConstant.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : SpvcSpecializationConstant.wrap(Buffer.class, address, capacity);
    }

    public static SpvcSpecializationConstant malloc(MemoryStack stack) {
        return SpvcSpecializationConstant.wrap(SpvcSpecializationConstant.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static SpvcSpecializationConstant calloc(MemoryStack stack) {
        return SpvcSpecializationConstant.wrap(SpvcSpecializationConstant.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return SpvcSpecializationConstant.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return SpvcSpecializationConstant.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nid(long struct) {
        return UNSAFE.getInt(null, struct + (long)ID);
    }

    public static int nconstant_id(long struct) {
        return UNSAFE.getInt(null, struct + (long)CONSTANT_ID);
    }

    public static void nid(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ID, value);
    }

    public static void nconstant_id(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CONSTANT_ID, value);
    }

    static {
        Struct.Layout layout = SpvcSpecializationConstant.__struct(SpvcSpecializationConstant.__member(4), SpvcSpecializationConstant.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ID = layout.offsetof(0);
        CONSTANT_ID = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<SpvcSpecializationConstant, Buffer>
    implements NativeResource {
        private static final SpvcSpecializationConstant ELEMENT_FACTORY = SpvcSpecializationConstant.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected SpvcSpecializationConstant getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="spvc_constant_id")
        public int id() {
            return SpvcSpecializationConstant.nid(this.address());
        }

        @NativeType(value="unsigned int")
        public int constant_id() {
            return SpvcSpecializationConstant.nconstant_id(this.address());
        }

        public Buffer id(@NativeType(value="spvc_constant_id") int value) {
            SpvcSpecializationConstant.nid(this.address(), value);
            return this;
        }

        public Buffer constant_id(@NativeType(value="unsigned int") int value) {
            SpvcSpecializationConstant.nconstant_id(this.address(), value);
            return this;
        }
    }
}

