/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spvc;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct spvc_reflected_resource")
public class SpvcReflectedResource
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ID;
    public static final int BASE_TYPE_ID;
    public static final int TYPE_ID;
    public static final int NAME;

    public SpvcReflectedResource(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SpvcReflectedResource.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="spvc_variable_id")
    public int id() {
        return SpvcReflectedResource.nid(this.address());
    }

    @NativeType(value="spvc_type_id")
    public int base_type_id() {
        return SpvcReflectedResource.nbase_type_id(this.address());
    }

    @NativeType(value="spvc_type_id")
    public int type_id() {
        return SpvcReflectedResource.ntype_id(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer name() {
        return SpvcReflectedResource.nname(this.address());
    }

    @NativeType(value="char const *")
    public String nameString() {
        return SpvcReflectedResource.nnameString(this.address());
    }

    public SpvcReflectedResource id(@NativeType(value="spvc_variable_id") int value) {
        SpvcReflectedResource.nid(this.address(), value);
        return this;
    }

    public SpvcReflectedResource base_type_id(@NativeType(value="spvc_type_id") int value) {
        SpvcReflectedResource.nbase_type_id(this.address(), value);
        return this;
    }

    public SpvcReflectedResource type_id(@NativeType(value="spvc_type_id") int value) {
        SpvcReflectedResource.ntype_id(this.address(), value);
        return this;
    }

    public SpvcReflectedResource name(@NativeType(value="char const *") ByteBuffer value) {
        SpvcReflectedResource.nname(this.address(), value);
        return this;
    }

    public SpvcReflectedResource set(int id, int base_type_id, int type_id, ByteBuffer name) {
        this.id(id);
        this.base_type_id(base_type_id);
        this.type_id(type_id);
        this.name(name);
        return this;
    }

    public SpvcReflectedResource set(SpvcReflectedResource src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SpvcReflectedResource malloc() {
        return SpvcReflectedResource.wrap(SpvcReflectedResource.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static SpvcReflectedResource calloc() {
        return SpvcReflectedResource.wrap(SpvcReflectedResource.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static SpvcReflectedResource create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return SpvcReflectedResource.wrap(SpvcReflectedResource.class, MemoryUtil.memAddress(container), container);
    }

    public static SpvcReflectedResource create(long address) {
        return SpvcReflectedResource.wrap(SpvcReflectedResource.class, address);
    }

    @Nullable
    public static SpvcReflectedResource createSafe(long address) {
        return address == 0L ? null : SpvcReflectedResource.wrap(SpvcReflectedResource.class, address);
    }

    public static Buffer malloc(int capacity) {
        return SpvcReflectedResource.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(SpvcReflectedResource.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return SpvcReflectedResource.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SpvcReflectedResource.__create(capacity, SIZEOF);
        return SpvcReflectedResource.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return SpvcReflectedResource.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : SpvcReflectedResource.wrap(Buffer.class, address, capacity);
    }

    public static SpvcReflectedResource malloc(MemoryStack stack) {
        return SpvcReflectedResource.wrap(SpvcReflectedResource.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static SpvcReflectedResource calloc(MemoryStack stack) {
        return SpvcReflectedResource.wrap(SpvcReflectedResource.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return SpvcReflectedResource.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return SpvcReflectedResource.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nid(long struct) {
        return UNSAFE.getInt(null, struct + (long)ID);
    }

    public static int nbase_type_id(long struct) {
        return UNSAFE.getInt(null, struct + (long)BASE_TYPE_ID);
    }

    public static int ntype_id(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE_ID);
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    public static void nid(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ID, value);
    }

    public static void nbase_type_id(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BASE_TYPE_ID, value);
    }

    public static void ntype_id(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE_ID, value);
    }

    public static void nname(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
        }
        MemoryUtil.memPutAddress(struct + (long)NAME, MemoryUtil.memAddress(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    static {
        Struct.Layout layout = SpvcReflectedResource.__struct(SpvcReflectedResource.__member(4), SpvcReflectedResource.__member(4), SpvcReflectedResource.__member(4), SpvcReflectedResource.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ID = layout.offsetof(0);
        BASE_TYPE_ID = layout.offsetof(1);
        TYPE_ID = layout.offsetof(2);
        NAME = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<SpvcReflectedResource, Buffer>
    implements NativeResource {
        private static final SpvcReflectedResource ELEMENT_FACTORY = SpvcReflectedResource.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected SpvcReflectedResource getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="spvc_variable_id")
        public int id() {
            return SpvcReflectedResource.nid(this.address());
        }

        @NativeType(value="spvc_type_id")
        public int base_type_id() {
            return SpvcReflectedResource.nbase_type_id(this.address());
        }

        @NativeType(value="spvc_type_id")
        public int type_id() {
            return SpvcReflectedResource.ntype_id(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer name() {
            return SpvcReflectedResource.nname(this.address());
        }

        @NativeType(value="char const *")
        public String nameString() {
            return SpvcReflectedResource.nnameString(this.address());
        }

        public Buffer id(@NativeType(value="spvc_variable_id") int value) {
            SpvcReflectedResource.nid(this.address(), value);
            return this;
        }

        public Buffer base_type_id(@NativeType(value="spvc_type_id") int value) {
            SpvcReflectedResource.nbase_type_id(this.address(), value);
            return this;
        }

        public Buffer type_id(@NativeType(value="spvc_type_id") int value) {
            SpvcReflectedResource.ntype_id(this.address(), value);
            return this;
        }

        public Buffer name(@NativeType(value="char const *") ByteBuffer value) {
            SpvcReflectedResource.nname(this.address(), value);
            return this;
        }
    }
}

