/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spvc;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct spvc_msl_vertex_attribute")
public class SpvcMslVertexAttribute
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LOCATION;
    public static final int MSL_BUFFER;
    public static final int MSL_OFFSET;
    public static final int MSL_STRIDE;
    public static final int PER_INSTANCE;
    public static final int FORMAT;
    public static final int BUILTIN;

    public SpvcMslVertexAttribute(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SpvcMslVertexAttribute.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int location() {
        return SpvcMslVertexAttribute.nlocation(this.address());
    }

    @NativeType(value="unsigned int")
    public int msl_buffer() {
        return SpvcMslVertexAttribute.nmsl_buffer(this.address());
    }

    @NativeType(value="unsigned int")
    public int msl_offset() {
        return SpvcMslVertexAttribute.nmsl_offset(this.address());
    }

    @NativeType(value="unsigned int")
    public int msl_stride() {
        return SpvcMslVertexAttribute.nmsl_stride(this.address());
    }

    @NativeType(value="spvc_bool")
    public boolean per_instance() {
        return SpvcMslVertexAttribute.nper_instance(this.address());
    }

    @NativeType(value="spvc_msl_vertex_format")
    public int format() {
        return SpvcMslVertexAttribute.nformat(this.address());
    }

    @NativeType(value="SpvBuiltIn")
    public int builtin() {
        return SpvcMslVertexAttribute.nbuiltin(this.address());
    }

    public SpvcMslVertexAttribute location(@NativeType(value="unsigned int") int value) {
        SpvcMslVertexAttribute.nlocation(this.address(), value);
        return this;
    }

    public SpvcMslVertexAttribute msl_buffer(@NativeType(value="unsigned int") int value) {
        SpvcMslVertexAttribute.nmsl_buffer(this.address(), value);
        return this;
    }

    public SpvcMslVertexAttribute msl_offset(@NativeType(value="unsigned int") int value) {
        SpvcMslVertexAttribute.nmsl_offset(this.address(), value);
        return this;
    }

    public SpvcMslVertexAttribute msl_stride(@NativeType(value="unsigned int") int value) {
        SpvcMslVertexAttribute.nmsl_stride(this.address(), value);
        return this;
    }

    public SpvcMslVertexAttribute per_instance(@NativeType(value="spvc_bool") boolean value) {
        SpvcMslVertexAttribute.nper_instance(this.address(), value);
        return this;
    }

    public SpvcMslVertexAttribute format(@NativeType(value="spvc_msl_vertex_format") int value) {
        SpvcMslVertexAttribute.nformat(this.address(), value);
        return this;
    }

    public SpvcMslVertexAttribute builtin(@NativeType(value="SpvBuiltIn") int value) {
        SpvcMslVertexAttribute.nbuiltin(this.address(), value);
        return this;
    }

    public SpvcMslVertexAttribute set(int location, int msl_buffer, int msl_offset, int msl_stride, boolean per_instance, int format, int builtin) {
        this.location(location);
        this.msl_buffer(msl_buffer);
        this.msl_offset(msl_offset);
        this.msl_stride(msl_stride);
        this.per_instance(per_instance);
        this.format(format);
        this.builtin(builtin);
        return this;
    }

    public SpvcMslVertexAttribute set(SpvcMslVertexAttribute src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SpvcMslVertexAttribute malloc() {
        return SpvcMslVertexAttribute.wrap(SpvcMslVertexAttribute.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static SpvcMslVertexAttribute calloc() {
        return SpvcMslVertexAttribute.wrap(SpvcMslVertexAttribute.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static SpvcMslVertexAttribute create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return SpvcMslVertexAttribute.wrap(SpvcMslVertexAttribute.class, MemoryUtil.memAddress(container), container);
    }

    public static SpvcMslVertexAttribute create(long address) {
        return SpvcMslVertexAttribute.wrap(SpvcMslVertexAttribute.class, address);
    }

    @Nullable
    public static SpvcMslVertexAttribute createSafe(long address) {
        return address == 0L ? null : SpvcMslVertexAttribute.wrap(SpvcMslVertexAttribute.class, address);
    }

    public static Buffer malloc(int capacity) {
        return SpvcMslVertexAttribute.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(SpvcMslVertexAttribute.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return SpvcMslVertexAttribute.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SpvcMslVertexAttribute.__create(capacity, SIZEOF);
        return SpvcMslVertexAttribute.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return SpvcMslVertexAttribute.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : SpvcMslVertexAttribute.wrap(Buffer.class, address, capacity);
    }

    public static SpvcMslVertexAttribute malloc(MemoryStack stack) {
        return SpvcMslVertexAttribute.wrap(SpvcMslVertexAttribute.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static SpvcMslVertexAttribute calloc(MemoryStack stack) {
        return SpvcMslVertexAttribute.wrap(SpvcMslVertexAttribute.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return SpvcMslVertexAttribute.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return SpvcMslVertexAttribute.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nlocation(long struct) {
        return UNSAFE.getInt(null, struct + (long)LOCATION);
    }

    public static int nmsl_buffer(long struct) {
        return UNSAFE.getInt(null, struct + (long)MSL_BUFFER);
    }

    public static int nmsl_offset(long struct) {
        return UNSAFE.getInt(null, struct + (long)MSL_OFFSET);
    }

    public static int nmsl_stride(long struct) {
        return UNSAFE.getInt(null, struct + (long)MSL_STRIDE);
    }

    public static boolean nper_instance(long struct) {
        return UNSAFE.getByte(null, struct + (long)PER_INSTANCE) != 0;
    }

    public static int nformat(long struct) {
        return UNSAFE.getInt(null, struct + (long)FORMAT);
    }

    public static int nbuiltin(long struct) {
        return UNSAFE.getInt(null, struct + (long)BUILTIN);
    }

    public static void nlocation(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LOCATION, value);
    }

    public static void nmsl_buffer(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MSL_BUFFER, value);
    }

    public static void nmsl_offset(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MSL_OFFSET, value);
    }

    public static void nmsl_stride(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MSL_STRIDE, value);
    }

    public static void nper_instance(long struct, boolean value) {
        UNSAFE.putByte(null, struct + (long)PER_INSTANCE, value ? (byte)1 : 0);
    }

    public static void nformat(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FORMAT, value);
    }

    public static void nbuiltin(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BUILTIN, value);
    }

    static {
        Struct.Layout layout = SpvcMslVertexAttribute.__struct(SpvcMslVertexAttribute.__member(4), SpvcMslVertexAttribute.__member(4), SpvcMslVertexAttribute.__member(4), SpvcMslVertexAttribute.__member(4), SpvcMslVertexAttribute.__member(1), SpvcMslVertexAttribute.__member(4), SpvcMslVertexAttribute.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LOCATION = layout.offsetof(0);
        MSL_BUFFER = layout.offsetof(1);
        MSL_OFFSET = layout.offsetof(2);
        MSL_STRIDE = layout.offsetof(3);
        PER_INSTANCE = layout.offsetof(4);
        FORMAT = layout.offsetof(5);
        BUILTIN = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<SpvcMslVertexAttribute, Buffer>
    implements NativeResource {
        private static final SpvcMslVertexAttribute ELEMENT_FACTORY = SpvcMslVertexAttribute.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected SpvcMslVertexAttribute getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int location() {
            return SpvcMslVertexAttribute.nlocation(this.address());
        }

        @NativeType(value="unsigned int")
        public int msl_buffer() {
            return SpvcMslVertexAttribute.nmsl_buffer(this.address());
        }

        @NativeType(value="unsigned int")
        public int msl_offset() {
            return SpvcMslVertexAttribute.nmsl_offset(this.address());
        }

        @NativeType(value="unsigned int")
        public int msl_stride() {
            return SpvcMslVertexAttribute.nmsl_stride(this.address());
        }

        @NativeType(value="spvc_bool")
        public boolean per_instance() {
            return SpvcMslVertexAttribute.nper_instance(this.address());
        }

        @NativeType(value="spvc_msl_vertex_format")
        public int format() {
            return SpvcMslVertexAttribute.nformat(this.address());
        }

        @NativeType(value="SpvBuiltIn")
        public int builtin() {
            return SpvcMslVertexAttribute.nbuiltin(this.address());
        }

        public Buffer location(@NativeType(value="unsigned int") int value) {
            SpvcMslVertexAttribute.nlocation(this.address(), value);
            return this;
        }

        public Buffer msl_buffer(@NativeType(value="unsigned int") int value) {
            SpvcMslVertexAttribute.nmsl_buffer(this.address(), value);
            return this;
        }

        public Buffer msl_offset(@NativeType(value="unsigned int") int value) {
            SpvcMslVertexAttribute.nmsl_offset(this.address(), value);
            return this;
        }

        public Buffer msl_stride(@NativeType(value="unsigned int") int value) {
            SpvcMslVertexAttribute.nmsl_stride(this.address(), value);
            return this;
        }

        public Buffer per_instance(@NativeType(value="spvc_bool") boolean value) {
            SpvcMslVertexAttribute.nper_instance(this.address(), value);
            return this;
        }

        public Buffer format(@NativeType(value="spvc_msl_vertex_format") int value) {
            SpvcMslVertexAttribute.nformat(this.address(), value);
            return this;
        }

        public Buffer builtin(@NativeType(value="SpvBuiltIn") int value) {
            SpvcMslVertexAttribute.nbuiltin(this.address(), value);
            return this;
        }
    }
}

