/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spvc;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct spvc_msl_shader_input")
public class SpvcMslShaderInput
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LOCATION;
    public static final int FORMAT;
    public static final int BUILTIN;
    public static final int VECSIZE;

    public SpvcMslShaderInput(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SpvcMslShaderInput.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned")
    public int location() {
        return SpvcMslShaderInput.nlocation(this.address());
    }

    @NativeType(value="spvc_msl_vertex_format")
    public int format() {
        return SpvcMslShaderInput.nformat(this.address());
    }

    @NativeType(value="SpvBuiltIn")
    public int builtin() {
        return SpvcMslShaderInput.nbuiltin(this.address());
    }

    @NativeType(value="unsigned")
    public int vecsize() {
        return SpvcMslShaderInput.nvecsize(this.address());
    }

    public SpvcMslShaderInput location(@NativeType(value="unsigned") int value) {
        SpvcMslShaderInput.nlocation(this.address(), value);
        return this;
    }

    public SpvcMslShaderInput format(@NativeType(value="spvc_msl_vertex_format") int value) {
        SpvcMslShaderInput.nformat(this.address(), value);
        return this;
    }

    public SpvcMslShaderInput builtin(@NativeType(value="SpvBuiltIn") int value) {
        SpvcMslShaderInput.nbuiltin(this.address(), value);
        return this;
    }

    public SpvcMslShaderInput vecsize(@NativeType(value="unsigned") int value) {
        SpvcMslShaderInput.nvecsize(this.address(), value);
        return this;
    }

    public SpvcMslShaderInput set(int location, int format, int builtin, int vecsize) {
        this.location(location);
        this.format(format);
        this.builtin(builtin);
        this.vecsize(vecsize);
        return this;
    }

    public SpvcMslShaderInput set(SpvcMslShaderInput src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SpvcMslShaderInput malloc() {
        return SpvcMslShaderInput.wrap(SpvcMslShaderInput.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static SpvcMslShaderInput calloc() {
        return SpvcMslShaderInput.wrap(SpvcMslShaderInput.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static SpvcMslShaderInput create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return SpvcMslShaderInput.wrap(SpvcMslShaderInput.class, MemoryUtil.memAddress(container), container);
    }

    public static SpvcMslShaderInput create(long address) {
        return SpvcMslShaderInput.wrap(SpvcMslShaderInput.class, address);
    }

    @Nullable
    public static SpvcMslShaderInput createSafe(long address) {
        return address == 0L ? null : SpvcMslShaderInput.wrap(SpvcMslShaderInput.class, address);
    }

    public static Buffer malloc(int capacity) {
        return SpvcMslShaderInput.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(SpvcMslShaderInput.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return SpvcMslShaderInput.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SpvcMslShaderInput.__create(capacity, SIZEOF);
        return SpvcMslShaderInput.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return SpvcMslShaderInput.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : SpvcMslShaderInput.wrap(Buffer.class, address, capacity);
    }

    public static SpvcMslShaderInput malloc(MemoryStack stack) {
        return SpvcMslShaderInput.wrap(SpvcMslShaderInput.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static SpvcMslShaderInput calloc(MemoryStack stack) {
        return SpvcMslShaderInput.wrap(SpvcMslShaderInput.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return SpvcMslShaderInput.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return SpvcMslShaderInput.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nlocation(long struct) {
        return UNSAFE.getInt(null, struct + (long)LOCATION);
    }

    public static int nformat(long struct) {
        return UNSAFE.getInt(null, struct + (long)FORMAT);
    }

    public static int nbuiltin(long struct) {
        return UNSAFE.getInt(null, struct + (long)BUILTIN);
    }

    public static int nvecsize(long struct) {
        return UNSAFE.getInt(null, struct + (long)VECSIZE);
    }

    public static void nlocation(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LOCATION, value);
    }

    public static void nformat(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FORMAT, value);
    }

    public static void nbuiltin(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BUILTIN, value);
    }

    public static void nvecsize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VECSIZE, value);
    }

    static {
        Struct.Layout layout = SpvcMslShaderInput.__struct(SpvcMslShaderInput.__member(4), SpvcMslShaderInput.__member(4), SpvcMslShaderInput.__member(4), SpvcMslShaderInput.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LOCATION = layout.offsetof(0);
        FORMAT = layout.offsetof(1);
        BUILTIN = layout.offsetof(2);
        VECSIZE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<SpvcMslShaderInput, Buffer>
    implements NativeResource {
        private static final SpvcMslShaderInput ELEMENT_FACTORY = SpvcMslShaderInput.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected SpvcMslShaderInput getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned")
        public int location() {
            return SpvcMslShaderInput.nlocation(this.address());
        }

        @NativeType(value="spvc_msl_vertex_format")
        public int format() {
            return SpvcMslShaderInput.nformat(this.address());
        }

        @NativeType(value="SpvBuiltIn")
        public int builtin() {
            return SpvcMslShaderInput.nbuiltin(this.address());
        }

        @NativeType(value="unsigned")
        public int vecsize() {
            return SpvcMslShaderInput.nvecsize(this.address());
        }

        public Buffer location(@NativeType(value="unsigned") int value) {
            SpvcMslShaderInput.nlocation(this.address(), value);
            return this;
        }

        public Buffer format(@NativeType(value="spvc_msl_vertex_format") int value) {
            SpvcMslShaderInput.nformat(this.address(), value);
            return this;
        }

        public Buffer builtin(@NativeType(value="SpvBuiltIn") int value) {
            SpvcMslShaderInput.nbuiltin(this.address(), value);
            return this;
        }

        public Buffer vecsize(@NativeType(value="unsigned") int value) {
            SpvcMslShaderInput.nvecsize(this.address(), value);
            return this;
        }
    }
}

