/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spvc;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct spvc_msl_constexpr_sampler")
public class SpvcMslConstexprSampler
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int COORD;
    public static final int MIN_FILTER;
    public static final int MAG_FILTER;
    public static final int MIP_FILTER;
    public static final int S_ADDRESS;
    public static final int T_ADDRESS;
    public static final int R_ADDRESS;
    public static final int COMPARE_FUNC;
    public static final int BORDER_COLOR;
    public static final int LOD_CLAMP_MIN;
    public static final int LOD_CLAMP_MAX;
    public static final int MAX_ANISOTROPY;
    public static final int COMPARE_ENABLE;
    public static final int LOD_CLAMP_ENABLE;
    public static final int ANISOTROPY_ENABLE;

    public SpvcMslConstexprSampler(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SpvcMslConstexprSampler.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="spvc_msl_sampler_coord")
    public int coord() {
        return SpvcMslConstexprSampler.ncoord(this.address());
    }

    @NativeType(value="spvc_msl_sampler_filter")
    public int min_filter() {
        return SpvcMslConstexprSampler.nmin_filter(this.address());
    }

    @NativeType(value="spvc_msl_sampler_filter")
    public int mag_filter() {
        return SpvcMslConstexprSampler.nmag_filter(this.address());
    }

    @NativeType(value="spvc_msl_sampler_mip_filter")
    public int mip_filter() {
        return SpvcMslConstexprSampler.nmip_filter(this.address());
    }

    @NativeType(value="spvc_msl_sampler_address")
    public int s_address() {
        return SpvcMslConstexprSampler.ns_address(this.address());
    }

    @NativeType(value="spvc_msl_sampler_address")
    public int t_address() {
        return SpvcMslConstexprSampler.nt_address(this.address());
    }

    @NativeType(value="spvc_msl_sampler_address")
    public int r_address() {
        return SpvcMslConstexprSampler.nr_address(this.address());
    }

    @NativeType(value="spvc_msl_sampler_compare_func")
    public int compare_func() {
        return SpvcMslConstexprSampler.ncompare_func(this.address());
    }

    @NativeType(value="spvc_msl_sampler_border_color")
    public int border_color() {
        return SpvcMslConstexprSampler.nborder_color(this.address());
    }

    public float lod_clamp_min() {
        return SpvcMslConstexprSampler.nlod_clamp_min(this.address());
    }

    public float lod_clamp_max() {
        return SpvcMslConstexprSampler.nlod_clamp_max(this.address());
    }

    public int max_anisotropy() {
        return SpvcMslConstexprSampler.nmax_anisotropy(this.address());
    }

    @NativeType(value="spvc_bool")
    public boolean compare_enable() {
        return SpvcMslConstexprSampler.ncompare_enable(this.address());
    }

    @NativeType(value="spvc_bool")
    public boolean lod_clamp_enable() {
        return SpvcMslConstexprSampler.nlod_clamp_enable(this.address());
    }

    @NativeType(value="spvc_bool")
    public boolean anisotropy_enable() {
        return SpvcMslConstexprSampler.nanisotropy_enable(this.address());
    }

    public SpvcMslConstexprSampler coord(@NativeType(value="spvc_msl_sampler_coord") int value) {
        SpvcMslConstexprSampler.ncoord(this.address(), value);
        return this;
    }

    public SpvcMslConstexprSampler min_filter(@NativeType(value="spvc_msl_sampler_filter") int value) {
        SpvcMslConstexprSampler.nmin_filter(this.address(), value);
        return this;
    }

    public SpvcMslConstexprSampler mag_filter(@NativeType(value="spvc_msl_sampler_filter") int value) {
        SpvcMslConstexprSampler.nmag_filter(this.address(), value);
        return this;
    }

    public SpvcMslConstexprSampler mip_filter(@NativeType(value="spvc_msl_sampler_mip_filter") int value) {
        SpvcMslConstexprSampler.nmip_filter(this.address(), value);
        return this;
    }

    public SpvcMslConstexprSampler s_address(@NativeType(value="spvc_msl_sampler_address") int value) {
        SpvcMslConstexprSampler.ns_address(this.address(), value);
        return this;
    }

    public SpvcMslConstexprSampler t_address(@NativeType(value="spvc_msl_sampler_address") int value) {
        SpvcMslConstexprSampler.nt_address(this.address(), value);
        return this;
    }

    public SpvcMslConstexprSampler r_address(@NativeType(value="spvc_msl_sampler_address") int value) {
        SpvcMslConstexprSampler.nr_address(this.address(), value);
        return this;
    }

    public SpvcMslConstexprSampler compare_func(@NativeType(value="spvc_msl_sampler_compare_func") int value) {
        SpvcMslConstexprSampler.ncompare_func(this.address(), value);
        return this;
    }

    public SpvcMslConstexprSampler border_color(@NativeType(value="spvc_msl_sampler_border_color") int value) {
        SpvcMslConstexprSampler.nborder_color(this.address(), value);
        return this;
    }

    public SpvcMslConstexprSampler lod_clamp_min(float value) {
        SpvcMslConstexprSampler.nlod_clamp_min(this.address(), value);
        return this;
    }

    public SpvcMslConstexprSampler lod_clamp_max(float value) {
        SpvcMslConstexprSampler.nlod_clamp_max(this.address(), value);
        return this;
    }

    public SpvcMslConstexprSampler max_anisotropy(int value) {
        SpvcMslConstexprSampler.nmax_anisotropy(this.address(), value);
        return this;
    }

    public SpvcMslConstexprSampler compare_enable(@NativeType(value="spvc_bool") boolean value) {
        SpvcMslConstexprSampler.ncompare_enable(this.address(), value);
        return this;
    }

    public SpvcMslConstexprSampler lod_clamp_enable(@NativeType(value="spvc_bool") boolean value) {
        SpvcMslConstexprSampler.nlod_clamp_enable(this.address(), value);
        return this;
    }

    public SpvcMslConstexprSampler anisotropy_enable(@NativeType(value="spvc_bool") boolean value) {
        SpvcMslConstexprSampler.nanisotropy_enable(this.address(), value);
        return this;
    }

    public SpvcMslConstexprSampler set(int coord, int min_filter, int mag_filter, int mip_filter, int s_address, int t_address, int r_address, int compare_func, int border_color, float lod_clamp_min, float lod_clamp_max, int max_anisotropy, boolean compare_enable, boolean lod_clamp_enable, boolean anisotropy_enable) {
        this.coord(coord);
        this.min_filter(min_filter);
        this.mag_filter(mag_filter);
        this.mip_filter(mip_filter);
        this.s_address(s_address);
        this.t_address(t_address);
        this.r_address(r_address);
        this.compare_func(compare_func);
        this.border_color(border_color);
        this.lod_clamp_min(lod_clamp_min);
        this.lod_clamp_max(lod_clamp_max);
        this.max_anisotropy(max_anisotropy);
        this.compare_enable(compare_enable);
        this.lod_clamp_enable(lod_clamp_enable);
        this.anisotropy_enable(anisotropy_enable);
        return this;
    }

    public SpvcMslConstexprSampler set(SpvcMslConstexprSampler src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SpvcMslConstexprSampler malloc() {
        return SpvcMslConstexprSampler.wrap(SpvcMslConstexprSampler.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static SpvcMslConstexprSampler calloc() {
        return SpvcMslConstexprSampler.wrap(SpvcMslConstexprSampler.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static SpvcMslConstexprSampler create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return SpvcMslConstexprSampler.wrap(SpvcMslConstexprSampler.class, MemoryUtil.memAddress(container), container);
    }

    public static SpvcMslConstexprSampler create(long address) {
        return SpvcMslConstexprSampler.wrap(SpvcMslConstexprSampler.class, address);
    }

    @Nullable
    public static SpvcMslConstexprSampler createSafe(long address) {
        return address == 0L ? null : SpvcMslConstexprSampler.wrap(SpvcMslConstexprSampler.class, address);
    }

    public static Buffer malloc(int capacity) {
        return SpvcMslConstexprSampler.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(SpvcMslConstexprSampler.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return SpvcMslConstexprSampler.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SpvcMslConstexprSampler.__create(capacity, SIZEOF);
        return SpvcMslConstexprSampler.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return SpvcMslConstexprSampler.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : SpvcMslConstexprSampler.wrap(Buffer.class, address, capacity);
    }

    public static SpvcMslConstexprSampler malloc(MemoryStack stack) {
        return SpvcMslConstexprSampler.wrap(SpvcMslConstexprSampler.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static SpvcMslConstexprSampler calloc(MemoryStack stack) {
        return SpvcMslConstexprSampler.wrap(SpvcMslConstexprSampler.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return SpvcMslConstexprSampler.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return SpvcMslConstexprSampler.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ncoord(long struct) {
        return UNSAFE.getInt(null, struct + (long)COORD);
    }

    public static int nmin_filter(long struct) {
        return UNSAFE.getInt(null, struct + (long)MIN_FILTER);
    }

    public static int nmag_filter(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAG_FILTER);
    }

    public static int nmip_filter(long struct) {
        return UNSAFE.getInt(null, struct + (long)MIP_FILTER);
    }

    public static int ns_address(long struct) {
        return UNSAFE.getInt(null, struct + (long)S_ADDRESS);
    }

    public static int nt_address(long struct) {
        return UNSAFE.getInt(null, struct + (long)T_ADDRESS);
    }

    public static int nr_address(long struct) {
        return UNSAFE.getInt(null, struct + (long)R_ADDRESS);
    }

    public static int ncompare_func(long struct) {
        return UNSAFE.getInt(null, struct + (long)COMPARE_FUNC);
    }

    public static int nborder_color(long struct) {
        return UNSAFE.getInt(null, struct + (long)BORDER_COLOR);
    }

    public static float nlod_clamp_min(long struct) {
        return UNSAFE.getFloat(null, struct + (long)LOD_CLAMP_MIN);
    }

    public static float nlod_clamp_max(long struct) {
        return UNSAFE.getFloat(null, struct + (long)LOD_CLAMP_MAX);
    }

    public static int nmax_anisotropy(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAX_ANISOTROPY);
    }

    public static boolean ncompare_enable(long struct) {
        return UNSAFE.getByte(null, struct + (long)COMPARE_ENABLE) != 0;
    }

    public static boolean nlod_clamp_enable(long struct) {
        return UNSAFE.getByte(null, struct + (long)LOD_CLAMP_ENABLE) != 0;
    }

    public static boolean nanisotropy_enable(long struct) {
        return UNSAFE.getByte(null, struct + (long)ANISOTROPY_ENABLE) != 0;
    }

    public static void ncoord(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COORD, value);
    }

    public static void nmin_filter(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MIN_FILTER, value);
    }

    public static void nmag_filter(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAG_FILTER, value);
    }

    public static void nmip_filter(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MIP_FILTER, value);
    }

    public static void ns_address(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)S_ADDRESS, value);
    }

    public static void nt_address(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)T_ADDRESS, value);
    }

    public static void nr_address(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)R_ADDRESS, value);
    }

    public static void ncompare_func(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COMPARE_FUNC, value);
    }

    public static void nborder_color(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BORDER_COLOR, value);
    }

    public static void nlod_clamp_min(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)LOD_CLAMP_MIN, value);
    }

    public static void nlod_clamp_max(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)LOD_CLAMP_MAX, value);
    }

    public static void nmax_anisotropy(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAX_ANISOTROPY, value);
    }

    public static void ncompare_enable(long struct, boolean value) {
        UNSAFE.putByte(null, struct + (long)COMPARE_ENABLE, value ? (byte)1 : 0);
    }

    public static void nlod_clamp_enable(long struct, boolean value) {
        UNSAFE.putByte(null, struct + (long)LOD_CLAMP_ENABLE, value ? (byte)1 : 0);
    }

    public static void nanisotropy_enable(long struct, boolean value) {
        UNSAFE.putByte(null, struct + (long)ANISOTROPY_ENABLE, value ? (byte)1 : 0);
    }

    static {
        Struct.Layout layout = SpvcMslConstexprSampler.__struct(SpvcMslConstexprSampler.__member(4), SpvcMslConstexprSampler.__member(4), SpvcMslConstexprSampler.__member(4), SpvcMslConstexprSampler.__member(4), SpvcMslConstexprSampler.__member(4), SpvcMslConstexprSampler.__member(4), SpvcMslConstexprSampler.__member(4), SpvcMslConstexprSampler.__member(4), SpvcMslConstexprSampler.__member(4), SpvcMslConstexprSampler.__member(4), SpvcMslConstexprSampler.__member(4), SpvcMslConstexprSampler.__member(4), SpvcMslConstexprSampler.__member(1), SpvcMslConstexprSampler.__member(1), SpvcMslConstexprSampler.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        COORD = layout.offsetof(0);
        MIN_FILTER = layout.offsetof(1);
        MAG_FILTER = layout.offsetof(2);
        MIP_FILTER = layout.offsetof(3);
        S_ADDRESS = layout.offsetof(4);
        T_ADDRESS = layout.offsetof(5);
        R_ADDRESS = layout.offsetof(6);
        COMPARE_FUNC = layout.offsetof(7);
        BORDER_COLOR = layout.offsetof(8);
        LOD_CLAMP_MIN = layout.offsetof(9);
        LOD_CLAMP_MAX = layout.offsetof(10);
        MAX_ANISOTROPY = layout.offsetof(11);
        COMPARE_ENABLE = layout.offsetof(12);
        LOD_CLAMP_ENABLE = layout.offsetof(13);
        ANISOTROPY_ENABLE = layout.offsetof(14);
    }

    public static class Buffer
    extends StructBuffer<SpvcMslConstexprSampler, Buffer>
    implements NativeResource {
        private static final SpvcMslConstexprSampler ELEMENT_FACTORY = SpvcMslConstexprSampler.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected SpvcMslConstexprSampler getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="spvc_msl_sampler_coord")
        public int coord() {
            return SpvcMslConstexprSampler.ncoord(this.address());
        }

        @NativeType(value="spvc_msl_sampler_filter")
        public int min_filter() {
            return SpvcMslConstexprSampler.nmin_filter(this.address());
        }

        @NativeType(value="spvc_msl_sampler_filter")
        public int mag_filter() {
            return SpvcMslConstexprSampler.nmag_filter(this.address());
        }

        @NativeType(value="spvc_msl_sampler_mip_filter")
        public int mip_filter() {
            return SpvcMslConstexprSampler.nmip_filter(this.address());
        }

        @NativeType(value="spvc_msl_sampler_address")
        public int s_address() {
            return SpvcMslConstexprSampler.ns_address(this.address());
        }

        @NativeType(value="spvc_msl_sampler_address")
        public int t_address() {
            return SpvcMslConstexprSampler.nt_address(this.address());
        }

        @NativeType(value="spvc_msl_sampler_address")
        public int r_address() {
            return SpvcMslConstexprSampler.nr_address(this.address());
        }

        @NativeType(value="spvc_msl_sampler_compare_func")
        public int compare_func() {
            return SpvcMslConstexprSampler.ncompare_func(this.address());
        }

        @NativeType(value="spvc_msl_sampler_border_color")
        public int border_color() {
            return SpvcMslConstexprSampler.nborder_color(this.address());
        }

        public float lod_clamp_min() {
            return SpvcMslConstexprSampler.nlod_clamp_min(this.address());
        }

        public float lod_clamp_max() {
            return SpvcMslConstexprSampler.nlod_clamp_max(this.address());
        }

        public int max_anisotropy() {
            return SpvcMslConstexprSampler.nmax_anisotropy(this.address());
        }

        @NativeType(value="spvc_bool")
        public boolean compare_enable() {
            return SpvcMslConstexprSampler.ncompare_enable(this.address());
        }

        @NativeType(value="spvc_bool")
        public boolean lod_clamp_enable() {
            return SpvcMslConstexprSampler.nlod_clamp_enable(this.address());
        }

        @NativeType(value="spvc_bool")
        public boolean anisotropy_enable() {
            return SpvcMslConstexprSampler.nanisotropy_enable(this.address());
        }

        public Buffer coord(@NativeType(value="spvc_msl_sampler_coord") int value) {
            SpvcMslConstexprSampler.ncoord(this.address(), value);
            return this;
        }

        public Buffer min_filter(@NativeType(value="spvc_msl_sampler_filter") int value) {
            SpvcMslConstexprSampler.nmin_filter(this.address(), value);
            return this;
        }

        public Buffer mag_filter(@NativeType(value="spvc_msl_sampler_filter") int value) {
            SpvcMslConstexprSampler.nmag_filter(this.address(), value);
            return this;
        }

        public Buffer mip_filter(@NativeType(value="spvc_msl_sampler_mip_filter") int value) {
            SpvcMslConstexprSampler.nmip_filter(this.address(), value);
            return this;
        }

        public Buffer s_address(@NativeType(value="spvc_msl_sampler_address") int value) {
            SpvcMslConstexprSampler.ns_address(this.address(), value);
            return this;
        }

        public Buffer t_address(@NativeType(value="spvc_msl_sampler_address") int value) {
            SpvcMslConstexprSampler.nt_address(this.address(), value);
            return this;
        }

        public Buffer r_address(@NativeType(value="spvc_msl_sampler_address") int value) {
            SpvcMslConstexprSampler.nr_address(this.address(), value);
            return this;
        }

        public Buffer compare_func(@NativeType(value="spvc_msl_sampler_compare_func") int value) {
            SpvcMslConstexprSampler.ncompare_func(this.address(), value);
            return this;
        }

        public Buffer border_color(@NativeType(value="spvc_msl_sampler_border_color") int value) {
            SpvcMslConstexprSampler.nborder_color(this.address(), value);
            return this;
        }

        public Buffer lod_clamp_min(float value) {
            SpvcMslConstexprSampler.nlod_clamp_min(this.address(), value);
            return this;
        }

        public Buffer lod_clamp_max(float value) {
            SpvcMslConstexprSampler.nlod_clamp_max(this.address(), value);
            return this;
        }

        public Buffer max_anisotropy(int value) {
            SpvcMslConstexprSampler.nmax_anisotropy(this.address(), value);
            return this;
        }

        public Buffer compare_enable(@NativeType(value="spvc_bool") boolean value) {
            SpvcMslConstexprSampler.ncompare_enable(this.address(), value);
            return this;
        }

        public Buffer lod_clamp_enable(@NativeType(value="spvc_bool") boolean value) {
            SpvcMslConstexprSampler.nlod_clamp_enable(this.address(), value);
            return this;
        }

        public Buffer anisotropy_enable(@NativeType(value="spvc_bool") boolean value) {
            SpvcMslConstexprSampler.nanisotropy_enable(this.address(), value);
            return this;
        }
    }
}

