/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.spvc;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct spvc_entry_point")
public class SpvcEntryPoint
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int EXECUTION_MODEL;
    public static final int NAME;

    public SpvcEntryPoint(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), SpvcEntryPoint.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="SpvExecutionModel")
    public int execution_model() {
        return SpvcEntryPoint.nexecution_model(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer name() {
        return SpvcEntryPoint.nname(this.address());
    }

    @NativeType(value="char const *")
    public String nameString() {
        return SpvcEntryPoint.nnameString(this.address());
    }

    public SpvcEntryPoint execution_model(@NativeType(value="SpvExecutionModel") int value) {
        SpvcEntryPoint.nexecution_model(this.address(), value);
        return this;
    }

    public SpvcEntryPoint name(@NativeType(value="char const *") ByteBuffer value) {
        SpvcEntryPoint.nname(this.address(), value);
        return this;
    }

    public SpvcEntryPoint set(int execution_model, ByteBuffer name) {
        this.execution_model(execution_model);
        this.name(name);
        return this;
    }

    public SpvcEntryPoint set(SpvcEntryPoint src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static SpvcEntryPoint malloc() {
        return SpvcEntryPoint.wrap(SpvcEntryPoint.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static SpvcEntryPoint calloc() {
        return SpvcEntryPoint.wrap(SpvcEntryPoint.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static SpvcEntryPoint create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return SpvcEntryPoint.wrap(SpvcEntryPoint.class, MemoryUtil.memAddress(container), container);
    }

    public static SpvcEntryPoint create(long address) {
        return SpvcEntryPoint.wrap(SpvcEntryPoint.class, address);
    }

    @Nullable
    public static SpvcEntryPoint createSafe(long address) {
        return address == 0L ? null : SpvcEntryPoint.wrap(SpvcEntryPoint.class, address);
    }

    public static Buffer malloc(int capacity) {
        return SpvcEntryPoint.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(SpvcEntryPoint.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return SpvcEntryPoint.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = SpvcEntryPoint.__create(capacity, SIZEOF);
        return SpvcEntryPoint.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return SpvcEntryPoint.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : SpvcEntryPoint.wrap(Buffer.class, address, capacity);
    }

    public static SpvcEntryPoint malloc(MemoryStack stack) {
        return SpvcEntryPoint.wrap(SpvcEntryPoint.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static SpvcEntryPoint calloc(MemoryStack stack) {
        return SpvcEntryPoint.wrap(SpvcEntryPoint.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return SpvcEntryPoint.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return SpvcEntryPoint.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nexecution_model(long struct) {
        return UNSAFE.getInt(null, struct + (long)EXECUTION_MODEL);
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    public static void nexecution_model(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)EXECUTION_MODEL, value);
    }

    public static void nname(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
        }
        MemoryUtil.memPutAddress(struct + (long)NAME, MemoryUtil.memAddress(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    static {
        Struct.Layout layout = SpvcEntryPoint.__struct(SpvcEntryPoint.__member(4), SpvcEntryPoint.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        EXECUTION_MODEL = layout.offsetof(0);
        NAME = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<SpvcEntryPoint, Buffer>
    implements NativeResource {
        private static final SpvcEntryPoint ELEMENT_FACTORY = SpvcEntryPoint.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected SpvcEntryPoint getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="SpvExecutionModel")
        public int execution_model() {
            return SpvcEntryPoint.nexecution_model(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer name() {
            return SpvcEntryPoint.nname(this.address());
        }

        @NativeType(value="char const *")
        public String nameString() {
            return SpvcEntryPoint.nnameString(this.address());
        }

        public Buffer execution_model(@NativeType(value="SpvExecutionModel") int value) {
            SpvcEntryPoint.nexecution_model(this.address(), value);
            return this;
        }

        public Buffer name(@NativeType(value="char const *") ByteBuffer value) {
            SpvcEntryPoint.nname(this.address(), value);
            return this;
        }
    }
}

