/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.remotery;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.util.remotery.RMTFree;
import org.lwjgl.util.remotery.RMTFreeI;
import org.lwjgl.util.remotery.RMTInputHandler;
import org.lwjgl.util.remotery.RMTInputHandlerI;
import org.lwjgl.util.remotery.RMTMalloc;
import org.lwjgl.util.remotery.RMTMallocI;
import org.lwjgl.util.remotery.RMTRealloc;
import org.lwjgl.util.remotery.RMTReallocI;

@NativeType(value="struct rmtSettings")
public class RMTSettings
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PORT;
    public static final int REUSE_OPEN_PORT;
    public static final int LIMIT_CONNECTIONS_TO_LOCALHOST;
    public static final int ENABLETHREADSAMPLER;
    public static final int MSSLEEPBETWEENSERVERUPDATES;
    public static final int MESSAGEQUEUESIZEINBYTES;
    public static final int MAXNBMESSAGESPERUPDATE;
    public static final int _MALLOC;
    public static final int REALLOC;
    public static final int _FREE;
    public static final int MM_CONTEXT;
    public static final int INPUT_HANDLER;
    public static final int INPUT_HANDLER_CONTEXT;
    public static final int LOGPATH;

    public RMTSettings(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), RMTSettings.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="rmtU16")
    public short port() {
        return RMTSettings.nport(this.address());
    }

    @NativeType(value="rmtBool")
    public boolean reuse_open_port() {
        return RMTSettings.nreuse_open_port(this.address()) != 0;
    }

    @NativeType(value="rmtBool")
    public boolean limit_connections_to_localhost() {
        return RMTSettings.nlimit_connections_to_localhost(this.address()) != 0;
    }

    @NativeType(value="rmtBool")
    public boolean enableThreadSampler() {
        return RMTSettings.nenableThreadSampler(this.address()) != 0;
    }

    @NativeType(value="rmtU32")
    public int msSleepBetweenServerUpdates() {
        return RMTSettings.nmsSleepBetweenServerUpdates(this.address());
    }

    @NativeType(value="rmtU32")
    public int messageQueueSizeInBytes() {
        return RMTSettings.nmessageQueueSizeInBytes(this.address());
    }

    @NativeType(value="rmtU32")
    public int maxNbMessagesPerUpdate() {
        return RMTSettings.nmaxNbMessagesPerUpdate(this.address());
    }

    @NativeType(value="rmtMallocPtr")
    public RMTMalloc _malloc() {
        return RMTSettings.n_malloc(this.address());
    }

    @NativeType(value="rmtReallocPtr")
    public RMTRealloc realloc() {
        return RMTSettings.nrealloc(this.address());
    }

    @NativeType(value="rmtFreePtr")
    public RMTFree _free() {
        return RMTSettings.n_free(this.address());
    }

    @NativeType(value="void *")
    public long mm_context() {
        return RMTSettings.nmm_context(this.address());
    }

    @NativeType(value="rmtInputHandlerPtr")
    public RMTInputHandler input_handler() {
        return RMTSettings.ninput_handler(this.address());
    }

    @NativeType(value="void *")
    public long input_handler_context() {
        return RMTSettings.ninput_handler_context(this.address());
    }

    @NativeType(value="rmtPStr")
    public ByteBuffer logPath() {
        return RMTSettings.nlogPath(this.address());
    }

    @NativeType(value="rmtPStr")
    public String logPathString() {
        return RMTSettings.nlogPathString(this.address());
    }

    public RMTSettings port(@NativeType(value="rmtU16") short value) {
        RMTSettings.nport(this.address(), value);
        return this;
    }

    public RMTSettings reuse_open_port(@NativeType(value="rmtBool") boolean value) {
        RMTSettings.nreuse_open_port(this.address(), value ? 1 : 0);
        return this;
    }

    public RMTSettings limit_connections_to_localhost(@NativeType(value="rmtBool") boolean value) {
        RMTSettings.nlimit_connections_to_localhost(this.address(), value ? 1 : 0);
        return this;
    }

    public RMTSettings enableThreadSampler(@NativeType(value="rmtBool") boolean value) {
        RMTSettings.nenableThreadSampler(this.address(), value ? 1 : 0);
        return this;
    }

    public RMTSettings msSleepBetweenServerUpdates(@NativeType(value="rmtU32") int value) {
        RMTSettings.nmsSleepBetweenServerUpdates(this.address(), value);
        return this;
    }

    public RMTSettings messageQueueSizeInBytes(@NativeType(value="rmtU32") int value) {
        RMTSettings.nmessageQueueSizeInBytes(this.address(), value);
        return this;
    }

    public RMTSettings maxNbMessagesPerUpdate(@NativeType(value="rmtU32") int value) {
        RMTSettings.nmaxNbMessagesPerUpdate(this.address(), value);
        return this;
    }

    public RMTSettings _malloc(@NativeType(value="rmtMallocPtr") RMTMallocI value) {
        RMTSettings.n_malloc(this.address(), value);
        return this;
    }

    public RMTSettings realloc(@NativeType(value="rmtReallocPtr") RMTReallocI value) {
        RMTSettings.nrealloc(this.address(), value);
        return this;
    }

    public RMTSettings _free(@NativeType(value="rmtFreePtr") RMTFreeI value) {
        RMTSettings.n_free(this.address(), value);
        return this;
    }

    public RMTSettings mm_context(@NativeType(value="void *") long value) {
        RMTSettings.nmm_context(this.address(), value);
        return this;
    }

    public RMTSettings input_handler(@NativeType(value="rmtInputHandlerPtr") RMTInputHandlerI value) {
        RMTSettings.ninput_handler(this.address(), value);
        return this;
    }

    public RMTSettings input_handler_context(@NativeType(value="void *") long value) {
        RMTSettings.ninput_handler_context(this.address(), value);
        return this;
    }

    public RMTSettings logPath(@NativeType(value="rmtPStr") ByteBuffer value) {
        RMTSettings.nlogPath(this.address(), value);
        return this;
    }

    public RMTSettings set(short port, boolean reuse_open_port, boolean limit_connections_to_localhost, boolean enableThreadSampler, int msSleepBetweenServerUpdates, int messageQueueSizeInBytes, int maxNbMessagesPerUpdate, RMTMallocI _malloc, RMTReallocI realloc, RMTFreeI _free, long mm_context, RMTInputHandlerI input_handler, long input_handler_context, ByteBuffer logPath) {
        this.port(port);
        this.reuse_open_port(reuse_open_port);
        this.limit_connections_to_localhost(limit_connections_to_localhost);
        this.enableThreadSampler(enableThreadSampler);
        this.msSleepBetweenServerUpdates(msSleepBetweenServerUpdates);
        this.messageQueueSizeInBytes(messageQueueSizeInBytes);
        this.maxNbMessagesPerUpdate(maxNbMessagesPerUpdate);
        this._malloc(_malloc);
        this.realloc(realloc);
        this._free(_free);
        this.mm_context(mm_context);
        this.input_handler(input_handler);
        this.input_handler_context(input_handler_context);
        this.logPath(logPath);
        return this;
    }

    public RMTSettings set(RMTSettings src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static RMTSettings malloc() {
        return RMTSettings.wrap(RMTSettings.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static RMTSettings calloc() {
        return RMTSettings.wrap(RMTSettings.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static RMTSettings create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return RMTSettings.wrap(RMTSettings.class, MemoryUtil.memAddress(container), container);
    }

    public static RMTSettings create(long address) {
        return RMTSettings.wrap(RMTSettings.class, address);
    }

    @Nullable
    public static RMTSettings createSafe(long address) {
        return address == 0L ? null : RMTSettings.wrap(RMTSettings.class, address);
    }

    @Deprecated
    public static RMTSettings mallocStack() {
        return RMTSettings.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static RMTSettings callocStack() {
        return RMTSettings.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static RMTSettings mallocStack(MemoryStack stack) {
        return RMTSettings.malloc(stack);
    }

    @Deprecated
    public static RMTSettings callocStack(MemoryStack stack) {
        return RMTSettings.calloc(stack);
    }

    public static RMTSettings malloc(MemoryStack stack) {
        return RMTSettings.wrap(RMTSettings.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static RMTSettings calloc(MemoryStack stack) {
        return RMTSettings.wrap(RMTSettings.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static short nport(long struct) {
        return UNSAFE.getShort(null, struct + (long)PORT);
    }

    public static int nreuse_open_port(long struct) {
        return UNSAFE.getInt(null, struct + (long)REUSE_OPEN_PORT);
    }

    public static int nlimit_connections_to_localhost(long struct) {
        return UNSAFE.getInt(null, struct + (long)LIMIT_CONNECTIONS_TO_LOCALHOST);
    }

    public static int nenableThreadSampler(long struct) {
        return UNSAFE.getInt(null, struct + (long)ENABLETHREADSAMPLER);
    }

    public static int nmsSleepBetweenServerUpdates(long struct) {
        return UNSAFE.getInt(null, struct + (long)MSSLEEPBETWEENSERVERUPDATES);
    }

    public static int nmessageQueueSizeInBytes(long struct) {
        return UNSAFE.getInt(null, struct + (long)MESSAGEQUEUESIZEINBYTES);
    }

    public static int nmaxNbMessagesPerUpdate(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXNBMESSAGESPERUPDATE);
    }

    public static RMTMalloc n_malloc(long struct) {
        return RMTMalloc.create(MemoryUtil.memGetAddress(struct + (long)_MALLOC));
    }

    public static RMTRealloc nrealloc(long struct) {
        return RMTRealloc.create(MemoryUtil.memGetAddress(struct + (long)REALLOC));
    }

    public static RMTFree n_free(long struct) {
        return RMTFree.create(MemoryUtil.memGetAddress(struct + (long)_FREE));
    }

    public static long nmm_context(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)MM_CONTEXT);
    }

    public static RMTInputHandler ninput_handler(long struct) {
        return RMTInputHandler.create(MemoryUtil.memGetAddress(struct + (long)INPUT_HANDLER));
    }

    public static long ninput_handler_context(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)INPUT_HANDLER_CONTEXT);
    }

    public static ByteBuffer nlogPath(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)LOGPATH));
    }

    public static String nlogPathString(long struct) {
        return MemoryUtil.memASCII(MemoryUtil.memGetAddress(struct + (long)LOGPATH));
    }

    public static void nport(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)PORT, value);
    }

    public static void nreuse_open_port(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)REUSE_OPEN_PORT, value);
    }

    public static void nlimit_connections_to_localhost(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LIMIT_CONNECTIONS_TO_LOCALHOST, value);
    }

    public static void nenableThreadSampler(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ENABLETHREADSAMPLER, value);
    }

    public static void nmsSleepBetweenServerUpdates(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MSSLEEPBETWEENSERVERUPDATES, value);
    }

    public static void nmessageQueueSizeInBytes(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MESSAGEQUEUESIZEINBYTES, value);
    }

    public static void nmaxNbMessagesPerUpdate(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXNBMESSAGESPERUPDATE, value);
    }

    public static void n_malloc(long struct, RMTMallocI value) {
        MemoryUtil.memPutAddress(struct + (long)_MALLOC, value.address());
    }

    public static void nrealloc(long struct, RMTReallocI value) {
        MemoryUtil.memPutAddress(struct + (long)REALLOC, value.address());
    }

    public static void n_free(long struct, RMTFreeI value) {
        MemoryUtil.memPutAddress(struct + (long)_FREE, value.address());
    }

    public static void nmm_context(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)MM_CONTEXT, Checks.check(value));
    }

    public static void ninput_handler(long struct, RMTInputHandlerI value) {
        MemoryUtil.memPutAddress(struct + (long)INPUT_HANDLER, value.address());
    }

    public static void ninput_handler_context(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)INPUT_HANDLER_CONTEXT, Checks.check(value));
    }

    public static void nlogPath(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
        }
        MemoryUtil.memPutAddress(struct + (long)LOGPATH, MemoryUtil.memAddress(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)_MALLOC));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)REALLOC));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)_FREE));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)MM_CONTEXT));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)INPUT_HANDLER));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)INPUT_HANDLER_CONTEXT));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)LOGPATH));
    }

    static {
        Struct.Layout layout = RMTSettings.__struct(RMTSettings.__member(2), RMTSettings.__member(4), RMTSettings.__member(4), RMTSettings.__member(4), RMTSettings.__member(4), RMTSettings.__member(4), RMTSettings.__member(4), RMTSettings.__member(POINTER_SIZE), RMTSettings.__member(POINTER_SIZE), RMTSettings.__member(POINTER_SIZE), RMTSettings.__member(POINTER_SIZE), RMTSettings.__member(POINTER_SIZE), RMTSettings.__member(POINTER_SIZE), RMTSettings.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PORT = layout.offsetof(0);
        REUSE_OPEN_PORT = layout.offsetof(1);
        LIMIT_CONNECTIONS_TO_LOCALHOST = layout.offsetof(2);
        ENABLETHREADSAMPLER = layout.offsetof(3);
        MSSLEEPBETWEENSERVERUPDATES = layout.offsetof(4);
        MESSAGEQUEUESIZEINBYTES = layout.offsetof(5);
        MAXNBMESSAGESPERUPDATE = layout.offsetof(6);
        _MALLOC = layout.offsetof(7);
        REALLOC = layout.offsetof(8);
        _FREE = layout.offsetof(9);
        MM_CONTEXT = layout.offsetof(10);
        INPUT_HANDLER = layout.offsetof(11);
        INPUT_HANDLER_CONTEXT = layout.offsetof(12);
        LOGPATH = layout.offsetof(13);
    }
}

