/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.opus;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.util.opus.Opus;

public class OpusProjection {
    public static final int OPUS_PROJECTION_GET_DEMIXING_MATRIX_GAIN_REQUEST = 6001;
    public static final int OPUS_PROJECTION_GET_DEMIXING_MATRIX_SIZE_REQUEST = 6003;
    public static final int OPUS_PROJECTION_GET_DEMIXING_MATRIX_REQUEST = 6005;

    protected OpusProjection() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="opus_int32")
    public static int opus_projection_ambisonics_encoder_get_size(int channels, int mapping_family) {
        long __functionAddress = Functions.projection_ambisonics_encoder_get_size;
        return JNI.invokeI(channels, mapping_family, __functionAddress);
    }

    public static long nopus_projection_ambisonics_encoder_create(int Fs, int channels, int mapping_family, long streams, long coupled_streams, int application, long error) {
        long __functionAddress = Functions.projection_ambisonics_encoder_create;
        return JNI.invokePPPP(Fs, channels, mapping_family, streams, coupled_streams, application, error, __functionAddress);
    }

    @NativeType(value="OpusProjectionEncoder *")
    public static long opus_projection_ambisonics_encoder_create(@NativeType(value="opus_int32") int Fs, int channels, int mapping_family, @NativeType(value="int *") IntBuffer streams, @NativeType(value="int *") IntBuffer coupled_streams, int application, @Nullable @NativeType(value="int *") IntBuffer error) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)streams, 1);
            Checks.check((Buffer)coupled_streams, 1);
            Checks.checkSafe((Buffer)error, 1);
        }
        return OpusProjection.nopus_projection_ambisonics_encoder_create(Fs, channels, mapping_family, MemoryUtil.memAddress(streams), MemoryUtil.memAddress(coupled_streams), application, MemoryUtil.memAddressSafe(error));
    }

    public static int nopus_projection_ambisonics_encoder_init(long st, int Fs, int channels, int mapping_family, long streams, long coupled_streams, int application) {
        long __functionAddress = Functions.projection_ambisonics_encoder_init;
        if (Checks.CHECKS) {
            Checks.check(st);
        }
        return JNI.invokePPPI(st, Fs, channels, mapping_family, streams, coupled_streams, application, __functionAddress);
    }

    public static int opus_projection_ambisonics_encoder_init(@NativeType(value="OpusProjectionEncoder *") long st, @NativeType(value="opus_int32") int Fs, int channels, int mapping_family, @NativeType(value="int *") IntBuffer streams, @NativeType(value="int *") IntBuffer coupled_streams, int application) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)streams, 1);
            Checks.check((Buffer)coupled_streams, 1);
        }
        return OpusProjection.nopus_projection_ambisonics_encoder_init(st, Fs, channels, mapping_family, MemoryUtil.memAddress(streams), MemoryUtil.memAddress(coupled_streams), application);
    }

    public static int nopus_projection_encode(long st, long pcm, int frame_size, long data, int max_data_bytes) {
        long __functionAddress = Functions.projection_encode;
        if (Checks.CHECKS) {
            Checks.check(st);
        }
        return JNI.invokePPPI(st, pcm, frame_size, data, max_data_bytes, __functionAddress);
    }

    public static int opus_projection_encode(@NativeType(value="OpusProjectionEncoder *") long st, @NativeType(value="opus_int16 const *") ShortBuffer pcm, int frame_size, @NativeType(value="unsigned char *") ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pcm, frame_size * MemoryUtil.memGetInt(st + 8L + (long)MemoryUtil.memGetInt(st) + (long)MemoryUtil.memGetInt(st + 4L)));
        }
        return OpusProjection.nopus_projection_encode(st, MemoryUtil.memAddress(pcm), frame_size, MemoryUtil.memAddress(data), data.remaining());
    }

    public static int nopus_projection_encode_float(long st, long pcm, int frame_size, long data, int max_data_bytes) {
        long __functionAddress = Functions.projection_encode_float;
        if (Checks.CHECKS) {
            Checks.check(st);
        }
        return JNI.invokePPPI(st, pcm, frame_size, data, max_data_bytes, __functionAddress);
    }

    public static int opus_projection_encode_float(@NativeType(value="OpusProjectionEncoder *") long st, @NativeType(value="float const *") FloatBuffer pcm, int frame_size, @NativeType(value="unsigned char *") ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pcm, frame_size * MemoryUtil.memGetInt(st + 8L + (long)MemoryUtil.memGetInt(st) + (long)MemoryUtil.memGetInt(st + 4L)));
        }
        return OpusProjection.nopus_projection_encode_float(st, MemoryUtil.memAddress(pcm), frame_size, MemoryUtil.memAddress(data), data.remaining());
    }

    private static int opus_projection_encoder_ctl(@NativeType(value="OpusProjectionEncoder *") long st) {
        long __functionAddress = Functions.projection_encoder_ctl;
        if (Checks.CHECKS) {
            Checks.check(st);
        }
        return JNI.invokePI(st, __functionAddress);
    }

    public static int opus_projection_encoder_destroy(@NativeType(value="OpusProjectionEncoder *") long st) {
        long __functionAddress = Functions.projection_encoder_destroy;
        if (Checks.CHECKS) {
            Checks.check(st);
        }
        return JNI.invokePI(st, __functionAddress);
    }

    @NativeType(value="opus_int32")
    public static int opus_projection_decoder_get_size(int channels, int streams, int coupled_streams) {
        long __functionAddress = Functions.projection_decoder_get_size;
        return JNI.invokeI(channels, streams, coupled_streams, __functionAddress);
    }

    public static long nopus_projection_decoder_create(int Fs, int channels, int streams, int coupled_streams, long demixing_matrix, int demixing_matrix_size, long error) {
        long __functionAddress = Functions.projection_decoder_create;
        return JNI.invokePPP(Fs, channels, streams, coupled_streams, demixing_matrix, demixing_matrix_size, error, __functionAddress);
    }

    @NativeType(value="OpusProjectionDecoder *")
    public static long opus_projection_decoder_create(@NativeType(value="opus_int32") int Fs, int channels, int streams, int coupled_streams, @NativeType(value="unsigned char *") ByteBuffer demixing_matrix, @Nullable @NativeType(value="int *") IntBuffer error) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)error, 1);
        }
        return OpusProjection.nopus_projection_decoder_create(Fs, channels, streams, coupled_streams, MemoryUtil.memAddress(demixing_matrix), demixing_matrix.remaining(), MemoryUtil.memAddressSafe(error));
    }

    public static int nopus_projection_decoder_init(long st, int Fs, int channels, int streams, int coupled_streams, long demixing_matrix, int demixing_matrix_size) {
        long __functionAddress = Functions.projection_decoder_init;
        if (Checks.CHECKS) {
            Checks.check(st);
        }
        return JNI.invokePPI(st, Fs, channels, streams, coupled_streams, demixing_matrix, demixing_matrix_size, __functionAddress);
    }

    public static int opus_projection_decoder_init(@NativeType(value="OpusProjectionDecoder *") long st, @NativeType(value="opus_int32") int Fs, int channels, int streams, int coupled_streams, @NativeType(value="unsigned char *") ByteBuffer demixing_matrix) {
        return OpusProjection.nopus_projection_decoder_init(st, Fs, channels, streams, coupled_streams, MemoryUtil.memAddress(demixing_matrix), demixing_matrix.remaining());
    }

    public static int nopus_projection_decode(long st, long data, int len, long pcm, int frame_size, int decode_fec) {
        long __functionAddress = Functions.projection_decode;
        if (Checks.CHECKS) {
            Checks.check(st);
        }
        return JNI.invokePPPI(st, data, len, pcm, frame_size, decode_fec, __functionAddress);
    }

    public static int opus_projection_decode(@NativeType(value="OpusProjectionDecoder *") long st, @Nullable @NativeType(value="unsigned char const *") ByteBuffer data, @NativeType(value="opus_int16 *") ShortBuffer pcm, int frame_size, int decode_fec) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pcm, frame_size * MemoryUtil.memGetInt(st + 4L + (long)MemoryUtil.memGetInt(st)));
        }
        return OpusProjection.nopus_projection_decode(st, MemoryUtil.memAddressSafe(data), Checks.remainingSafe(data), MemoryUtil.memAddress(pcm), frame_size, decode_fec);
    }

    public static int nopus_projection_decode_float(long st, long data, int len, long pcm, int frame_size, int decode_fec) {
        long __functionAddress = Functions.projection_decode_float;
        if (Checks.CHECKS) {
            Checks.check(st);
        }
        return JNI.invokePPPI(st, data, len, pcm, frame_size, decode_fec, __functionAddress);
    }

    public static int opus_projection_decode_float(@NativeType(value="OpusMSDecoder *") long st, @Nullable @NativeType(value="unsigned char const *") ByteBuffer data, @NativeType(value="float *") FloatBuffer pcm, int frame_size, int decode_fec) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pcm, frame_size * MemoryUtil.memGetInt(st + 4L + (long)MemoryUtil.memGetInt(st)));
        }
        return OpusProjection.nopus_projection_decode_float(st, MemoryUtil.memAddressSafe(data), Checks.remainingSafe(data), MemoryUtil.memAddress(pcm), frame_size, decode_fec);
    }

    private static int opus_projection_decoder_ctl(@NativeType(value="OpusProjectionDecoder *") long st) {
        long __functionAddress = Functions.projection_decoder_ctl;
        if (Checks.CHECKS) {
            Checks.check(st);
        }
        return JNI.invokePI(st, __functionAddress);
    }

    public static int opus_projection_decoder_destroy(@NativeType(value="OpusProjectionDecoder *") long st) {
        long __functionAddress = Functions.projection_decoder_destroy;
        if (Checks.CHECKS) {
            Checks.check(st);
        }
        return JNI.invokePI(st, __functionAddress);
    }

    public static int opus_projection_encoder_ctl(@NativeType(value="OpusProjectionEncoder *") long st, int request) {
        return new Opus.CTLRequestV(request).apply(st, Functions.projection_encoder_ctl);
    }

    public static int opus_projection_encoder_ctl(@NativeType(value="OpusProjectionEncoder *") long st, Opus.CTLRequest request) {
        return request.apply(st, Functions.projection_encoder_ctl);
    }

    public static int opus_projection_decoder_ctl(@NativeType(value="OpusProjectionDecoder *") long st, int request) {
        return new Opus.CTLRequestV(request).apply(st, Functions.projection_decoder_ctl);
    }

    public static int opus_projection_decoder_ctl(@NativeType(value="OpusProjectionDecoder *") long st, Opus.CTLRequest request) {
        return request.apply(st, Functions.projection_decoder_ctl);
    }

    public static Opus.CTLRequest OPUS_PROJECTION_GET_DEMIXING_MATRIX_GAIN(IntBuffer value) {
        return new Opus.CTLRequestP(6001, MemoryUtil.memAddress(value));
    }

    public static Opus.CTLRequest OPUS_PROJECTION_GET_DEMIXING_MATRIX_SIZE(IntBuffer value) {
        return new Opus.CTLRequestP(6003, MemoryUtil.memAddress(value));
    }

    public static Opus.CTLRequest OPUS_PROJECTION_GET_DEMIXING_MATRIX(ByteBuffer matrix) {
        return new Opus.CTLRequestPI(6005, MemoryUtil.memAddress(matrix), matrix.remaining());
    }

    public static final class Functions {
        public static final long projection_ambisonics_encoder_get_size = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_projection_ambisonics_encoder_get_size");
        public static final long projection_ambisonics_encoder_create = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_projection_ambisonics_encoder_create");
        public static final long projection_ambisonics_encoder_init = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_projection_ambisonics_encoder_init");
        public static final long projection_encode = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_projection_encode");
        public static final long projection_encode_float = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_projection_encode_float");
        public static final long projection_encoder_ctl = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_projection_encoder_ctl");
        public static final long projection_encoder_destroy = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_projection_encoder_destroy");
        public static final long projection_decoder_get_size = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_projection_decoder_get_size");
        public static final long projection_decoder_create = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_projection_decoder_create");
        public static final long projection_decoder_init = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_projection_decoder_init");
        public static final long projection_decode = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_projection_decode");
        public static final long projection_decode_float = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_projection_decode_float");
        public static final long projection_decoder_ctl = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_projection_decoder_ctl");
        public static final long projection_decoder_destroy = APIUtil.apiGetFunctionAddress(Opus.getLibrary(), "opus_projection_decoder_destroy");

        private Functions() {
        }
    }
}

