/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.opus;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OpusPictureTag
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int MIME_TYPE;
    public static final int DESCRIPTION;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int DEPTH;
    public static final int COLORS;
    public static final int DATA_LENGTH;
    public static final int DATA;
    public static final int FORMAT;

    public OpusPictureTag(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), OpusPictureTag.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="opus_int32")
    public int type() {
        return OpusPictureTag.ntype(this.address());
    }

    @NativeType(value="char *")
    public ByteBuffer mime_type(int capacity) {
        return OpusPictureTag.nmime_type(this.address(), capacity);
    }

    @NativeType(value="char *")
    public ByteBuffer description() {
        return OpusPictureTag.ndescription(this.address());
    }

    @NativeType(value="char *")
    public String descriptionString() {
        return OpusPictureTag.ndescriptionString(this.address());
    }

    @NativeType(value="opus_uint32")
    public int width() {
        return OpusPictureTag.nwidth(this.address());
    }

    @NativeType(value="opus_uint32")
    public int height() {
        return OpusPictureTag.nheight(this.address());
    }

    @NativeType(value="opus_uint32")
    public int depth() {
        return OpusPictureTag.ndepth(this.address());
    }

    @NativeType(value="opus_uint32")
    public int colors() {
        return OpusPictureTag.ncolors(this.address());
    }

    @NativeType(value="opus_uint32")
    public int data_length() {
        return OpusPictureTag.ndata_length(this.address());
    }

    @NativeType(value="unsigned char *")
    public ByteBuffer data() {
        return OpusPictureTag.ndata(this.address());
    }

    public int format() {
        return OpusPictureTag.nformat(this.address());
    }

    public static OpusPictureTag malloc() {
        return OpusPictureTag.wrap(OpusPictureTag.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static OpusPictureTag calloc() {
        return OpusPictureTag.wrap(OpusPictureTag.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static OpusPictureTag create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return OpusPictureTag.wrap(OpusPictureTag.class, MemoryUtil.memAddress(container), container);
    }

    public static OpusPictureTag create(long address) {
        return OpusPictureTag.wrap(OpusPictureTag.class, address);
    }

    @Nullable
    public static OpusPictureTag createSafe(long address) {
        return address == 0L ? null : OpusPictureTag.wrap(OpusPictureTag.class, address);
    }

    public static Buffer malloc(int capacity) {
        return OpusPictureTag.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(OpusPictureTag.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return OpusPictureTag.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = OpusPictureTag.__create(capacity, SIZEOF);
        return OpusPictureTag.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return OpusPictureTag.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : OpusPictureTag.wrap(Buffer.class, address, capacity);
    }

    public static OpusPictureTag malloc(MemoryStack stack) {
        return OpusPictureTag.wrap(OpusPictureTag.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static OpusPictureTag calloc(MemoryStack stack) {
        return OpusPictureTag.wrap(OpusPictureTag.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return OpusPictureTag.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return OpusPictureTag.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static ByteBuffer nmime_type(long struct, int capacity) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)MIME_TYPE), capacity);
    }

    public static ByteBuffer ndescription(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)DESCRIPTION));
    }

    public static String ndescriptionString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)DESCRIPTION));
    }

    public static int nwidth(long struct) {
        return UNSAFE.getInt(null, struct + (long)WIDTH);
    }

    public static int nheight(long struct) {
        return UNSAFE.getInt(null, struct + (long)HEIGHT);
    }

    public static int ndepth(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEPTH);
    }

    public static int ncolors(long struct) {
        return UNSAFE.getInt(null, struct + (long)COLORS);
    }

    public static int ndata_length(long struct) {
        return UNSAFE.getInt(null, struct + (long)DATA_LENGTH);
    }

    public static ByteBuffer ndata(long struct) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)DATA), OpusPictureTag.ndata_length(struct));
    }

    public static int nformat(long struct) {
        return UNSAFE.getInt(null, struct + (long)FORMAT);
    }

    static {
        Struct.Layout layout = OpusPictureTag.__struct(OpusPictureTag.__member(4), OpusPictureTag.__member(POINTER_SIZE), OpusPictureTag.__member(POINTER_SIZE), OpusPictureTag.__member(4), OpusPictureTag.__member(4), OpusPictureTag.__member(4), OpusPictureTag.__member(4), OpusPictureTag.__member(4), OpusPictureTag.__member(POINTER_SIZE), OpusPictureTag.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        MIME_TYPE = layout.offsetof(1);
        DESCRIPTION = layout.offsetof(2);
        WIDTH = layout.offsetof(3);
        HEIGHT = layout.offsetof(4);
        DEPTH = layout.offsetof(5);
        COLORS = layout.offsetof(6);
        DATA_LENGTH = layout.offsetof(7);
        DATA = layout.offsetof(8);
        FORMAT = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<OpusPictureTag, Buffer>
    implements NativeResource {
        private static final OpusPictureTag ELEMENT_FACTORY = OpusPictureTag.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected OpusPictureTag getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="opus_int32")
        public int type() {
            return OpusPictureTag.ntype(this.address());
        }

        @NativeType(value="char *")
        public ByteBuffer mime_type(int capacity) {
            return OpusPictureTag.nmime_type(this.address(), capacity);
        }

        @NativeType(value="char *")
        public ByteBuffer description() {
            return OpusPictureTag.ndescription(this.address());
        }

        @NativeType(value="char *")
        public String descriptionString() {
            return OpusPictureTag.ndescriptionString(this.address());
        }

        @NativeType(value="opus_uint32")
        public int width() {
            return OpusPictureTag.nwidth(this.address());
        }

        @NativeType(value="opus_uint32")
        public int height() {
            return OpusPictureTag.nheight(this.address());
        }

        @NativeType(value="opus_uint32")
        public int depth() {
            return OpusPictureTag.ndepth(this.address());
        }

        @NativeType(value="opus_uint32")
        public int colors() {
            return OpusPictureTag.ncolors(this.address());
        }

        @NativeType(value="opus_uint32")
        public int data_length() {
            return OpusPictureTag.ndata_length(this.address());
        }

        @NativeType(value="unsigned char *")
        public ByteBuffer data() {
            return OpusPictureTag.ndata(this.address());
        }

        public int format() {
            return OpusPictureTag.nformat(this.address());
        }
    }
}

