/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.nfd;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.nfd.LibNFD;

@NativeType(value="struct nfdpathset_t")
public class NFDPathSet
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;

    private static native int offsets(long var0);

    public NFDPathSet(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), NFDPathSet.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public static NFDPathSet malloc() {
        return NFDPathSet.wrap(NFDPathSet.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static NFDPathSet calloc() {
        return NFDPathSet.wrap(NFDPathSet.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static NFDPathSet create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return NFDPathSet.wrap(NFDPathSet.class, MemoryUtil.memAddress(container), container);
    }

    public static NFDPathSet create(long address) {
        return NFDPathSet.wrap(NFDPathSet.class, address);
    }

    @Nullable
    public static NFDPathSet createSafe(long address) {
        return address == 0L ? null : NFDPathSet.wrap(NFDPathSet.class, address);
    }

    public static Buffer malloc(int capacity) {
        return NFDPathSet.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(NFDPathSet.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return NFDPathSet.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = NFDPathSet.__create(capacity, SIZEOF);
        return NFDPathSet.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return NFDPathSet.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : NFDPathSet.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static NFDPathSet mallocStack() {
        return NFDPathSet.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NFDPathSet callocStack() {
        return NFDPathSet.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static NFDPathSet mallocStack(MemoryStack stack) {
        return NFDPathSet.malloc(stack);
    }

    @Deprecated
    public static NFDPathSet callocStack(MemoryStack stack) {
        return NFDPathSet.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return NFDPathSet.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return NFDPathSet.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return NFDPathSet.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return NFDPathSet.calloc(capacity, stack);
    }

    public static NFDPathSet malloc(MemoryStack stack) {
        return NFDPathSet.wrap(NFDPathSet.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static NFDPathSet calloc(MemoryStack stack) {
        return NFDPathSet.wrap(NFDPathSet.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return NFDPathSet.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return NFDPathSet.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    static {
        LibNFD.initialize();
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer offsets = stack.mallocInt(1);
            SIZEOF = NFDPathSet.offsets(MemoryUtil.memAddress(offsets));
            ALIGNOF = offsets.get(0);
        }
    }

    public static class Buffer
    extends StructBuffer<NFDPathSet, Buffer>
    implements NativeResource {
        private static final NFDPathSet ELEMENT_FACTORY = NFDPathSet.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected NFDPathSet getElementFactory() {
            return ELEMENT_FACTORY;
        }
    }
}

