/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.meshoptimizer;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct meshopt_VertexCacheStatistics")
public class MeshoptVertexCacheStatistics
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VERTICES_TRANSFORMED;
    public static final int WARPS_EXECUTED;
    public static final int ACMR;
    public static final int ATVR;

    public MeshoptVertexCacheStatistics(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), MeshoptVertexCacheStatistics.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int vertices_transformed() {
        return MeshoptVertexCacheStatistics.nvertices_transformed(this.address());
    }

    @NativeType(value="unsigned int")
    public int warps_executed() {
        return MeshoptVertexCacheStatistics.nwarps_executed(this.address());
    }

    public float acmr() {
        return MeshoptVertexCacheStatistics.nacmr(this.address());
    }

    public float atvr() {
        return MeshoptVertexCacheStatistics.natvr(this.address());
    }

    public static MeshoptVertexCacheStatistics malloc() {
        return MeshoptVertexCacheStatistics.wrap(MeshoptVertexCacheStatistics.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static MeshoptVertexCacheStatistics calloc() {
        return MeshoptVertexCacheStatistics.wrap(MeshoptVertexCacheStatistics.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static MeshoptVertexCacheStatistics create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return MeshoptVertexCacheStatistics.wrap(MeshoptVertexCacheStatistics.class, MemoryUtil.memAddress(container), container);
    }

    public static MeshoptVertexCacheStatistics create(long address) {
        return MeshoptVertexCacheStatistics.wrap(MeshoptVertexCacheStatistics.class, address);
    }

    @Nullable
    public static MeshoptVertexCacheStatistics createSafe(long address) {
        return address == 0L ? null : MeshoptVertexCacheStatistics.wrap(MeshoptVertexCacheStatistics.class, address);
    }

    public static Buffer malloc(int capacity) {
        return MeshoptVertexCacheStatistics.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(MeshoptVertexCacheStatistics.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return MeshoptVertexCacheStatistics.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = MeshoptVertexCacheStatistics.__create(capacity, SIZEOF);
        return MeshoptVertexCacheStatistics.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return MeshoptVertexCacheStatistics.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : MeshoptVertexCacheStatistics.wrap(Buffer.class, address, capacity);
    }

    public static MeshoptVertexCacheStatistics malloc(MemoryStack stack) {
        return MeshoptVertexCacheStatistics.wrap(MeshoptVertexCacheStatistics.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static MeshoptVertexCacheStatistics calloc(MemoryStack stack) {
        return MeshoptVertexCacheStatistics.wrap(MeshoptVertexCacheStatistics.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return MeshoptVertexCacheStatistics.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return MeshoptVertexCacheStatistics.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nvertices_transformed(long struct) {
        return UNSAFE.getInt(null, struct + (long)VERTICES_TRANSFORMED);
    }

    public static int nwarps_executed(long struct) {
        return UNSAFE.getInt(null, struct + (long)WARPS_EXECUTED);
    }

    public static float nacmr(long struct) {
        return UNSAFE.getFloat(null, struct + (long)ACMR);
    }

    public static float natvr(long struct) {
        return UNSAFE.getFloat(null, struct + (long)ATVR);
    }

    static {
        Struct.Layout layout = MeshoptVertexCacheStatistics.__struct(MeshoptVertexCacheStatistics.__member(4), MeshoptVertexCacheStatistics.__member(4), MeshoptVertexCacheStatistics.__member(4), MeshoptVertexCacheStatistics.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VERTICES_TRANSFORMED = layout.offsetof(0);
        WARPS_EXECUTED = layout.offsetof(1);
        ACMR = layout.offsetof(2);
        ATVR = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<MeshoptVertexCacheStatistics, Buffer>
    implements NativeResource {
        private static final MeshoptVertexCacheStatistics ELEMENT_FACTORY = MeshoptVertexCacheStatistics.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected MeshoptVertexCacheStatistics getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int vertices_transformed() {
            return MeshoptVertexCacheStatistics.nvertices_transformed(this.address());
        }

        @NativeType(value="unsigned int")
        public int warps_executed() {
            return MeshoptVertexCacheStatistics.nwarps_executed(this.address());
        }

        public float acmr() {
            return MeshoptVertexCacheStatistics.nacmr(this.address());
        }

        public float atvr() {
            return MeshoptVertexCacheStatistics.natvr(this.address());
        }
    }
}

