/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.meshoptimizer;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct meshopt_OverdrawStatistics")
public class MeshoptOverdrawStatistics
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PIXELS_COVERED;
    public static final int PIXELS_SHADED;
    public static final int OVERDRAW;

    public MeshoptOverdrawStatistics(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), MeshoptOverdrawStatistics.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned int")
    public int pixels_covered() {
        return MeshoptOverdrawStatistics.npixels_covered(this.address());
    }

    @NativeType(value="unsigned int")
    public int pixels_shaded() {
        return MeshoptOverdrawStatistics.npixels_shaded(this.address());
    }

    public float overdraw() {
        return MeshoptOverdrawStatistics.noverdraw(this.address());
    }

    public static MeshoptOverdrawStatistics malloc() {
        return MeshoptOverdrawStatistics.wrap(MeshoptOverdrawStatistics.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static MeshoptOverdrawStatistics calloc() {
        return MeshoptOverdrawStatistics.wrap(MeshoptOverdrawStatistics.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static MeshoptOverdrawStatistics create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return MeshoptOverdrawStatistics.wrap(MeshoptOverdrawStatistics.class, MemoryUtil.memAddress(container), container);
    }

    public static MeshoptOverdrawStatistics create(long address) {
        return MeshoptOverdrawStatistics.wrap(MeshoptOverdrawStatistics.class, address);
    }

    @Nullable
    public static MeshoptOverdrawStatistics createSafe(long address) {
        return address == 0L ? null : MeshoptOverdrawStatistics.wrap(MeshoptOverdrawStatistics.class, address);
    }

    public static Buffer malloc(int capacity) {
        return MeshoptOverdrawStatistics.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(MeshoptOverdrawStatistics.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return MeshoptOverdrawStatistics.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = MeshoptOverdrawStatistics.__create(capacity, SIZEOF);
        return MeshoptOverdrawStatistics.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return MeshoptOverdrawStatistics.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : MeshoptOverdrawStatistics.wrap(Buffer.class, address, capacity);
    }

    public static MeshoptOverdrawStatistics malloc(MemoryStack stack) {
        return MeshoptOverdrawStatistics.wrap(MeshoptOverdrawStatistics.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static MeshoptOverdrawStatistics calloc(MemoryStack stack) {
        return MeshoptOverdrawStatistics.wrap(MeshoptOverdrawStatistics.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return MeshoptOverdrawStatistics.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return MeshoptOverdrawStatistics.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int npixels_covered(long struct) {
        return UNSAFE.getInt(null, struct + (long)PIXELS_COVERED);
    }

    public static int npixels_shaded(long struct) {
        return UNSAFE.getInt(null, struct + (long)PIXELS_SHADED);
    }

    public static float noverdraw(long struct) {
        return UNSAFE.getFloat(null, struct + (long)OVERDRAW);
    }

    static {
        Struct.Layout layout = MeshoptOverdrawStatistics.__struct(MeshoptOverdrawStatistics.__member(4), MeshoptOverdrawStatistics.__member(4), MeshoptOverdrawStatistics.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PIXELS_COVERED = layout.offsetof(0);
        PIXELS_SHADED = layout.offsetof(1);
        OVERDRAW = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<MeshoptOverdrawStatistics, Buffer>
    implements NativeResource {
        private static final MeshoptOverdrawStatistics ELEMENT_FACTORY = MeshoptOverdrawStatistics.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected MeshoptOverdrawStatistics getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned int")
        public int pixels_covered() {
            return MeshoptOverdrawStatistics.npixels_covered(this.address());
        }

        @NativeType(value="unsigned int")
        public int pixels_shaded() {
            return MeshoptOverdrawStatistics.npixels_shaded(this.address());
        }

        public float overdraw() {
            return MeshoptOverdrawStatistics.noverdraw(this.address());
        }
    }
}

