/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.meshoptimizer;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct meshopt_Bounds")
public class MeshoptBounds
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CENTER;
    public static final int RADIUS;
    public static final int CONE_APEX;
    public static final int CONE_AXIS;
    public static final int CONE_CUTOFF;
    public static final int CONE_AXIS_S8;
    public static final int CONE_CUTOFF_S8;

    public MeshoptBounds(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), MeshoptBounds.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="float[3]")
    public FloatBuffer center() {
        return MeshoptBounds.ncenter(this.address());
    }

    public float center(int index) {
        return MeshoptBounds.ncenter(this.address(), index);
    }

    public float radius() {
        return MeshoptBounds.nradius(this.address());
    }

    @NativeType(value="float[3]")
    public FloatBuffer cone_apex() {
        return MeshoptBounds.ncone_apex(this.address());
    }

    public float cone_apex(int index) {
        return MeshoptBounds.ncone_apex(this.address(), index);
    }

    @NativeType(value="float[3]")
    public FloatBuffer cone_axis() {
        return MeshoptBounds.ncone_axis(this.address());
    }

    public float cone_axis(int index) {
        return MeshoptBounds.ncone_axis(this.address(), index);
    }

    public float cone_cutoff() {
        return MeshoptBounds.ncone_cutoff(this.address());
    }

    @NativeType(value="char[3]")
    public ByteBuffer cone_axis_s8() {
        return MeshoptBounds.ncone_axis_s8(this.address());
    }

    @NativeType(value="char")
    public byte cone_axis_s8(int index) {
        return MeshoptBounds.ncone_axis_s8(this.address(), index);
    }

    @NativeType(value="char")
    public byte cone_cutoff_s8() {
        return MeshoptBounds.ncone_cutoff_s8(this.address());
    }

    public static MeshoptBounds malloc() {
        return MeshoptBounds.wrap(MeshoptBounds.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static MeshoptBounds calloc() {
        return MeshoptBounds.wrap(MeshoptBounds.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static MeshoptBounds create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return MeshoptBounds.wrap(MeshoptBounds.class, MemoryUtil.memAddress(container), container);
    }

    public static MeshoptBounds create(long address) {
        return MeshoptBounds.wrap(MeshoptBounds.class, address);
    }

    @Nullable
    public static MeshoptBounds createSafe(long address) {
        return address == 0L ? null : MeshoptBounds.wrap(MeshoptBounds.class, address);
    }

    public static Buffer malloc(int capacity) {
        return MeshoptBounds.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(MeshoptBounds.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return MeshoptBounds.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = MeshoptBounds.__create(capacity, SIZEOF);
        return MeshoptBounds.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return MeshoptBounds.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : MeshoptBounds.wrap(Buffer.class, address, capacity);
    }

    public static MeshoptBounds malloc(MemoryStack stack) {
        return MeshoptBounds.wrap(MeshoptBounds.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static MeshoptBounds calloc(MemoryStack stack) {
        return MeshoptBounds.wrap(MeshoptBounds.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return MeshoptBounds.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return MeshoptBounds.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static FloatBuffer ncenter(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)CENTER, 3);
    }

    public static float ncenter(long struct, int index) {
        return UNSAFE.getFloat(null, struct + (long)CENTER + Checks.check(index, 3) * 4L);
    }

    public static float nradius(long struct) {
        return UNSAFE.getFloat(null, struct + (long)RADIUS);
    }

    public static FloatBuffer ncone_apex(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)CONE_APEX, 3);
    }

    public static float ncone_apex(long struct, int index) {
        return UNSAFE.getFloat(null, struct + (long)CONE_APEX + Checks.check(index, 3) * 4L);
    }

    public static FloatBuffer ncone_axis(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)CONE_AXIS, 3);
    }

    public static float ncone_axis(long struct, int index) {
        return UNSAFE.getFloat(null, struct + (long)CONE_AXIS + Checks.check(index, 3) * 4L);
    }

    public static float ncone_cutoff(long struct) {
        return UNSAFE.getFloat(null, struct + (long)CONE_CUTOFF);
    }

    public static ByteBuffer ncone_axis_s8(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)CONE_AXIS_S8, 3);
    }

    public static byte ncone_axis_s8(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)CONE_AXIS_S8 + Checks.check(index, 3) * 1L);
    }

    public static byte ncone_cutoff_s8(long struct) {
        return UNSAFE.getByte(null, struct + (long)CONE_CUTOFF_S8);
    }

    static {
        Struct.Layout layout = MeshoptBounds.__struct(MeshoptBounds.__array(4, 3), MeshoptBounds.__member(4), MeshoptBounds.__array(4, 3), MeshoptBounds.__array(4, 3), MeshoptBounds.__member(4), MeshoptBounds.__array(1, 3), MeshoptBounds.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CENTER = layout.offsetof(0);
        RADIUS = layout.offsetof(1);
        CONE_APEX = layout.offsetof(2);
        CONE_AXIS = layout.offsetof(3);
        CONE_CUTOFF = layout.offsetof(4);
        CONE_AXIS_S8 = layout.offsetof(5);
        CONE_CUTOFF_S8 = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<MeshoptBounds, Buffer>
    implements NativeResource {
        private static final MeshoptBounds ELEMENT_FACTORY = MeshoptBounds.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected MeshoptBounds getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="float[3]")
        public FloatBuffer center() {
            return MeshoptBounds.ncenter(this.address());
        }

        public float center(int index) {
            return MeshoptBounds.ncenter(this.address(), index);
        }

        public float radius() {
            return MeshoptBounds.nradius(this.address());
        }

        @NativeType(value="float[3]")
        public FloatBuffer cone_apex() {
            return MeshoptBounds.ncone_apex(this.address());
        }

        public float cone_apex(int index) {
            return MeshoptBounds.ncone_apex(this.address(), index);
        }

        @NativeType(value="float[3]")
        public FloatBuffer cone_axis() {
            return MeshoptBounds.ncone_axis(this.address());
        }

        public float cone_axis(int index) {
            return MeshoptBounds.ncone_axis(this.address(), index);
        }

        public float cone_cutoff() {
            return MeshoptBounds.ncone_cutoff(this.address());
        }

        @NativeType(value="char[3]")
        public ByteBuffer cone_axis_s8() {
            return MeshoptBounds.ncone_axis_s8(this.address());
        }

        @NativeType(value="char")
        public byte cone_axis_s8(int index) {
            return MeshoptBounds.ncone_axis_s8(this.address(), index);
        }

        @NativeType(value="char")
        public byte cone_cutoff_s8() {
            return MeshoptBounds.ncone_cutoff_s8(this.address());
        }
    }
}

