/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.meow;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.meow.LibMeow;

@NativeType(value="struct meow_u128")
public class MeowU128
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;

    private static native int offsets(long var0);

    public MeowU128(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), MeowU128.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public static MeowU128 create(long address) {
        return MeowU128.wrap(MeowU128.class, address);
    }

    @Nullable
    public static MeowU128 createSafe(long address) {
        return address == 0L ? null : MeowU128.wrap(MeowU128.class, address);
    }

    public static Buffer create(long address, int capacity) {
        return MeowU128.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : MeowU128.wrap(Buffer.class, address, capacity);
    }

    static {
        LibMeow.initialize();
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer offsets = stack.mallocInt(1);
            SIZEOF = MeowU128.offsets(MemoryUtil.memAddress(offsets));
            ALIGNOF = offsets.get(0);
        }
    }

    public static class Buffer
    extends StructBuffer<MeowU128, Buffer> {
        private static final MeowU128 ELEMENT_FACTORY = MeowU128.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected MeowU128 getElementFactory() {
            return ELEMENT_FACTORY;
        }
    }
}

