/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.meow;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.meow.MeowU128;

@NativeType(value="union meow_hash")
public class MeowHash
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int U128;
    public static final int U64;
    public static final int U32;

    public MeowHash(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), MeowHash.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="meow_u128")
    public MeowU128 u128() {
        return MeowHash.nu128(this.address());
    }

    @NativeType(value="meow_u64[2]")
    public LongBuffer u64() {
        return MeowHash.nu64(this.address());
    }

    @NativeType(value="meow_u64")
    public long u64(int index) {
        return MeowHash.nu64(this.address(), index);
    }

    @NativeType(value="meow_u32[4]")
    public IntBuffer u32() {
        return MeowHash.nu32(this.address());
    }

    @NativeType(value="meow_u32")
    public int u32(int index) {
        return MeowHash.nu32(this.address(), index);
    }

    public static MeowHash malloc() {
        return MeowHash.wrap(MeowHash.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static MeowHash calloc() {
        return MeowHash.wrap(MeowHash.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static MeowHash create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return MeowHash.wrap(MeowHash.class, MemoryUtil.memAddress(container), container);
    }

    public static MeowHash create(long address) {
        return MeowHash.wrap(MeowHash.class, address);
    }

    @Nullable
    public static MeowHash createSafe(long address) {
        return address == 0L ? null : MeowHash.wrap(MeowHash.class, address);
    }

    public static Buffer malloc(int capacity) {
        return MeowHash.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(MeowHash.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return MeowHash.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = MeowHash.__create(capacity, SIZEOF);
        return MeowHash.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return MeowHash.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : MeowHash.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static MeowHash mallocStack() {
        return MeowHash.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static MeowHash callocStack() {
        return MeowHash.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static MeowHash mallocStack(MemoryStack stack) {
        return MeowHash.malloc(stack);
    }

    @Deprecated
    public static MeowHash callocStack(MemoryStack stack) {
        return MeowHash.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return MeowHash.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return MeowHash.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return MeowHash.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return MeowHash.calloc(capacity, stack);
    }

    public static MeowHash malloc(MemoryStack stack) {
        return MeowHash.wrap(MeowHash.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static MeowHash calloc(MemoryStack stack) {
        return MeowHash.wrap(MeowHash.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return MeowHash.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return MeowHash.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static MeowU128 nu128(long struct) {
        return MeowU128.create(struct + (long)U128);
    }

    public static LongBuffer nu64(long struct) {
        return MemoryUtil.memLongBuffer(struct + (long)U64, 2);
    }

    public static long nu64(long struct, int index) {
        return UNSAFE.getLong(null, struct + (long)U64 + Checks.check(index, 2) * 8L);
    }

    public static IntBuffer nu32(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)U32, 4);
    }

    public static int nu32(long struct, int index) {
        return UNSAFE.getInt(null, struct + (long)U32 + Checks.check(index, 4) * 4L);
    }

    static {
        Struct.Layout layout = MeowHash.__union(MeowHash.__member(MeowU128.SIZEOF, MeowU128.ALIGNOF, true), MeowHash.__array(8, 2), MeowHash.__array(4, 4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        U128 = layout.offsetof(0);
        U64 = layout.offsetof(1);
        U32 = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<MeowHash, Buffer>
    implements NativeResource {
        private static final MeowHash ELEMENT_FACTORY = MeowHash.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected MeowHash getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="meow_u128")
        public MeowU128 u128() {
            return MeowHash.nu128(this.address());
        }

        @NativeType(value="meow_u64[2]")
        public LongBuffer u64() {
            return MeowHash.nu64(this.address());
        }

        @NativeType(value="meow_u64")
        public long u64(int index) {
            return MeowHash.nu64(this.address(), index);
        }

        @NativeType(value="meow_u32[4]")
        public IntBuffer u32() {
            return MeowHash.nu32(this.address());
        }

        @NativeType(value="meow_u32")
        public int u32(int index) {
            return MeowHash.nu32(this.address(), index);
        }
    }
}

