/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.meow;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.util.meow.LibMeow;
import org.lwjgl.util.meow.MeowHash;
import org.lwjgl.util.meow.MeowHashState;

public class Meow {
    public static final int MEOW_HASH_VERSION = 4;
    public static final String MEOW_HASH_VERSION_NAME = "0.4/himalayan";

    protected Meow() {
        throw new UnsupportedOperationException();
    }

    public static native long nMeowU64From(long var0);

    @NativeType(value="meow_u64")
    public static long MeowU64From(@NativeType(value="meow_hash") MeowHash Hash) {
        return Meow.nMeowU64From(Hash.address());
    }

    public static native int nMeowU32From(long var0);

    @NativeType(value="meow_u32")
    public static int MeowU32From(@NativeType(value="meow_hash") MeowHash Hash) {
        return Meow.nMeowU32From(Hash.address());
    }

    public static native int nMeowHashesAreEqual(long var0, long var2);

    @NativeType(value="int")
    public static boolean MeowHashesAreEqual(@NativeType(value="meow_hash") MeowHash A, @NativeType(value="meow_hash") MeowHash B) {
        return Meow.nMeowHashesAreEqual(A.address(), B.address()) != 0;
    }

    public static native void nMeowHash_Accelerated(long var0, long var2, long var4, long var6);

    @NativeType(value="meow_hash")
    public static MeowHash MeowHash_Accelerated(@NativeType(value="meow_u64") long Seed, @NativeType(value="void *") ByteBuffer SourceInit, @NativeType(value="meow_hash") MeowHash __result) {
        Meow.nMeowHash_Accelerated(Seed, SourceInit.remaining(), MemoryUtil.memAddress(SourceInit), __result.address());
        return __result;
    }

    @NativeType(value="meow_hash")
    public static MeowHash MeowHash_Accelerated(@NativeType(value="meow_u64") long Seed, @NativeType(value="void *") ShortBuffer SourceInit, @NativeType(value="meow_hash") MeowHash __result) {
        Meow.nMeowHash_Accelerated(Seed, Integer.toUnsignedLong(SourceInit.remaining()) << 1, MemoryUtil.memAddress(SourceInit), __result.address());
        return __result;
    }

    @NativeType(value="meow_hash")
    public static MeowHash MeowHash_Accelerated(@NativeType(value="meow_u64") long Seed, @NativeType(value="void *") IntBuffer SourceInit, @NativeType(value="meow_hash") MeowHash __result) {
        Meow.nMeowHash_Accelerated(Seed, Integer.toUnsignedLong(SourceInit.remaining()) << 2, MemoryUtil.memAddress(SourceInit), __result.address());
        return __result;
    }

    @NativeType(value="meow_hash")
    public static MeowHash MeowHash_Accelerated(@NativeType(value="meow_u64") long Seed, @NativeType(value="void *") LongBuffer SourceInit, @NativeType(value="meow_hash") MeowHash __result) {
        Meow.nMeowHash_Accelerated(Seed, Integer.toUnsignedLong(SourceInit.remaining()) << 3, MemoryUtil.memAddress(SourceInit), __result.address());
        return __result;
    }

    @NativeType(value="meow_hash")
    public static MeowHash MeowHash_Accelerated(@NativeType(value="meow_u64") long Seed, @NativeType(value="void *") FloatBuffer SourceInit, @NativeType(value="meow_hash") MeowHash __result) {
        Meow.nMeowHash_Accelerated(Seed, Integer.toUnsignedLong(SourceInit.remaining()) << 2, MemoryUtil.memAddress(SourceInit), __result.address());
        return __result;
    }

    @NativeType(value="meow_hash")
    public static MeowHash MeowHash_Accelerated(@NativeType(value="meow_u64") long Seed, @NativeType(value="void *") DoubleBuffer SourceInit, @NativeType(value="meow_hash") MeowHash __result) {
        Meow.nMeowHash_Accelerated(Seed, Integer.toUnsignedLong(SourceInit.remaining()) << 3, MemoryUtil.memAddress(SourceInit), __result.address());
        return __result;
    }

    @NativeType(value="meow_hash")
    public static MeowHash MeowHash_Accelerated(@NativeType(value="meow_u64") long Seed, @NativeType(value="void *") PointerBuffer SourceInit, @NativeType(value="meow_hash") MeowHash __result) {
        Meow.nMeowHash_Accelerated(Seed, Integer.toUnsignedLong(SourceInit.remaining()) << Pointer.POINTER_SHIFT, MemoryUtil.memAddress(SourceInit), __result.address());
        return __result;
    }

    public static native void nMeowHashBegin(long var0);

    public static void MeowHashBegin(@NativeType(value="meow_hash_state *") MeowHashState State2) {
        Meow.nMeowHashBegin(State2.address());
    }

    public static native void nMeowHashAbsorb(long var0, long var2, long var4);

    public static void MeowHashAbsorb(@NativeType(value="meow_hash_state *") MeowHashState State2, @NativeType(value="void *") ByteBuffer SourceInit) {
        Meow.nMeowHashAbsorb(State2.address(), SourceInit.remaining(), MemoryUtil.memAddress(SourceInit));
    }

    public static native void nMeowHashEnd(long var0, long var2, long var4);

    @NativeType(value="meow_hash")
    public static MeowHash MeowHashEnd(@NativeType(value="meow_hash_state *") MeowHashState State2, @NativeType(value="meow_u64") long Seed, @NativeType(value="meow_hash") MeowHash __result) {
        Meow.nMeowHashEnd(State2.address(), Seed, __result.address());
        return __result;
    }

    static {
        LibMeow.initialize();
    }
}

