/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.lz4;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.lz4.LZ4FFrameInfo;

@NativeType(value="struct LZ4F_preferences_t")
public class LZ4FPreferences
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FRAMEINFO;
    public static final int COMPRESSIONLEVEL;
    public static final int AUTOFLUSH;
    public static final int FAVORDECSPEED;
    public static final int RESERVED;

    public LZ4FPreferences(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), LZ4FPreferences.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="LZ4F_frameInfo_t")
    public LZ4FFrameInfo frameInfo() {
        return LZ4FPreferences.nframeInfo(this.address());
    }

    public int compressionLevel() {
        return LZ4FPreferences.ncompressionLevel(this.address());
    }

    @NativeType(value="unsigned")
    public boolean autoFlush() {
        return LZ4FPreferences.nautoFlush(this.address()) != 0;
    }

    @NativeType(value="unsigned")
    public boolean favorDecSpeed() {
        return LZ4FPreferences.nfavorDecSpeed(this.address()) != 0;
    }

    @NativeType(value="unsigned[3]")
    public IntBuffer reserved() {
        return LZ4FPreferences.nreserved(this.address());
    }

    @NativeType(value="unsigned")
    public int reserved(int index) {
        return LZ4FPreferences.nreserved(this.address(), index);
    }

    public LZ4FPreferences frameInfo(@NativeType(value="LZ4F_frameInfo_t") LZ4FFrameInfo value) {
        LZ4FPreferences.nframeInfo(this.address(), value);
        return this;
    }

    public LZ4FPreferences frameInfo(Consumer<LZ4FFrameInfo> consumer) {
        consumer.accept(this.frameInfo());
        return this;
    }

    public LZ4FPreferences compressionLevel(int value) {
        LZ4FPreferences.ncompressionLevel(this.address(), value);
        return this;
    }

    public LZ4FPreferences autoFlush(@NativeType(value="unsigned") boolean value) {
        LZ4FPreferences.nautoFlush(this.address(), value ? 1 : 0);
        return this;
    }

    public LZ4FPreferences favorDecSpeed(@NativeType(value="unsigned") boolean value) {
        LZ4FPreferences.nfavorDecSpeed(this.address(), value ? 1 : 0);
        return this;
    }

    public LZ4FPreferences reserved(@NativeType(value="unsigned[3]") IntBuffer value) {
        LZ4FPreferences.nreserved(this.address(), value);
        return this;
    }

    public LZ4FPreferences reserved(int index, @NativeType(value="unsigned") int value) {
        LZ4FPreferences.nreserved(this.address(), index, value);
        return this;
    }

    public LZ4FPreferences set(LZ4FFrameInfo frameInfo, int compressionLevel, boolean autoFlush, boolean favorDecSpeed, IntBuffer reserved) {
        this.frameInfo(frameInfo);
        this.compressionLevel(compressionLevel);
        this.autoFlush(autoFlush);
        this.favorDecSpeed(favorDecSpeed);
        this.reserved(reserved);
        return this;
    }

    public LZ4FPreferences set(LZ4FPreferences src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static LZ4FPreferences malloc() {
        return LZ4FPreferences.wrap(LZ4FPreferences.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static LZ4FPreferences calloc() {
        return LZ4FPreferences.wrap(LZ4FPreferences.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static LZ4FPreferences create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return LZ4FPreferences.wrap(LZ4FPreferences.class, MemoryUtil.memAddress(container), container);
    }

    public static LZ4FPreferences create(long address) {
        return LZ4FPreferences.wrap(LZ4FPreferences.class, address);
    }

    @Nullable
    public static LZ4FPreferences createSafe(long address) {
        return address == 0L ? null : LZ4FPreferences.wrap(LZ4FPreferences.class, address);
    }

    public static Buffer malloc(int capacity) {
        return LZ4FPreferences.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(LZ4FPreferences.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return LZ4FPreferences.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LZ4FPreferences.__create(capacity, SIZEOF);
        return LZ4FPreferences.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return LZ4FPreferences.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : LZ4FPreferences.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static LZ4FPreferences mallocStack() {
        return LZ4FPreferences.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static LZ4FPreferences callocStack() {
        return LZ4FPreferences.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static LZ4FPreferences mallocStack(MemoryStack stack) {
        return LZ4FPreferences.malloc(stack);
    }

    @Deprecated
    public static LZ4FPreferences callocStack(MemoryStack stack) {
        return LZ4FPreferences.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return LZ4FPreferences.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return LZ4FPreferences.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return LZ4FPreferences.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return LZ4FPreferences.calloc(capacity, stack);
    }

    public static LZ4FPreferences malloc(MemoryStack stack) {
        return LZ4FPreferences.wrap(LZ4FPreferences.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static LZ4FPreferences calloc(MemoryStack stack) {
        return LZ4FPreferences.wrap(LZ4FPreferences.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return LZ4FPreferences.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return LZ4FPreferences.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static LZ4FFrameInfo nframeInfo(long struct) {
        return LZ4FFrameInfo.create(struct + (long)FRAMEINFO);
    }

    public static int ncompressionLevel(long struct) {
        return UNSAFE.getInt(null, struct + (long)COMPRESSIONLEVEL);
    }

    public static int nautoFlush(long struct) {
        return UNSAFE.getInt(null, struct + (long)AUTOFLUSH);
    }

    public static int nfavorDecSpeed(long struct) {
        return UNSAFE.getInt(null, struct + (long)FAVORDECSPEED);
    }

    public static IntBuffer nreserved(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)RESERVED, 3);
    }

    public static int nreserved(long struct, int index) {
        return UNSAFE.getInt(null, struct + (long)RESERVED + Checks.check(index, 3) * 4L);
    }

    public static void nframeInfo(long struct, LZ4FFrameInfo value) {
        MemoryUtil.memCopy(value.address(), struct + (long)FRAMEINFO, LZ4FFrameInfo.SIZEOF);
    }

    public static void ncompressionLevel(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COMPRESSIONLEVEL, value);
    }

    public static void nautoFlush(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)AUTOFLUSH, value);
    }

    public static void nfavorDecSpeed(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FAVORDECSPEED, value);
    }

    public static void nreserved(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 3);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)RESERVED, value.remaining() * 4);
    }

    public static void nreserved(long struct, int index, int value) {
        UNSAFE.putInt(null, struct + (long)RESERVED + Checks.check(index, 3) * 4L, value);
    }

    static {
        Struct.Layout layout = LZ4FPreferences.__struct(LZ4FPreferences.__member(LZ4FFrameInfo.SIZEOF, LZ4FFrameInfo.ALIGNOF), LZ4FPreferences.__member(4), LZ4FPreferences.__member(4), LZ4FPreferences.__member(4), LZ4FPreferences.__array(4, 3));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FRAMEINFO = layout.offsetof(0);
        COMPRESSIONLEVEL = layout.offsetof(1);
        AUTOFLUSH = layout.offsetof(2);
        FAVORDECSPEED = layout.offsetof(3);
        RESERVED = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<LZ4FPreferences, Buffer>
    implements NativeResource {
        private static final LZ4FPreferences ELEMENT_FACTORY = LZ4FPreferences.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected LZ4FPreferences getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="LZ4F_frameInfo_t")
        public LZ4FFrameInfo frameInfo() {
            return LZ4FPreferences.nframeInfo(this.address());
        }

        public int compressionLevel() {
            return LZ4FPreferences.ncompressionLevel(this.address());
        }

        @NativeType(value="unsigned")
        public boolean autoFlush() {
            return LZ4FPreferences.nautoFlush(this.address()) != 0;
        }

        @NativeType(value="unsigned")
        public boolean favorDecSpeed() {
            return LZ4FPreferences.nfavorDecSpeed(this.address()) != 0;
        }

        @NativeType(value="unsigned[3]")
        public IntBuffer reserved() {
            return LZ4FPreferences.nreserved(this.address());
        }

        @NativeType(value="unsigned")
        public int reserved(int index) {
            return LZ4FPreferences.nreserved(this.address(), index);
        }

        public Buffer frameInfo(@NativeType(value="LZ4F_frameInfo_t") LZ4FFrameInfo value) {
            LZ4FPreferences.nframeInfo(this.address(), value);
            return this;
        }

        public Buffer frameInfo(Consumer<LZ4FFrameInfo> consumer) {
            consumer.accept(this.frameInfo());
            return this;
        }

        public Buffer compressionLevel(int value) {
            LZ4FPreferences.ncompressionLevel(this.address(), value);
            return this;
        }

        public Buffer autoFlush(@NativeType(value="unsigned") boolean value) {
            LZ4FPreferences.nautoFlush(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer favorDecSpeed(@NativeType(value="unsigned") boolean value) {
            LZ4FPreferences.nfavorDecSpeed(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer reserved(@NativeType(value="unsigned[3]") IntBuffer value) {
            LZ4FPreferences.nreserved(this.address(), value);
            return this;
        }

        public Buffer reserved(int index, @NativeType(value="unsigned") int value) {
            LZ4FPreferences.nreserved(this.address(), index, value);
            return this;
        }
    }
}

