/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.lz4;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct LZ4F_decompressOptions_t")
public class LZ4FDecompressOptions
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STABLEDST;
    public static final int RESERVED;

    public LZ4FDecompressOptions(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), LZ4FDecompressOptions.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned")
    public int stableDst() {
        return LZ4FDecompressOptions.nstableDst(this.address());
    }

    @NativeType(value="unsigned[3]")
    public IntBuffer reserved() {
        return LZ4FDecompressOptions.nreserved(this.address());
    }

    @NativeType(value="unsigned")
    public int reserved(int index) {
        return LZ4FDecompressOptions.nreserved(this.address(), index);
    }

    public LZ4FDecompressOptions stableDst(@NativeType(value="unsigned") int value) {
        LZ4FDecompressOptions.nstableDst(this.address(), value);
        return this;
    }

    public LZ4FDecompressOptions reserved(@NativeType(value="unsigned[3]") IntBuffer value) {
        LZ4FDecompressOptions.nreserved(this.address(), value);
        return this;
    }

    public LZ4FDecompressOptions reserved(int index, @NativeType(value="unsigned") int value) {
        LZ4FDecompressOptions.nreserved(this.address(), index, value);
        return this;
    }

    public LZ4FDecompressOptions set(int stableDst, IntBuffer reserved) {
        this.stableDst(stableDst);
        this.reserved(reserved);
        return this;
    }

    public LZ4FDecompressOptions set(LZ4FDecompressOptions src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static LZ4FDecompressOptions malloc() {
        return LZ4FDecompressOptions.wrap(LZ4FDecompressOptions.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static LZ4FDecompressOptions calloc() {
        return LZ4FDecompressOptions.wrap(LZ4FDecompressOptions.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static LZ4FDecompressOptions create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return LZ4FDecompressOptions.wrap(LZ4FDecompressOptions.class, MemoryUtil.memAddress(container), container);
    }

    public static LZ4FDecompressOptions create(long address) {
        return LZ4FDecompressOptions.wrap(LZ4FDecompressOptions.class, address);
    }

    @Nullable
    public static LZ4FDecompressOptions createSafe(long address) {
        return address == 0L ? null : LZ4FDecompressOptions.wrap(LZ4FDecompressOptions.class, address);
    }

    public static Buffer malloc(int capacity) {
        return LZ4FDecompressOptions.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(LZ4FDecompressOptions.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return LZ4FDecompressOptions.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LZ4FDecompressOptions.__create(capacity, SIZEOF);
        return LZ4FDecompressOptions.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return LZ4FDecompressOptions.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : LZ4FDecompressOptions.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static LZ4FDecompressOptions mallocStack() {
        return LZ4FDecompressOptions.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static LZ4FDecompressOptions callocStack() {
        return LZ4FDecompressOptions.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static LZ4FDecompressOptions mallocStack(MemoryStack stack) {
        return LZ4FDecompressOptions.malloc(stack);
    }

    @Deprecated
    public static LZ4FDecompressOptions callocStack(MemoryStack stack) {
        return LZ4FDecompressOptions.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return LZ4FDecompressOptions.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return LZ4FDecompressOptions.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return LZ4FDecompressOptions.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return LZ4FDecompressOptions.calloc(capacity, stack);
    }

    public static LZ4FDecompressOptions malloc(MemoryStack stack) {
        return LZ4FDecompressOptions.wrap(LZ4FDecompressOptions.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static LZ4FDecompressOptions calloc(MemoryStack stack) {
        return LZ4FDecompressOptions.wrap(LZ4FDecompressOptions.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return LZ4FDecompressOptions.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return LZ4FDecompressOptions.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nstableDst(long struct) {
        return UNSAFE.getInt(null, struct + (long)STABLEDST);
    }

    public static IntBuffer nreserved(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)RESERVED, 3);
    }

    public static int nreserved(long struct, int index) {
        return UNSAFE.getInt(null, struct + (long)RESERVED + Checks.check(index, 3) * 4L);
    }

    public static void nstableDst(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STABLEDST, value);
    }

    public static void nreserved(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 3);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)RESERVED, value.remaining() * 4);
    }

    public static void nreserved(long struct, int index, int value) {
        UNSAFE.putInt(null, struct + (long)RESERVED + Checks.check(index, 3) * 4L, value);
    }

    static {
        Struct.Layout layout = LZ4FDecompressOptions.__struct(LZ4FDecompressOptions.__member(4), LZ4FDecompressOptions.__array(4, 3));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STABLEDST = layout.offsetof(0);
        RESERVED = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LZ4FDecompressOptions, Buffer>
    implements NativeResource {
        private static final LZ4FDecompressOptions ELEMENT_FACTORY = LZ4FDecompressOptions.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected LZ4FDecompressOptions getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned")
        public int stableDst() {
            return LZ4FDecompressOptions.nstableDst(this.address());
        }

        @NativeType(value="unsigned[3]")
        public IntBuffer reserved() {
            return LZ4FDecompressOptions.nreserved(this.address());
        }

        @NativeType(value="unsigned")
        public int reserved(int index) {
            return LZ4FDecompressOptions.nreserved(this.address(), index);
        }

        public Buffer stableDst(@NativeType(value="unsigned") int value) {
            LZ4FDecompressOptions.nstableDst(this.address(), value);
            return this;
        }

        public Buffer reserved(@NativeType(value="unsigned[3]") IntBuffer value) {
            LZ4FDecompressOptions.nreserved(this.address(), value);
            return this;
        }

        public Buffer reserved(int index, @NativeType(value="unsigned") int value) {
            LZ4FDecompressOptions.nreserved(this.address(), index, value);
            return this;
        }
    }
}

