/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.lmdb;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct MDB_val")
public class MDBVal
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MV_SIZE;
    public static final int MV_DATA;

    public MDBVal(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), MDBVal.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="size_t")
    public long mv_size() {
        return MDBVal.nmv_size(this.address());
    }

    @Nullable
    @NativeType(value="void *")
    public ByteBuffer mv_data() {
        return MDBVal.nmv_data(this.address());
    }

    public MDBVal mv_size(@NativeType(value="size_t") long value) {
        MDBVal.nmv_size(this.address(), value);
        return this;
    }

    public MDBVal mv_data(@Nullable @NativeType(value="void *") ByteBuffer value) {
        MDBVal.nmv_data(this.address(), value);
        return this;
    }

    public MDBVal set(long mv_size, @Nullable ByteBuffer mv_data) {
        this.mv_size(mv_size);
        this.mv_data(mv_data);
        return this;
    }

    public MDBVal set(MDBVal src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static MDBVal malloc() {
        return MDBVal.wrap(MDBVal.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static MDBVal calloc() {
        return MDBVal.wrap(MDBVal.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static MDBVal create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return MDBVal.wrap(MDBVal.class, MemoryUtil.memAddress(container), container);
    }

    public static MDBVal create(long address) {
        return MDBVal.wrap(MDBVal.class, address);
    }

    @Nullable
    public static MDBVal createSafe(long address) {
        return address == 0L ? null : MDBVal.wrap(MDBVal.class, address);
    }

    public static Buffer malloc(int capacity) {
        return MDBVal.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(MDBVal.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return MDBVal.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = MDBVal.__create(capacity, SIZEOF);
        return MDBVal.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return MDBVal.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : MDBVal.wrap(Buffer.class, address, capacity);
    }

    @Deprecated
    public static MDBVal mallocStack() {
        return MDBVal.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static MDBVal callocStack() {
        return MDBVal.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static MDBVal mallocStack(MemoryStack stack) {
        return MDBVal.malloc(stack);
    }

    @Deprecated
    public static MDBVal callocStack(MemoryStack stack) {
        return MDBVal.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return MDBVal.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return MDBVal.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return MDBVal.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return MDBVal.calloc(capacity, stack);
    }

    public static MDBVal malloc(MemoryStack stack) {
        return MDBVal.wrap(MDBVal.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static MDBVal calloc(MemoryStack stack) {
        return MDBVal.wrap(MDBVal.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return MDBVal.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return MDBVal.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nmv_size(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)MV_SIZE);
    }

    @Nullable
    public static ByteBuffer nmv_data(long struct) {
        return MemoryUtil.memByteBufferSafe(MemoryUtil.memGetAddress(struct + (long)MV_DATA), (int)MDBVal.nmv_size(struct));
    }

    public static void nmv_size(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)MV_SIZE, value);
    }

    public static void nmv_data(long struct, @Nullable ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)MV_DATA, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            MDBVal.nmv_size(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = MDBVal.__struct(MDBVal.__member(POINTER_SIZE), MDBVal.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MV_SIZE = layout.offsetof(0);
        MV_DATA = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<MDBVal, Buffer>
    implements NativeResource {
        private static final MDBVal ELEMENT_FACTORY = MDBVal.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected MDBVal getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="size_t")
        public long mv_size() {
            return MDBVal.nmv_size(this.address());
        }

        @Nullable
        @NativeType(value="void *")
        public ByteBuffer mv_data() {
            return MDBVal.nmv_data(this.address());
        }

        public Buffer mv_size(@NativeType(value="size_t") long value) {
            MDBVal.nmv_size(this.address(), value);
            return this;
        }

        public Buffer mv_data(@Nullable @NativeType(value="void *") ByteBuffer value) {
            MDBVal.nmv_data(this.address(), value);
            return this;
        }
    }
}

