/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.jawt;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct JAWT_X11DrawingSurfaceInfo")
public class JAWTX11DrawingSurfaceInfo
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DRAWABLE;
    public static final int DISPLAY;
    public static final int VISUALID;
    public static final int COLORMAPID;
    public static final int DEPTH;

    public JAWTX11DrawingSurfaceInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), JAWTX11DrawingSurfaceInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="Drawable")
    public long drawable() {
        return JAWTX11DrawingSurfaceInfo.ndrawable(this.address());
    }

    @NativeType(value="Display *")
    public long display() {
        return JAWTX11DrawingSurfaceInfo.ndisplay(this.address());
    }

    @NativeType(value="VisualID")
    public long visualID() {
        return JAWTX11DrawingSurfaceInfo.nvisualID(this.address());
    }

    @NativeType(value="Colormap")
    public long colormapID() {
        return JAWTX11DrawingSurfaceInfo.ncolormapID(this.address());
    }

    public int depth() {
        return JAWTX11DrawingSurfaceInfo.ndepth(this.address());
    }

    public static JAWTX11DrawingSurfaceInfo create(long address) {
        return JAWTX11DrawingSurfaceInfo.wrap(JAWTX11DrawingSurfaceInfo.class, address);
    }

    @Nullable
    public static JAWTX11DrawingSurfaceInfo createSafe(long address) {
        return address == 0L ? null : JAWTX11DrawingSurfaceInfo.wrap(JAWTX11DrawingSurfaceInfo.class, address);
    }

    public static Buffer create(long address, int capacity) {
        return JAWTX11DrawingSurfaceInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : JAWTX11DrawingSurfaceInfo.wrap(Buffer.class, address, capacity);
    }

    public static long ndrawable(long struct) {
        return MemoryUtil.memGetCLong(struct + (long)DRAWABLE);
    }

    public static long ndisplay(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DISPLAY);
    }

    public static long nvisualID(long struct) {
        return MemoryUtil.memGetCLong(struct + (long)VISUALID);
    }

    public static long ncolormapID(long struct) {
        return MemoryUtil.memGetCLong(struct + (long)COLORMAPID);
    }

    public static int ndepth(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEPTH);
    }

    static {
        Struct.Layout layout = JAWTX11DrawingSurfaceInfo.__struct(JAWTX11DrawingSurfaceInfo.__member(CLONG_SIZE), JAWTX11DrawingSurfaceInfo.__member(POINTER_SIZE), JAWTX11DrawingSurfaceInfo.__member(CLONG_SIZE), JAWTX11DrawingSurfaceInfo.__member(CLONG_SIZE), JAWTX11DrawingSurfaceInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DRAWABLE = layout.offsetof(0);
        DISPLAY = layout.offsetof(1);
        VISUALID = layout.offsetof(2);
        COLORMAPID = layout.offsetof(3);
        DEPTH = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<JAWTX11DrawingSurfaceInfo, Buffer> {
        private static final JAWTX11DrawingSurfaceInfo ELEMENT_FACTORY = JAWTX11DrawingSurfaceInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected JAWTX11DrawingSurfaceInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="Drawable")
        public long drawable() {
            return JAWTX11DrawingSurfaceInfo.ndrawable(this.address());
        }

        @NativeType(value="Display *")
        public long display() {
            return JAWTX11DrawingSurfaceInfo.ndisplay(this.address());
        }

        @NativeType(value="VisualID")
        public long visualID() {
            return JAWTX11DrawingSurfaceInfo.nvisualID(this.address());
        }

        @NativeType(value="Colormap")
        public long colormapID() {
            return JAWTX11DrawingSurfaceInfo.ncolormapID(this.address());
        }

        public int depth() {
            return JAWTX11DrawingSurfaceInfo.ndepth(this.address());
        }
    }
}

