/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrViveTrackerPathsHTCX
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int PERSISTENTPATH;
    public static final int ROLEPATH;

    public XrViveTrackerPathsHTCX(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrViveTrackerPathsHTCX.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrViveTrackerPathsHTCX.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrViveTrackerPathsHTCX.nnext(this.address());
    }

    @NativeType(value="XrPath")
    public long persistentPath() {
        return XrViveTrackerPathsHTCX.npersistentPath(this.address());
    }

    @NativeType(value="XrPath")
    public long rolePath() {
        return XrViveTrackerPathsHTCX.nrolePath(this.address());
    }

    public XrViveTrackerPathsHTCX type(@NativeType(value="XrStructureType") int value) {
        XrViveTrackerPathsHTCX.ntype(this.address(), value);
        return this;
    }

    public XrViveTrackerPathsHTCX type$Default() {
        return this.type(1000103000);
    }

    public XrViveTrackerPathsHTCX next(@NativeType(value="void *") long value) {
        XrViveTrackerPathsHTCX.nnext(this.address(), value);
        return this;
    }

    public XrViveTrackerPathsHTCX set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrViveTrackerPathsHTCX set(XrViveTrackerPathsHTCX src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrViveTrackerPathsHTCX malloc() {
        return XrViveTrackerPathsHTCX.wrap(XrViveTrackerPathsHTCX.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrViveTrackerPathsHTCX calloc() {
        return XrViveTrackerPathsHTCX.wrap(XrViveTrackerPathsHTCX.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrViveTrackerPathsHTCX create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrViveTrackerPathsHTCX.wrap(XrViveTrackerPathsHTCX.class, MemoryUtil.memAddress(container), container);
    }

    public static XrViveTrackerPathsHTCX create(long address) {
        return XrViveTrackerPathsHTCX.wrap(XrViveTrackerPathsHTCX.class, address);
    }

    @Nullable
    public static XrViveTrackerPathsHTCX createSafe(long address) {
        return address == 0L ? null : XrViveTrackerPathsHTCX.wrap(XrViveTrackerPathsHTCX.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrViveTrackerPathsHTCX.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrViveTrackerPathsHTCX.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrViveTrackerPathsHTCX.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrViveTrackerPathsHTCX.__create(capacity, SIZEOF);
        return XrViveTrackerPathsHTCX.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrViveTrackerPathsHTCX.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrViveTrackerPathsHTCX.wrap(Buffer.class, address, capacity);
    }

    public static XrViveTrackerPathsHTCX malloc(MemoryStack stack) {
        return XrViveTrackerPathsHTCX.wrap(XrViveTrackerPathsHTCX.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrViveTrackerPathsHTCX calloc(MemoryStack stack) {
        return XrViveTrackerPathsHTCX.wrap(XrViveTrackerPathsHTCX.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrViveTrackerPathsHTCX.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrViveTrackerPathsHTCX.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long npersistentPath(long struct) {
        return UNSAFE.getLong(null, struct + (long)PERSISTENTPATH);
    }

    public static long nrolePath(long struct) {
        return UNSAFE.getLong(null, struct + (long)ROLEPATH);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    static {
        Struct.Layout layout = XrViveTrackerPathsHTCX.__struct(XrViveTrackerPathsHTCX.__member(4), XrViveTrackerPathsHTCX.__member(POINTER_SIZE), XrViveTrackerPathsHTCX.__member(8), XrViveTrackerPathsHTCX.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        PERSISTENTPATH = layout.offsetof(2);
        ROLEPATH = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrViveTrackerPathsHTCX, Buffer>
    implements NativeResource {
        private static final XrViveTrackerPathsHTCX ELEMENT_FACTORY = XrViveTrackerPathsHTCX.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrViveTrackerPathsHTCX getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrViveTrackerPathsHTCX.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrViveTrackerPathsHTCX.nnext(this.address());
        }

        @NativeType(value="XrPath")
        public long persistentPath() {
            return XrViveTrackerPathsHTCX.npersistentPath(this.address());
        }

        @NativeType(value="XrPath")
        public long rolePath() {
            return XrViveTrackerPathsHTCX.nrolePath(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrViveTrackerPathsHTCX.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000103000);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrViveTrackerPathsHTCX.nnext(this.address(), value);
            return this;
        }
    }
}

