/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrVector2f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrVisibilityMaskKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int VERTEXCAPACITYINPUT;
    public static final int VERTEXCOUNTOUTPUT;
    public static final int VERTICES;
    public static final int INDEXCAPACITYINPUT;
    public static final int INDEXCOUNTOUTPUT;
    public static final int INDICES;

    public XrVisibilityMaskKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrVisibilityMaskKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrVisibilityMaskKHR.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrVisibilityMaskKHR.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int vertexCapacityInput() {
        return XrVisibilityMaskKHR.nvertexCapacityInput(this.address());
    }

    @NativeType(value="uint32_t")
    public int vertexCountOutput() {
        return XrVisibilityMaskKHR.nvertexCountOutput(this.address());
    }

    @Nullable
    @NativeType(value="XrVector2f *")
    public XrVector2f.Buffer vertices() {
        return XrVisibilityMaskKHR.nvertices(this.address());
    }

    @NativeType(value="uint32_t")
    public int indexCapacityInput() {
        return XrVisibilityMaskKHR.nindexCapacityInput(this.address());
    }

    @NativeType(value="uint32_t")
    public int indexCountOutput() {
        return XrVisibilityMaskKHR.nindexCountOutput(this.address());
    }

    @Nullable
    @NativeType(value="uint32_t *")
    public IntBuffer indices() {
        return XrVisibilityMaskKHR.nindices(this.address());
    }

    public XrVisibilityMaskKHR type(@NativeType(value="XrStructureType") int value) {
        XrVisibilityMaskKHR.ntype(this.address(), value);
        return this;
    }

    public XrVisibilityMaskKHR type$Default() {
        return this.type(1000031000);
    }

    public XrVisibilityMaskKHR next(@NativeType(value="void *") long value) {
        XrVisibilityMaskKHR.nnext(this.address(), value);
        return this;
    }

    public XrVisibilityMaskKHR vertexCapacityInput(@NativeType(value="uint32_t") int value) {
        XrVisibilityMaskKHR.nvertexCapacityInput(this.address(), value);
        return this;
    }

    public XrVisibilityMaskKHR vertexCountOutput(@NativeType(value="uint32_t") int value) {
        XrVisibilityMaskKHR.nvertexCountOutput(this.address(), value);
        return this;
    }

    public XrVisibilityMaskKHR vertices(@Nullable @NativeType(value="XrVector2f *") XrVector2f.Buffer value) {
        XrVisibilityMaskKHR.nvertices(this.address(), value);
        return this;
    }

    public XrVisibilityMaskKHR indexCapacityInput(@NativeType(value="uint32_t") int value) {
        XrVisibilityMaskKHR.nindexCapacityInput(this.address(), value);
        return this;
    }

    public XrVisibilityMaskKHR indexCountOutput(@NativeType(value="uint32_t") int value) {
        XrVisibilityMaskKHR.nindexCountOutput(this.address(), value);
        return this;
    }

    public XrVisibilityMaskKHR indices(@Nullable @NativeType(value="uint32_t *") IntBuffer value) {
        XrVisibilityMaskKHR.nindices(this.address(), value);
        return this;
    }

    public XrVisibilityMaskKHR set(int type, long next, int vertexCapacityInput, int vertexCountOutput, @Nullable XrVector2f.Buffer vertices, int indexCapacityInput, int indexCountOutput, @Nullable IntBuffer indices) {
        this.type(type);
        this.next(next);
        this.vertexCapacityInput(vertexCapacityInput);
        this.vertexCountOutput(vertexCountOutput);
        this.vertices(vertices);
        this.indexCapacityInput(indexCapacityInput);
        this.indexCountOutput(indexCountOutput);
        this.indices(indices);
        return this;
    }

    public XrVisibilityMaskKHR set(XrVisibilityMaskKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrVisibilityMaskKHR malloc() {
        return XrVisibilityMaskKHR.wrap(XrVisibilityMaskKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrVisibilityMaskKHR calloc() {
        return XrVisibilityMaskKHR.wrap(XrVisibilityMaskKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrVisibilityMaskKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrVisibilityMaskKHR.wrap(XrVisibilityMaskKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static XrVisibilityMaskKHR create(long address) {
        return XrVisibilityMaskKHR.wrap(XrVisibilityMaskKHR.class, address);
    }

    @Nullable
    public static XrVisibilityMaskKHR createSafe(long address) {
        return address == 0L ? null : XrVisibilityMaskKHR.wrap(XrVisibilityMaskKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrVisibilityMaskKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrVisibilityMaskKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrVisibilityMaskKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrVisibilityMaskKHR.__create(capacity, SIZEOF);
        return XrVisibilityMaskKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrVisibilityMaskKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrVisibilityMaskKHR.wrap(Buffer.class, address, capacity);
    }

    public static XrVisibilityMaskKHR malloc(MemoryStack stack) {
        return XrVisibilityMaskKHR.wrap(XrVisibilityMaskKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrVisibilityMaskKHR calloc(MemoryStack stack) {
        return XrVisibilityMaskKHR.wrap(XrVisibilityMaskKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrVisibilityMaskKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrVisibilityMaskKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nvertexCapacityInput(long struct) {
        return UNSAFE.getInt(null, struct + (long)VERTEXCAPACITYINPUT);
    }

    public static int nvertexCountOutput(long struct) {
        return UNSAFE.getInt(null, struct + (long)VERTEXCOUNTOUTPUT);
    }

    @Nullable
    public static XrVector2f.Buffer nvertices(long struct) {
        return XrVector2f.createSafe(MemoryUtil.memGetAddress(struct + (long)VERTICES), XrVisibilityMaskKHR.nvertexCapacityInput(struct));
    }

    public static int nindexCapacityInput(long struct) {
        return UNSAFE.getInt(null, struct + (long)INDEXCAPACITYINPUT);
    }

    public static int nindexCountOutput(long struct) {
        return UNSAFE.getInt(null, struct + (long)INDEXCOUNTOUTPUT);
    }

    @Nullable
    public static IntBuffer nindices(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)INDICES), XrVisibilityMaskKHR.nindexCapacityInput(struct));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nvertexCapacityInput(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VERTEXCAPACITYINPUT, value);
    }

    public static void nvertexCountOutput(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VERTEXCOUNTOUTPUT, value);
    }

    public static void nvertices(long struct, @Nullable XrVector2f.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)VERTICES, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            XrVisibilityMaskKHR.nvertexCapacityInput(struct, value.remaining());
        }
    }

    public static void nindexCapacityInput(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)INDEXCAPACITYINPUT, value);
    }

    public static void nindexCountOutput(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)INDEXCOUNTOUTPUT, value);
    }

    public static void nindices(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)INDICES, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            XrVisibilityMaskKHR.nindexCapacityInput(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = XrVisibilityMaskKHR.__struct(XrVisibilityMaskKHR.__member(4), XrVisibilityMaskKHR.__member(POINTER_SIZE), XrVisibilityMaskKHR.__member(4), XrVisibilityMaskKHR.__member(4), XrVisibilityMaskKHR.__member(POINTER_SIZE), XrVisibilityMaskKHR.__member(4), XrVisibilityMaskKHR.__member(4), XrVisibilityMaskKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        VERTEXCAPACITYINPUT = layout.offsetof(2);
        VERTEXCOUNTOUTPUT = layout.offsetof(3);
        VERTICES = layout.offsetof(4);
        INDEXCAPACITYINPUT = layout.offsetof(5);
        INDEXCOUNTOUTPUT = layout.offsetof(6);
        INDICES = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<XrVisibilityMaskKHR, Buffer>
    implements NativeResource {
        private static final XrVisibilityMaskKHR ELEMENT_FACTORY = XrVisibilityMaskKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrVisibilityMaskKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrVisibilityMaskKHR.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrVisibilityMaskKHR.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int vertexCapacityInput() {
            return XrVisibilityMaskKHR.nvertexCapacityInput(this.address());
        }

        @NativeType(value="uint32_t")
        public int vertexCountOutput() {
            return XrVisibilityMaskKHR.nvertexCountOutput(this.address());
        }

        @Nullable
        @NativeType(value="XrVector2f *")
        public XrVector2f.Buffer vertices() {
            return XrVisibilityMaskKHR.nvertices(this.address());
        }

        @NativeType(value="uint32_t")
        public int indexCapacityInput() {
            return XrVisibilityMaskKHR.nindexCapacityInput(this.address());
        }

        @NativeType(value="uint32_t")
        public int indexCountOutput() {
            return XrVisibilityMaskKHR.nindexCountOutput(this.address());
        }

        @Nullable
        @NativeType(value="uint32_t *")
        public IntBuffer indices() {
            return XrVisibilityMaskKHR.nindices(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrVisibilityMaskKHR.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000031000);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrVisibilityMaskKHR.nnext(this.address(), value);
            return this;
        }

        public Buffer vertexCapacityInput(@NativeType(value="uint32_t") int value) {
            XrVisibilityMaskKHR.nvertexCapacityInput(this.address(), value);
            return this;
        }

        public Buffer vertexCountOutput(@NativeType(value="uint32_t") int value) {
            XrVisibilityMaskKHR.nvertexCountOutput(this.address(), value);
            return this;
        }

        public Buffer vertices(@Nullable @NativeType(value="XrVector2f *") XrVector2f.Buffer value) {
            XrVisibilityMaskKHR.nvertices(this.address(), value);
            return this;
        }

        public Buffer indexCapacityInput(@NativeType(value="uint32_t") int value) {
            XrVisibilityMaskKHR.nindexCapacityInput(this.address(), value);
            return this;
        }

        public Buffer indexCountOutput(@NativeType(value="uint32_t") int value) {
            XrVisibilityMaskKHR.nindexCountOutput(this.address(), value);
            return this;
        }

        public Buffer indices(@Nullable @NativeType(value="uint32_t *") IntBuffer value) {
            XrVisibilityMaskKHR.nindices(this.address(), value);
            return this;
        }
    }
}

