/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrViewState
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int VIEWSTATEFLAGS;

    public XrViewState(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrViewState.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrViewState.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrViewState.nnext(this.address());
    }

    @NativeType(value="XrViewStateFlags")
    public long viewStateFlags() {
        return XrViewState.nviewStateFlags(this.address());
    }

    public XrViewState type(@NativeType(value="XrStructureType") int value) {
        XrViewState.ntype(this.address(), value);
        return this;
    }

    public XrViewState type$Default() {
        return this.type(11);
    }

    public XrViewState next(@NativeType(value="void *") long value) {
        XrViewState.nnext(this.address(), value);
        return this;
    }

    public XrViewState viewStateFlags(@NativeType(value="XrViewStateFlags") long value) {
        XrViewState.nviewStateFlags(this.address(), value);
        return this;
    }

    public XrViewState set(int type, long next, long viewStateFlags) {
        this.type(type);
        this.next(next);
        this.viewStateFlags(viewStateFlags);
        return this;
    }

    public XrViewState set(XrViewState src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrViewState malloc() {
        return XrViewState.wrap(XrViewState.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrViewState calloc() {
        return XrViewState.wrap(XrViewState.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrViewState create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrViewState.wrap(XrViewState.class, MemoryUtil.memAddress(container), container);
    }

    public static XrViewState create(long address) {
        return XrViewState.wrap(XrViewState.class, address);
    }

    @Nullable
    public static XrViewState createSafe(long address) {
        return address == 0L ? null : XrViewState.wrap(XrViewState.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrViewState.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrViewState.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrViewState.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrViewState.__create(capacity, SIZEOF);
        return XrViewState.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrViewState.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrViewState.wrap(Buffer.class, address, capacity);
    }

    public static XrViewState malloc(MemoryStack stack) {
        return XrViewState.wrap(XrViewState.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrViewState calloc(MemoryStack stack) {
        return XrViewState.wrap(XrViewState.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrViewState.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrViewState.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nviewStateFlags(long struct) {
        return UNSAFE.getLong(null, struct + (long)VIEWSTATEFLAGS);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nviewStateFlags(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)VIEWSTATEFLAGS, value);
    }

    static {
        Struct.Layout layout = XrViewState.__struct(XrViewState.__member(4), XrViewState.__member(POINTER_SIZE), XrViewState.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        VIEWSTATEFLAGS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrViewState, Buffer>
    implements NativeResource {
        private static final XrViewState ELEMENT_FACTORY = XrViewState.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrViewState getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrViewState.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrViewState.nnext(this.address());
        }

        @NativeType(value="XrViewStateFlags")
        public long viewStateFlags() {
            return XrViewState.nviewStateFlags(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrViewState.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(11);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrViewState.nnext(this.address(), value);
            return this;
        }

        public Buffer viewStateFlags(@NativeType(value="XrViewStateFlags") long value) {
            XrViewState.nviewStateFlags(this.address(), value);
            return this;
        }
    }
}

