/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrViewConfigurationDepthRangeEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int RECOMMENDEDNEARZ;
    public static final int MINNEARZ;
    public static final int RECOMMENDEDFARZ;
    public static final int MAXFARZ;

    public XrViewConfigurationDepthRangeEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrViewConfigurationDepthRangeEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrViewConfigurationDepthRangeEXT.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrViewConfigurationDepthRangeEXT.nnext(this.address());
    }

    public float recommendedNearZ() {
        return XrViewConfigurationDepthRangeEXT.nrecommendedNearZ(this.address());
    }

    public float minNearZ() {
        return XrViewConfigurationDepthRangeEXT.nminNearZ(this.address());
    }

    public float recommendedFarZ() {
        return XrViewConfigurationDepthRangeEXT.nrecommendedFarZ(this.address());
    }

    public float maxFarZ() {
        return XrViewConfigurationDepthRangeEXT.nmaxFarZ(this.address());
    }

    public XrViewConfigurationDepthRangeEXT type(@NativeType(value="XrStructureType") int value) {
        XrViewConfigurationDepthRangeEXT.ntype(this.address(), value);
        return this;
    }

    public XrViewConfigurationDepthRangeEXT type$Default() {
        return this.type(1000046000);
    }

    public XrViewConfigurationDepthRangeEXT next(@NativeType(value="void *") long value) {
        XrViewConfigurationDepthRangeEXT.nnext(this.address(), value);
        return this;
    }

    public XrViewConfigurationDepthRangeEXT recommendedNearZ(float value) {
        XrViewConfigurationDepthRangeEXT.nrecommendedNearZ(this.address(), value);
        return this;
    }

    public XrViewConfigurationDepthRangeEXT minNearZ(float value) {
        XrViewConfigurationDepthRangeEXT.nminNearZ(this.address(), value);
        return this;
    }

    public XrViewConfigurationDepthRangeEXT recommendedFarZ(float value) {
        XrViewConfigurationDepthRangeEXT.nrecommendedFarZ(this.address(), value);
        return this;
    }

    public XrViewConfigurationDepthRangeEXT maxFarZ(float value) {
        XrViewConfigurationDepthRangeEXT.nmaxFarZ(this.address(), value);
        return this;
    }

    public XrViewConfigurationDepthRangeEXT set(int type, long next, float recommendedNearZ, float minNearZ, float recommendedFarZ, float maxFarZ) {
        this.type(type);
        this.next(next);
        this.recommendedNearZ(recommendedNearZ);
        this.minNearZ(minNearZ);
        this.recommendedFarZ(recommendedFarZ);
        this.maxFarZ(maxFarZ);
        return this;
    }

    public XrViewConfigurationDepthRangeEXT set(XrViewConfigurationDepthRangeEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrViewConfigurationDepthRangeEXT malloc() {
        return XrViewConfigurationDepthRangeEXT.wrap(XrViewConfigurationDepthRangeEXT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrViewConfigurationDepthRangeEXT calloc() {
        return XrViewConfigurationDepthRangeEXT.wrap(XrViewConfigurationDepthRangeEXT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrViewConfigurationDepthRangeEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrViewConfigurationDepthRangeEXT.wrap(XrViewConfigurationDepthRangeEXT.class, MemoryUtil.memAddress(container), container);
    }

    public static XrViewConfigurationDepthRangeEXT create(long address) {
        return XrViewConfigurationDepthRangeEXT.wrap(XrViewConfigurationDepthRangeEXT.class, address);
    }

    @Nullable
    public static XrViewConfigurationDepthRangeEXT createSafe(long address) {
        return address == 0L ? null : XrViewConfigurationDepthRangeEXT.wrap(XrViewConfigurationDepthRangeEXT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrViewConfigurationDepthRangeEXT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrViewConfigurationDepthRangeEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrViewConfigurationDepthRangeEXT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrViewConfigurationDepthRangeEXT.__create(capacity, SIZEOF);
        return XrViewConfigurationDepthRangeEXT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrViewConfigurationDepthRangeEXT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrViewConfigurationDepthRangeEXT.wrap(Buffer.class, address, capacity);
    }

    public static XrViewConfigurationDepthRangeEXT malloc(MemoryStack stack) {
        return XrViewConfigurationDepthRangeEXT.wrap(XrViewConfigurationDepthRangeEXT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrViewConfigurationDepthRangeEXT calloc(MemoryStack stack) {
        return XrViewConfigurationDepthRangeEXT.wrap(XrViewConfigurationDepthRangeEXT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrViewConfigurationDepthRangeEXT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrViewConfigurationDepthRangeEXT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static float nrecommendedNearZ(long struct) {
        return UNSAFE.getFloat(null, struct + (long)RECOMMENDEDNEARZ);
    }

    public static float nminNearZ(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MINNEARZ);
    }

    public static float nrecommendedFarZ(long struct) {
        return UNSAFE.getFloat(null, struct + (long)RECOMMENDEDFARZ);
    }

    public static float nmaxFarZ(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MAXFARZ);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nrecommendedNearZ(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)RECOMMENDEDNEARZ, value);
    }

    public static void nminNearZ(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)MINNEARZ, value);
    }

    public static void nrecommendedFarZ(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)RECOMMENDEDFARZ, value);
    }

    public static void nmaxFarZ(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)MAXFARZ, value);
    }

    static {
        Struct.Layout layout = XrViewConfigurationDepthRangeEXT.__struct(XrViewConfigurationDepthRangeEXT.__member(4), XrViewConfigurationDepthRangeEXT.__member(POINTER_SIZE), XrViewConfigurationDepthRangeEXT.__member(4), XrViewConfigurationDepthRangeEXT.__member(4), XrViewConfigurationDepthRangeEXT.__member(4), XrViewConfigurationDepthRangeEXT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        RECOMMENDEDNEARZ = layout.offsetof(2);
        MINNEARZ = layout.offsetof(3);
        RECOMMENDEDFARZ = layout.offsetof(4);
        MAXFARZ = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XrViewConfigurationDepthRangeEXT, Buffer>
    implements NativeResource {
        private static final XrViewConfigurationDepthRangeEXT ELEMENT_FACTORY = XrViewConfigurationDepthRangeEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrViewConfigurationDepthRangeEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrViewConfigurationDepthRangeEXT.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrViewConfigurationDepthRangeEXT.nnext(this.address());
        }

        public float recommendedNearZ() {
            return XrViewConfigurationDepthRangeEXT.nrecommendedNearZ(this.address());
        }

        public float minNearZ() {
            return XrViewConfigurationDepthRangeEXT.nminNearZ(this.address());
        }

        public float recommendedFarZ() {
            return XrViewConfigurationDepthRangeEXT.nrecommendedFarZ(this.address());
        }

        public float maxFarZ() {
            return XrViewConfigurationDepthRangeEXT.nmaxFarZ(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrViewConfigurationDepthRangeEXT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000046000);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrViewConfigurationDepthRangeEXT.nnext(this.address(), value);
            return this;
        }

        public Buffer recommendedNearZ(float value) {
            XrViewConfigurationDepthRangeEXT.nrecommendedNearZ(this.address(), value);
            return this;
        }

        public Buffer minNearZ(float value) {
            XrViewConfigurationDepthRangeEXT.nminNearZ(this.address(), value);
            return this;
        }

        public Buffer recommendedFarZ(float value) {
            XrViewConfigurationDepthRangeEXT.nrecommendedFarZ(this.address(), value);
            return this;
        }

        public Buffer maxFarZ(float value) {
            XrViewConfigurationDepthRangeEXT.nmaxFarZ(this.address(), value);
            return this;
        }
    }
}

