/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrFovf;
import org.lwjgl.openxr.XrPosef;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrView
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int POSE;
    public static final int FOV;

    public XrView(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrView.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrView.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrView.nnext(this.address());
    }

    public XrPosef pose() {
        return XrView.npose(this.address());
    }

    public XrFovf fov() {
        return XrView.nfov(this.address());
    }

    public XrView type(@NativeType(value="XrStructureType") int value) {
        XrView.ntype(this.address(), value);
        return this;
    }

    public XrView type$Default() {
        return this.type(7);
    }

    public XrView next(@NativeType(value="void *") long value) {
        XrView.nnext(this.address(), value);
        return this;
    }

    public XrView pose(XrPosef value) {
        XrView.npose(this.address(), value);
        return this;
    }

    public XrView pose(Consumer<XrPosef> consumer) {
        consumer.accept(this.pose());
        return this;
    }

    public XrView fov(XrFovf value) {
        XrView.nfov(this.address(), value);
        return this;
    }

    public XrView fov(Consumer<XrFovf> consumer) {
        consumer.accept(this.fov());
        return this;
    }

    public XrView set(int type, long next, XrPosef pose, XrFovf fov) {
        this.type(type);
        this.next(next);
        this.pose(pose);
        this.fov(fov);
        return this;
    }

    public XrView set(XrView src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrView malloc() {
        return XrView.wrap(XrView.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrView calloc() {
        return XrView.wrap(XrView.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrView create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrView.wrap(XrView.class, MemoryUtil.memAddress(container), container);
    }

    public static XrView create(long address) {
        return XrView.wrap(XrView.class, address);
    }

    @Nullable
    public static XrView createSafe(long address) {
        return address == 0L ? null : XrView.wrap(XrView.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrView.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrView.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrView.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrView.__create(capacity, SIZEOF);
        return XrView.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrView.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrView.wrap(Buffer.class, address, capacity);
    }

    public static XrView malloc(MemoryStack stack) {
        return XrView.wrap(XrView.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrView calloc(MemoryStack stack) {
        return XrView.wrap(XrView.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrView.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrView.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static XrPosef npose(long struct) {
        return XrPosef.create(struct + (long)POSE);
    }

    public static XrFovf nfov(long struct) {
        return XrFovf.create(struct + (long)FOV);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void npose(long struct, XrPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)POSE, XrPosef.SIZEOF);
    }

    public static void nfov(long struct, XrFovf value) {
        MemoryUtil.memCopy(value.address(), struct + (long)FOV, XrFovf.SIZEOF);
    }

    static {
        Struct.Layout layout = XrView.__struct(XrView.__member(4), XrView.__member(POINTER_SIZE), XrView.__member(XrPosef.SIZEOF, XrPosef.ALIGNOF), XrView.__member(XrFovf.SIZEOF, XrFovf.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        POSE = layout.offsetof(2);
        FOV = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrView, Buffer>
    implements NativeResource {
        private static final XrView ELEMENT_FACTORY = XrView.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrView getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrView.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrView.nnext(this.address());
        }

        public XrPosef pose() {
            return XrView.npose(this.address());
        }

        public XrFovf fov() {
            return XrView.nfov(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrView.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(7);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrView.nnext(this.address(), value);
            return this;
        }

        public Buffer pose(XrPosef value) {
            XrView.npose(this.address(), value);
            return this;
        }

        public Buffer pose(Consumer<XrPosef> consumer) {
            consumer.accept(this.pose());
            return this;
        }

        public Buffer fov(XrFovf value) {
            XrView.nfov(this.address(), value);
            return this;
        }

        public Buffer fov(Consumer<XrFovf> consumer) {
            consumer.accept(this.fov());
            return this;
        }
    }
}

