/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrUuidMSFT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BYTES;

    public XrUuidMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrUuidMSFT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint8_t[16]")
    public ByteBuffer bytes() {
        return XrUuidMSFT.nbytes(this.address());
    }

    @NativeType(value="uint8_t")
    public byte bytes(int index) {
        return XrUuidMSFT.nbytes(this.address(), index);
    }

    public XrUuidMSFT bytes(@NativeType(value="uint8_t[16]") ByteBuffer value) {
        XrUuidMSFT.nbytes(this.address(), value);
        return this;
    }

    public XrUuidMSFT bytes(int index, @NativeType(value="uint8_t") byte value) {
        XrUuidMSFT.nbytes(this.address(), index, value);
        return this;
    }

    public XrUuidMSFT set(XrUuidMSFT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrUuidMSFT malloc() {
        return XrUuidMSFT.wrap(XrUuidMSFT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrUuidMSFT calloc() {
        return XrUuidMSFT.wrap(XrUuidMSFT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrUuidMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrUuidMSFT.wrap(XrUuidMSFT.class, MemoryUtil.memAddress(container), container);
    }

    public static XrUuidMSFT create(long address) {
        return XrUuidMSFT.wrap(XrUuidMSFT.class, address);
    }

    @Nullable
    public static XrUuidMSFT createSafe(long address) {
        return address == 0L ? null : XrUuidMSFT.wrap(XrUuidMSFT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrUuidMSFT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrUuidMSFT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrUuidMSFT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrUuidMSFT.__create(capacity, SIZEOF);
        return XrUuidMSFT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrUuidMSFT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrUuidMSFT.wrap(Buffer.class, address, capacity);
    }

    public static XrUuidMSFT malloc(MemoryStack stack) {
        return XrUuidMSFT.wrap(XrUuidMSFT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrUuidMSFT calloc(MemoryStack stack) {
        return XrUuidMSFT.wrap(XrUuidMSFT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrUuidMSFT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrUuidMSFT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static ByteBuffer nbytes(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)BYTES, 16);
    }

    public static byte nbytes(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)BYTES + Checks.check(index, 16) * 1L);
    }

    public static void nbytes(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 16);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)BYTES, value.remaining() * 1);
    }

    public static void nbytes(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)BYTES + Checks.check(index, 16) * 1L, value);
    }

    static {
        Struct.Layout layout = XrUuidMSFT.__struct(XrUuidMSFT.__array(1, 16));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BYTES = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<XrUuidMSFT, Buffer>
    implements NativeResource {
        private static final XrUuidMSFT ELEMENT_FACTORY = XrUuidMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrUuidMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint8_t[16]")
        public ByteBuffer bytes() {
            return XrUuidMSFT.nbytes(this.address());
        }

        @NativeType(value="uint8_t")
        public byte bytes(int index) {
            return XrUuidMSFT.nbytes(this.address(), index);
        }

        public Buffer bytes(@NativeType(value="uint8_t[16]") ByteBuffer value) {
            XrUuidMSFT.nbytes(this.address(), value);
            return this;
        }

        public Buffer bytes(int index, @NativeType(value="uint8_t") byte value) {
            XrUuidMSFT.nbytes(this.address(), index, value);
            return this;
        }
    }
}

