/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrVector3f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrTriangleMeshCreateInfoFB
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int FLAGS;
    public static final int WINDINGORDER;
    public static final int VERTEXCOUNT;
    public static final int VERTEXBUFFER;
    public static final int TRIANGLECOUNT;
    public static final int INDEXBUFFER;

    public XrTriangleMeshCreateInfoFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrTriangleMeshCreateInfoFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrTriangleMeshCreateInfoFB.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrTriangleMeshCreateInfoFB.nnext(this.address());
    }

    @NativeType(value="XrTriangleMeshFlagsFB")
    public long flags() {
        return XrTriangleMeshCreateInfoFB.nflags(this.address());
    }

    @NativeType(value="XrWindingOrderFB")
    public int windingOrder() {
        return XrTriangleMeshCreateInfoFB.nwindingOrder(this.address());
    }

    @NativeType(value="uint32_t")
    public int vertexCount() {
        return XrTriangleMeshCreateInfoFB.nvertexCount(this.address());
    }

    @Nullable
    @NativeType(value="XrVector3f const *")
    public XrVector3f vertexBuffer() {
        return XrTriangleMeshCreateInfoFB.nvertexBuffer(this.address());
    }

    @NativeType(value="uint32_t")
    public int triangleCount() {
        return XrTriangleMeshCreateInfoFB.ntriangleCount(this.address());
    }

    @Nullable
    @NativeType(value="uint32_t const *")
    public IntBuffer indexBuffer(int capacity) {
        return XrTriangleMeshCreateInfoFB.nindexBuffer(this.address(), capacity);
    }

    public XrTriangleMeshCreateInfoFB type(@NativeType(value="XrStructureType") int value) {
        XrTriangleMeshCreateInfoFB.ntype(this.address(), value);
        return this;
    }

    public XrTriangleMeshCreateInfoFB type$Default() {
        return this.type(1000117001);
    }

    public XrTriangleMeshCreateInfoFB next(@NativeType(value="void const *") long value) {
        XrTriangleMeshCreateInfoFB.nnext(this.address(), value);
        return this;
    }

    public XrTriangleMeshCreateInfoFB flags(@NativeType(value="XrTriangleMeshFlagsFB") long value) {
        XrTriangleMeshCreateInfoFB.nflags(this.address(), value);
        return this;
    }

    public XrTriangleMeshCreateInfoFB windingOrder(@NativeType(value="XrWindingOrderFB") int value) {
        XrTriangleMeshCreateInfoFB.nwindingOrder(this.address(), value);
        return this;
    }

    public XrTriangleMeshCreateInfoFB vertexCount(@NativeType(value="uint32_t") int value) {
        XrTriangleMeshCreateInfoFB.nvertexCount(this.address(), value);
        return this;
    }

    public XrTriangleMeshCreateInfoFB vertexBuffer(@Nullable @NativeType(value="XrVector3f const *") XrVector3f value) {
        XrTriangleMeshCreateInfoFB.nvertexBuffer(this.address(), value);
        return this;
    }

    public XrTriangleMeshCreateInfoFB triangleCount(@NativeType(value="uint32_t") int value) {
        XrTriangleMeshCreateInfoFB.ntriangleCount(this.address(), value);
        return this;
    }

    public XrTriangleMeshCreateInfoFB indexBuffer(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
        XrTriangleMeshCreateInfoFB.nindexBuffer(this.address(), value);
        return this;
    }

    public XrTriangleMeshCreateInfoFB set(int type, long next, long flags, int windingOrder, int vertexCount, @Nullable XrVector3f vertexBuffer, int triangleCount, @Nullable IntBuffer indexBuffer) {
        this.type(type);
        this.next(next);
        this.flags(flags);
        this.windingOrder(windingOrder);
        this.vertexCount(vertexCount);
        this.vertexBuffer(vertexBuffer);
        this.triangleCount(triangleCount);
        this.indexBuffer(indexBuffer);
        return this;
    }

    public XrTriangleMeshCreateInfoFB set(XrTriangleMeshCreateInfoFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrTriangleMeshCreateInfoFB malloc() {
        return XrTriangleMeshCreateInfoFB.wrap(XrTriangleMeshCreateInfoFB.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrTriangleMeshCreateInfoFB calloc() {
        return XrTriangleMeshCreateInfoFB.wrap(XrTriangleMeshCreateInfoFB.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrTriangleMeshCreateInfoFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrTriangleMeshCreateInfoFB.wrap(XrTriangleMeshCreateInfoFB.class, MemoryUtil.memAddress(container), container);
    }

    public static XrTriangleMeshCreateInfoFB create(long address) {
        return XrTriangleMeshCreateInfoFB.wrap(XrTriangleMeshCreateInfoFB.class, address);
    }

    @Nullable
    public static XrTriangleMeshCreateInfoFB createSafe(long address) {
        return address == 0L ? null : XrTriangleMeshCreateInfoFB.wrap(XrTriangleMeshCreateInfoFB.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrTriangleMeshCreateInfoFB.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrTriangleMeshCreateInfoFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrTriangleMeshCreateInfoFB.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrTriangleMeshCreateInfoFB.__create(capacity, SIZEOF);
        return XrTriangleMeshCreateInfoFB.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrTriangleMeshCreateInfoFB.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrTriangleMeshCreateInfoFB.wrap(Buffer.class, address, capacity);
    }

    public static XrTriangleMeshCreateInfoFB malloc(MemoryStack stack) {
        return XrTriangleMeshCreateInfoFB.wrap(XrTriangleMeshCreateInfoFB.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrTriangleMeshCreateInfoFB calloc(MemoryStack stack) {
        return XrTriangleMeshCreateInfoFB.wrap(XrTriangleMeshCreateInfoFB.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrTriangleMeshCreateInfoFB.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrTriangleMeshCreateInfoFB.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long nflags(long struct) {
        return UNSAFE.getLong(null, struct + (long)FLAGS);
    }

    public static int nwindingOrder(long struct) {
        return UNSAFE.getInt(null, struct + (long)WINDINGORDER);
    }

    public static int nvertexCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)VERTEXCOUNT);
    }

    @Nullable
    public static XrVector3f nvertexBuffer(long struct) {
        return XrVector3f.createSafe(MemoryUtil.memGetAddress(struct + (long)VERTEXBUFFER));
    }

    public static int ntriangleCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)TRIANGLECOUNT);
    }

    @Nullable
    public static IntBuffer nindexBuffer(long struct, int capacity) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)INDEXBUFFER), capacity);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nflags(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)FLAGS, value);
    }

    public static void nwindingOrder(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)WINDINGORDER, value);
    }

    public static void nvertexCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VERTEXCOUNT, value);
    }

    public static void nvertexBuffer(long struct, @Nullable XrVector3f value) {
        MemoryUtil.memPutAddress(struct + (long)VERTEXBUFFER, MemoryUtil.memAddressSafe(value));
    }

    public static void ntriangleCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TRIANGLECOUNT, value);
    }

    public static void nindexBuffer(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)INDEXBUFFER, MemoryUtil.memAddressSafe(value));
    }

    static {
        Struct.Layout layout = XrTriangleMeshCreateInfoFB.__struct(XrTriangleMeshCreateInfoFB.__member(4), XrTriangleMeshCreateInfoFB.__member(POINTER_SIZE), XrTriangleMeshCreateInfoFB.__member(8), XrTriangleMeshCreateInfoFB.__member(4), XrTriangleMeshCreateInfoFB.__member(4), XrTriangleMeshCreateInfoFB.__member(POINTER_SIZE), XrTriangleMeshCreateInfoFB.__member(4), XrTriangleMeshCreateInfoFB.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        WINDINGORDER = layout.offsetof(3);
        VERTEXCOUNT = layout.offsetof(4);
        VERTEXBUFFER = layout.offsetof(5);
        TRIANGLECOUNT = layout.offsetof(6);
        INDEXBUFFER = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<XrTriangleMeshCreateInfoFB, Buffer>
    implements NativeResource {
        private static final XrTriangleMeshCreateInfoFB ELEMENT_FACTORY = XrTriangleMeshCreateInfoFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrTriangleMeshCreateInfoFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrTriangleMeshCreateInfoFB.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrTriangleMeshCreateInfoFB.nnext(this.address());
        }

        @NativeType(value="XrTriangleMeshFlagsFB")
        public long flags() {
            return XrTriangleMeshCreateInfoFB.nflags(this.address());
        }

        @NativeType(value="XrWindingOrderFB")
        public int windingOrder() {
            return XrTriangleMeshCreateInfoFB.nwindingOrder(this.address());
        }

        @NativeType(value="uint32_t")
        public int vertexCount() {
            return XrTriangleMeshCreateInfoFB.nvertexCount(this.address());
        }

        @Nullable
        @NativeType(value="XrVector3f const *")
        public XrVector3f vertexBuffer() {
            return XrTriangleMeshCreateInfoFB.nvertexBuffer(this.address());
        }

        @NativeType(value="uint32_t")
        public int triangleCount() {
            return XrTriangleMeshCreateInfoFB.ntriangleCount(this.address());
        }

        @Nullable
        @NativeType(value="uint32_t const *")
        public IntBuffer indexBuffer(int capacity) {
            return XrTriangleMeshCreateInfoFB.nindexBuffer(this.address(), capacity);
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrTriangleMeshCreateInfoFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000117001);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrTriangleMeshCreateInfoFB.nnext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="XrTriangleMeshFlagsFB") long value) {
            XrTriangleMeshCreateInfoFB.nflags(this.address(), value);
            return this;
        }

        public Buffer windingOrder(@NativeType(value="XrWindingOrderFB") int value) {
            XrTriangleMeshCreateInfoFB.nwindingOrder(this.address(), value);
            return this;
        }

        public Buffer vertexCount(@NativeType(value="uint32_t") int value) {
            XrTriangleMeshCreateInfoFB.nvertexCount(this.address(), value);
            return this;
        }

        public Buffer vertexBuffer(@Nullable @NativeType(value="XrVector3f const *") XrVector3f value) {
            XrTriangleMeshCreateInfoFB.nvertexBuffer(this.address(), value);
            return this;
        }

        public Buffer triangleCount(@NativeType(value="uint32_t") int value) {
            XrTriangleMeshCreateInfoFB.ntriangleCount(this.address(), value);
            return this;
        }

        public Buffer indexBuffer(@Nullable @NativeType(value="uint32_t const *") IntBuffer value) {
            XrTriangleMeshCreateInfoFB.nindexBuffer(this.address(), value);
            return this;
        }
    }
}

