/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSystemMarkerTrackingPropertiesVARJO
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SUPPORTSMARKERTRACKING;

    public XrSystemMarkerTrackingPropertiesVARJO(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSystemMarkerTrackingPropertiesVARJO.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSystemMarkerTrackingPropertiesVARJO.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrSystemMarkerTrackingPropertiesVARJO.nnext(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean supportsMarkerTracking() {
        return XrSystemMarkerTrackingPropertiesVARJO.nsupportsMarkerTracking(this.address()) != 0;
    }

    public XrSystemMarkerTrackingPropertiesVARJO type(@NativeType(value="XrStructureType") int value) {
        XrSystemMarkerTrackingPropertiesVARJO.ntype(this.address(), value);
        return this;
    }

    public XrSystemMarkerTrackingPropertiesVARJO type$Default() {
        return this.type(1000124000);
    }

    public XrSystemMarkerTrackingPropertiesVARJO next(@NativeType(value="void *") long value) {
        XrSystemMarkerTrackingPropertiesVARJO.nnext(this.address(), value);
        return this;
    }

    public XrSystemMarkerTrackingPropertiesVARJO supportsMarkerTracking(@NativeType(value="XrBool32") boolean value) {
        XrSystemMarkerTrackingPropertiesVARJO.nsupportsMarkerTracking(this.address(), value ? 1 : 0);
        return this;
    }

    public XrSystemMarkerTrackingPropertiesVARJO set(int type, long next, boolean supportsMarkerTracking) {
        this.type(type);
        this.next(next);
        this.supportsMarkerTracking(supportsMarkerTracking);
        return this;
    }

    public XrSystemMarkerTrackingPropertiesVARJO set(XrSystemMarkerTrackingPropertiesVARJO src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSystemMarkerTrackingPropertiesVARJO malloc() {
        return XrSystemMarkerTrackingPropertiesVARJO.wrap(XrSystemMarkerTrackingPropertiesVARJO.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrSystemMarkerTrackingPropertiesVARJO calloc() {
        return XrSystemMarkerTrackingPropertiesVARJO.wrap(XrSystemMarkerTrackingPropertiesVARJO.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrSystemMarkerTrackingPropertiesVARJO create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrSystemMarkerTrackingPropertiesVARJO.wrap(XrSystemMarkerTrackingPropertiesVARJO.class, MemoryUtil.memAddress(container), container);
    }

    public static XrSystemMarkerTrackingPropertiesVARJO create(long address) {
        return XrSystemMarkerTrackingPropertiesVARJO.wrap(XrSystemMarkerTrackingPropertiesVARJO.class, address);
    }

    @Nullable
    public static XrSystemMarkerTrackingPropertiesVARJO createSafe(long address) {
        return address == 0L ? null : XrSystemMarkerTrackingPropertiesVARJO.wrap(XrSystemMarkerTrackingPropertiesVARJO.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrSystemMarkerTrackingPropertiesVARJO.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrSystemMarkerTrackingPropertiesVARJO.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrSystemMarkerTrackingPropertiesVARJO.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSystemMarkerTrackingPropertiesVARJO.__create(capacity, SIZEOF);
        return XrSystemMarkerTrackingPropertiesVARJO.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrSystemMarkerTrackingPropertiesVARJO.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrSystemMarkerTrackingPropertiesVARJO.wrap(Buffer.class, address, capacity);
    }

    public static XrSystemMarkerTrackingPropertiesVARJO malloc(MemoryStack stack) {
        return XrSystemMarkerTrackingPropertiesVARJO.wrap(XrSystemMarkerTrackingPropertiesVARJO.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSystemMarkerTrackingPropertiesVARJO calloc(MemoryStack stack) {
        return XrSystemMarkerTrackingPropertiesVARJO.wrap(XrSystemMarkerTrackingPropertiesVARJO.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrSystemMarkerTrackingPropertiesVARJO.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrSystemMarkerTrackingPropertiesVARJO.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nsupportsMarkerTracking(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUPPORTSMARKERTRACKING);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nsupportsMarkerTracking(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SUPPORTSMARKERTRACKING, value);
    }

    static {
        Struct.Layout layout = XrSystemMarkerTrackingPropertiesVARJO.__struct(XrSystemMarkerTrackingPropertiesVARJO.__member(4), XrSystemMarkerTrackingPropertiesVARJO.__member(POINTER_SIZE), XrSystemMarkerTrackingPropertiesVARJO.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SUPPORTSMARKERTRACKING = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrSystemMarkerTrackingPropertiesVARJO, Buffer>
    implements NativeResource {
        private static final XrSystemMarkerTrackingPropertiesVARJO ELEMENT_FACTORY = XrSystemMarkerTrackingPropertiesVARJO.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrSystemMarkerTrackingPropertiesVARJO getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSystemMarkerTrackingPropertiesVARJO.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrSystemMarkerTrackingPropertiesVARJO.nnext(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean supportsMarkerTracking() {
            return XrSystemMarkerTrackingPropertiesVARJO.nsupportsMarkerTracking(this.address()) != 0;
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSystemMarkerTrackingPropertiesVARJO.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000124000);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrSystemMarkerTrackingPropertiesVARJO.nnext(this.address(), value);
            return this;
        }

        public Buffer supportsMarkerTracking(@NativeType(value="XrBool32") boolean value) {
            XrSystemMarkerTrackingPropertiesVARJO.nsupportsMarkerTracking(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

