/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSystemHandTrackingPropertiesEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int SUPPORTSHANDTRACKING;

    public XrSystemHandTrackingPropertiesEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSystemHandTrackingPropertiesEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSystemHandTrackingPropertiesEXT.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrSystemHandTrackingPropertiesEXT.nnext(this.address());
    }

    @NativeType(value="XrBool32")
    public boolean supportsHandTracking() {
        return XrSystemHandTrackingPropertiesEXT.nsupportsHandTracking(this.address()) != 0;
    }

    public XrSystemHandTrackingPropertiesEXT type(@NativeType(value="XrStructureType") int value) {
        XrSystemHandTrackingPropertiesEXT.ntype(this.address(), value);
        return this;
    }

    public XrSystemHandTrackingPropertiesEXT type$Default() {
        return this.type(1000051000);
    }

    public XrSystemHandTrackingPropertiesEXT next(@NativeType(value="void *") long value) {
        XrSystemHandTrackingPropertiesEXT.nnext(this.address(), value);
        return this;
    }

    public XrSystemHandTrackingPropertiesEXT supportsHandTracking(@NativeType(value="XrBool32") boolean value) {
        XrSystemHandTrackingPropertiesEXT.nsupportsHandTracking(this.address(), value ? 1 : 0);
        return this;
    }

    public XrSystemHandTrackingPropertiesEXT set(int type, long next, boolean supportsHandTracking) {
        this.type(type);
        this.next(next);
        this.supportsHandTracking(supportsHandTracking);
        return this;
    }

    public XrSystemHandTrackingPropertiesEXT set(XrSystemHandTrackingPropertiesEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSystemHandTrackingPropertiesEXT malloc() {
        return XrSystemHandTrackingPropertiesEXT.wrap(XrSystemHandTrackingPropertiesEXT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrSystemHandTrackingPropertiesEXT calloc() {
        return XrSystemHandTrackingPropertiesEXT.wrap(XrSystemHandTrackingPropertiesEXT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrSystemHandTrackingPropertiesEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrSystemHandTrackingPropertiesEXT.wrap(XrSystemHandTrackingPropertiesEXT.class, MemoryUtil.memAddress(container), container);
    }

    public static XrSystemHandTrackingPropertiesEXT create(long address) {
        return XrSystemHandTrackingPropertiesEXT.wrap(XrSystemHandTrackingPropertiesEXT.class, address);
    }

    @Nullable
    public static XrSystemHandTrackingPropertiesEXT createSafe(long address) {
        return address == 0L ? null : XrSystemHandTrackingPropertiesEXT.wrap(XrSystemHandTrackingPropertiesEXT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrSystemHandTrackingPropertiesEXT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrSystemHandTrackingPropertiesEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrSystemHandTrackingPropertiesEXT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSystemHandTrackingPropertiesEXT.__create(capacity, SIZEOF);
        return XrSystemHandTrackingPropertiesEXT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrSystemHandTrackingPropertiesEXT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrSystemHandTrackingPropertiesEXT.wrap(Buffer.class, address, capacity);
    }

    public static XrSystemHandTrackingPropertiesEXT malloc(MemoryStack stack) {
        return XrSystemHandTrackingPropertiesEXT.wrap(XrSystemHandTrackingPropertiesEXT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSystemHandTrackingPropertiesEXT calloc(MemoryStack stack) {
        return XrSystemHandTrackingPropertiesEXT.wrap(XrSystemHandTrackingPropertiesEXT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrSystemHandTrackingPropertiesEXT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrSystemHandTrackingPropertiesEXT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nsupportsHandTracking(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUPPORTSHANDTRACKING);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nsupportsHandTracking(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SUPPORTSHANDTRACKING, value);
    }

    static {
        Struct.Layout layout = XrSystemHandTrackingPropertiesEXT.__struct(XrSystemHandTrackingPropertiesEXT.__member(4), XrSystemHandTrackingPropertiesEXT.__member(POINTER_SIZE), XrSystemHandTrackingPropertiesEXT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        SUPPORTSHANDTRACKING = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrSystemHandTrackingPropertiesEXT, Buffer>
    implements NativeResource {
        private static final XrSystemHandTrackingPropertiesEXT ELEMENT_FACTORY = XrSystemHandTrackingPropertiesEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrSystemHandTrackingPropertiesEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSystemHandTrackingPropertiesEXT.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrSystemHandTrackingPropertiesEXT.nnext(this.address());
        }

        @NativeType(value="XrBool32")
        public boolean supportsHandTracking() {
            return XrSystemHandTrackingPropertiesEXT.nsupportsHandTracking(this.address()) != 0;
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSystemHandTrackingPropertiesEXT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000051000);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrSystemHandTrackingPropertiesEXT.nnext(this.address(), value);
            return this;
        }

        public Buffer supportsHandTracking(@NativeType(value="XrBool32") boolean value) {
            XrSystemHandTrackingPropertiesEXT.nsupportsHandTracking(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

