/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSystemGetInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int FORMFACTOR;

    public XrSystemGetInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSystemGetInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSystemGetInfo.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSystemGetInfo.nnext(this.address());
    }

    @NativeType(value="XrFormFactor")
    public int formFactor() {
        return XrSystemGetInfo.nformFactor(this.address());
    }

    public XrSystemGetInfo type(@NativeType(value="XrStructureType") int value) {
        XrSystemGetInfo.ntype(this.address(), value);
        return this;
    }

    public XrSystemGetInfo type$Default() {
        return this.type(4);
    }

    public XrSystemGetInfo next(@NativeType(value="void const *") long value) {
        XrSystemGetInfo.nnext(this.address(), value);
        return this;
    }

    public XrSystemGetInfo formFactor(@NativeType(value="XrFormFactor") int value) {
        XrSystemGetInfo.nformFactor(this.address(), value);
        return this;
    }

    public XrSystemGetInfo set(int type, long next, int formFactor) {
        this.type(type);
        this.next(next);
        this.formFactor(formFactor);
        return this;
    }

    public XrSystemGetInfo set(XrSystemGetInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSystemGetInfo malloc() {
        return XrSystemGetInfo.wrap(XrSystemGetInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrSystemGetInfo calloc() {
        return XrSystemGetInfo.wrap(XrSystemGetInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrSystemGetInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrSystemGetInfo.wrap(XrSystemGetInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static XrSystemGetInfo create(long address) {
        return XrSystemGetInfo.wrap(XrSystemGetInfo.class, address);
    }

    @Nullable
    public static XrSystemGetInfo createSafe(long address) {
        return address == 0L ? null : XrSystemGetInfo.wrap(XrSystemGetInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrSystemGetInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrSystemGetInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrSystemGetInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSystemGetInfo.__create(capacity, SIZEOF);
        return XrSystemGetInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrSystemGetInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrSystemGetInfo.wrap(Buffer.class, address, capacity);
    }

    public static XrSystemGetInfo malloc(MemoryStack stack) {
        return XrSystemGetInfo.wrap(XrSystemGetInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSystemGetInfo calloc(MemoryStack stack) {
        return XrSystemGetInfo.wrap(XrSystemGetInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrSystemGetInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrSystemGetInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nformFactor(long struct) {
        return UNSAFE.getInt(null, struct + (long)FORMFACTOR);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nformFactor(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FORMFACTOR, value);
    }

    static {
        Struct.Layout layout = XrSystemGetInfo.__struct(XrSystemGetInfo.__member(4), XrSystemGetInfo.__member(POINTER_SIZE), XrSystemGetInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        FORMFACTOR = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrSystemGetInfo, Buffer>
    implements NativeResource {
        private static final XrSystemGetInfo ELEMENT_FACTORY = XrSystemGetInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrSystemGetInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSystemGetInfo.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSystemGetInfo.nnext(this.address());
        }

        @NativeType(value="XrFormFactor")
        public int formFactor() {
            return XrSystemGetInfo.nformFactor(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSystemGetInfo.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(4);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSystemGetInfo.nnext(this.address(), value);
            return this;
        }

        public Buffer formFactor(@NativeType(value="XrFormFactor") int value) {
            XrSystemGetInfo.nformFactor(this.address(), value);
            return this;
        }
    }
}

