/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrGraphicsBindingEGLMNDX;
import org.lwjgl.openxr.XrGraphicsBindingOpenGLWaylandKHR;
import org.lwjgl.openxr.XrGraphicsBindingOpenGLWin32KHR;
import org.lwjgl.openxr.XrGraphicsBindingOpenGLXcbKHR;
import org.lwjgl.openxr.XrGraphicsBindingOpenGLXlibKHR;
import org.lwjgl.openxr.XrGraphicsBindingVulkan2KHR;
import org.lwjgl.openxr.XrGraphicsBindingVulkanKHR;
import org.lwjgl.openxr.XrHolographicWindowAttachmentMSFT;
import org.lwjgl.openxr.XrSessionCreateInfoOverlayEXTX;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSessionCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int CREATEFLAGS;
    public static final int SYSTEMID;

    public XrSessionCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSessionCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSessionCreateInfo.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSessionCreateInfo.nnext(this.address());
    }

    @NativeType(value="XrSessionCreateFlags")
    public long createFlags() {
        return XrSessionCreateInfo.ncreateFlags(this.address());
    }

    @NativeType(value="XrSystemId")
    public long systemId() {
        return XrSessionCreateInfo.nsystemId(this.address());
    }

    public XrSessionCreateInfo type(@NativeType(value="XrStructureType") int value) {
        XrSessionCreateInfo.ntype(this.address(), value);
        return this;
    }

    public XrSessionCreateInfo type$Default() {
        return this.type(8);
    }

    public XrSessionCreateInfo next(@NativeType(value="void const *") long value) {
        XrSessionCreateInfo.nnext(this.address(), value);
        return this;
    }

    public XrSessionCreateInfo next(XrGraphicsBindingEGLMNDX value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSessionCreateInfo next(XrGraphicsBindingOpenGLWaylandKHR value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSessionCreateInfo next(XrGraphicsBindingOpenGLWin32KHR value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSessionCreateInfo next(XrGraphicsBindingOpenGLXcbKHR value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSessionCreateInfo next(XrGraphicsBindingOpenGLXlibKHR value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSessionCreateInfo next(XrGraphicsBindingVulkan2KHR value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSessionCreateInfo next(XrGraphicsBindingVulkanKHR value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSessionCreateInfo next(XrHolographicWindowAttachmentMSFT value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSessionCreateInfo next(XrSessionCreateInfoOverlayEXTX value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSessionCreateInfo createFlags(@NativeType(value="XrSessionCreateFlags") long value) {
        XrSessionCreateInfo.ncreateFlags(this.address(), value);
        return this;
    }

    public XrSessionCreateInfo systemId(@NativeType(value="XrSystemId") long value) {
        XrSessionCreateInfo.nsystemId(this.address(), value);
        return this;
    }

    public XrSessionCreateInfo set(int type, long next, long createFlags, long systemId) {
        this.type(type);
        this.next(next);
        this.createFlags(createFlags);
        this.systemId(systemId);
        return this;
    }

    public XrSessionCreateInfo set(XrSessionCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSessionCreateInfo malloc() {
        return XrSessionCreateInfo.wrap(XrSessionCreateInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrSessionCreateInfo calloc() {
        return XrSessionCreateInfo.wrap(XrSessionCreateInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrSessionCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrSessionCreateInfo.wrap(XrSessionCreateInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static XrSessionCreateInfo create(long address) {
        return XrSessionCreateInfo.wrap(XrSessionCreateInfo.class, address);
    }

    @Nullable
    public static XrSessionCreateInfo createSafe(long address) {
        return address == 0L ? null : XrSessionCreateInfo.wrap(XrSessionCreateInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrSessionCreateInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrSessionCreateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrSessionCreateInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSessionCreateInfo.__create(capacity, SIZEOF);
        return XrSessionCreateInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrSessionCreateInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrSessionCreateInfo.wrap(Buffer.class, address, capacity);
    }

    public static XrSessionCreateInfo malloc(MemoryStack stack) {
        return XrSessionCreateInfo.wrap(XrSessionCreateInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSessionCreateInfo calloc(MemoryStack stack) {
        return XrSessionCreateInfo.wrap(XrSessionCreateInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrSessionCreateInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrSessionCreateInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long ncreateFlags(long struct) {
        return UNSAFE.getLong(null, struct + (long)CREATEFLAGS);
    }

    public static long nsystemId(long struct) {
        return UNSAFE.getLong(null, struct + (long)SYSTEMID);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void ncreateFlags(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)CREATEFLAGS, value);
    }

    public static void nsystemId(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SYSTEMID, value);
    }

    static {
        Struct.Layout layout = XrSessionCreateInfo.__struct(XrSessionCreateInfo.__member(4), XrSessionCreateInfo.__member(POINTER_SIZE), XrSessionCreateInfo.__member(8), XrSessionCreateInfo.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        CREATEFLAGS = layout.offsetof(2);
        SYSTEMID = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrSessionCreateInfo, Buffer>
    implements NativeResource {
        private static final XrSessionCreateInfo ELEMENT_FACTORY = XrSessionCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrSessionCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSessionCreateInfo.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSessionCreateInfo.nnext(this.address());
        }

        @NativeType(value="XrSessionCreateFlags")
        public long createFlags() {
            return XrSessionCreateInfo.ncreateFlags(this.address());
        }

        @NativeType(value="XrSystemId")
        public long systemId() {
            return XrSessionCreateInfo.nsystemId(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSessionCreateInfo.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(8);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSessionCreateInfo.nnext(this.address(), value);
            return this;
        }

        public Buffer next(XrGraphicsBindingEGLMNDX value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrGraphicsBindingOpenGLWaylandKHR value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrGraphicsBindingOpenGLWin32KHR value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrGraphicsBindingOpenGLXcbKHR value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrGraphicsBindingOpenGLXlibKHR value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrGraphicsBindingVulkan2KHR value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrGraphicsBindingVulkanKHR value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrHolographicWindowAttachmentMSFT value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrSessionCreateInfoOverlayEXTX value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer createFlags(@NativeType(value="XrSessionCreateFlags") long value) {
            XrSessionCreateInfo.ncreateFlags(this.address(), value);
            return this;
        }

        public Buffer systemId(@NativeType(value="XrSystemId") long value) {
            XrSessionCreateInfo.nsystemId(this.address(), value);
            return this;
        }
    }
}

