/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSecondaryViewConfigurationSessionBeginInfoMSFT;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSessionBeginInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int PRIMARYVIEWCONFIGURATIONTYPE;

    public XrSessionBeginInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSessionBeginInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSessionBeginInfo.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrSessionBeginInfo.nnext(this.address());
    }

    @NativeType(value="XrViewConfigurationType")
    public int primaryViewConfigurationType() {
        return XrSessionBeginInfo.nprimaryViewConfigurationType(this.address());
    }

    public XrSessionBeginInfo type(@NativeType(value="XrStructureType") int value) {
        XrSessionBeginInfo.ntype(this.address(), value);
        return this;
    }

    public XrSessionBeginInfo type$Default() {
        return this.type(10);
    }

    public XrSessionBeginInfo next(@NativeType(value="void const *") long value) {
        XrSessionBeginInfo.nnext(this.address(), value);
        return this;
    }

    public XrSessionBeginInfo next(XrSecondaryViewConfigurationSessionBeginInfoMSFT value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSessionBeginInfo primaryViewConfigurationType(@NativeType(value="XrViewConfigurationType") int value) {
        XrSessionBeginInfo.nprimaryViewConfigurationType(this.address(), value);
        return this;
    }

    public XrSessionBeginInfo set(int type, long next, int primaryViewConfigurationType) {
        this.type(type);
        this.next(next);
        this.primaryViewConfigurationType(primaryViewConfigurationType);
        return this;
    }

    public XrSessionBeginInfo set(XrSessionBeginInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSessionBeginInfo malloc() {
        return XrSessionBeginInfo.wrap(XrSessionBeginInfo.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrSessionBeginInfo calloc() {
        return XrSessionBeginInfo.wrap(XrSessionBeginInfo.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrSessionBeginInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrSessionBeginInfo.wrap(XrSessionBeginInfo.class, MemoryUtil.memAddress(container), container);
    }

    public static XrSessionBeginInfo create(long address) {
        return XrSessionBeginInfo.wrap(XrSessionBeginInfo.class, address);
    }

    @Nullable
    public static XrSessionBeginInfo createSafe(long address) {
        return address == 0L ? null : XrSessionBeginInfo.wrap(XrSessionBeginInfo.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrSessionBeginInfo.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrSessionBeginInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrSessionBeginInfo.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSessionBeginInfo.__create(capacity, SIZEOF);
        return XrSessionBeginInfo.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrSessionBeginInfo.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrSessionBeginInfo.wrap(Buffer.class, address, capacity);
    }

    public static XrSessionBeginInfo malloc(MemoryStack stack) {
        return XrSessionBeginInfo.wrap(XrSessionBeginInfo.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSessionBeginInfo calloc(MemoryStack stack) {
        return XrSessionBeginInfo.wrap(XrSessionBeginInfo.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrSessionBeginInfo.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrSessionBeginInfo.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nprimaryViewConfigurationType(long struct) {
        return UNSAFE.getInt(null, struct + (long)PRIMARYVIEWCONFIGURATIONTYPE);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nprimaryViewConfigurationType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PRIMARYVIEWCONFIGURATIONTYPE, value);
    }

    static {
        Struct.Layout layout = XrSessionBeginInfo.__struct(XrSessionBeginInfo.__member(4), XrSessionBeginInfo.__member(POINTER_SIZE), XrSessionBeginInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        PRIMARYVIEWCONFIGURATIONTYPE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrSessionBeginInfo, Buffer>
    implements NativeResource {
        private static final XrSessionBeginInfo ELEMENT_FACTORY = XrSessionBeginInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrSessionBeginInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSessionBeginInfo.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrSessionBeginInfo.nnext(this.address());
        }

        @NativeType(value="XrViewConfigurationType")
        public int primaryViewConfigurationType() {
            return XrSessionBeginInfo.nprimaryViewConfigurationType(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSessionBeginInfo.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(10);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrSessionBeginInfo.nnext(this.address(), value);
            return this;
        }

        public Buffer next(XrSecondaryViewConfigurationSessionBeginInfoMSFT value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer primaryViewConfigurationType(@NativeType(value="XrViewConfigurationType") int value) {
            XrSessionBeginInfo.nprimaryViewConfigurationType(this.address(), value);
            return this;
        }
    }
}

