/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrVector3f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneMeshVertexBufferMSFT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int VERTEXCAPACITYINPUT;
    public static final int VERTEXCOUNTOUTPUT;
    public static final int VERTICES;

    public XrSceneMeshVertexBufferMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSceneMeshVertexBufferMSFT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSceneMeshVertexBufferMSFT.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrSceneMeshVertexBufferMSFT.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int vertexCapacityInput() {
        return XrSceneMeshVertexBufferMSFT.nvertexCapacityInput(this.address());
    }

    @NativeType(value="uint32_t")
    public int vertexCountOutput() {
        return XrSceneMeshVertexBufferMSFT.nvertexCountOutput(this.address());
    }

    @Nullable
    @NativeType(value="XrVector3f *")
    public XrVector3f.Buffer vertices() {
        return XrSceneMeshVertexBufferMSFT.nvertices(this.address());
    }

    public XrSceneMeshVertexBufferMSFT type(@NativeType(value="XrStructureType") int value) {
        XrSceneMeshVertexBufferMSFT.ntype(this.address(), value);
        return this;
    }

    public XrSceneMeshVertexBufferMSFT type$Default() {
        return this.type(1000097016);
    }

    public XrSceneMeshVertexBufferMSFT next(@NativeType(value="void *") long value) {
        XrSceneMeshVertexBufferMSFT.nnext(this.address(), value);
        return this;
    }

    public XrSceneMeshVertexBufferMSFT vertexCapacityInput(@NativeType(value="uint32_t") int value) {
        XrSceneMeshVertexBufferMSFT.nvertexCapacityInput(this.address(), value);
        return this;
    }

    public XrSceneMeshVertexBufferMSFT vertexCountOutput(@NativeType(value="uint32_t") int value) {
        XrSceneMeshVertexBufferMSFT.nvertexCountOutput(this.address(), value);
        return this;
    }

    public XrSceneMeshVertexBufferMSFT vertices(@Nullable @NativeType(value="XrVector3f *") XrVector3f.Buffer value) {
        XrSceneMeshVertexBufferMSFT.nvertices(this.address(), value);
        return this;
    }

    public XrSceneMeshVertexBufferMSFT set(int type, long next, int vertexCapacityInput, int vertexCountOutput, @Nullable XrVector3f.Buffer vertices) {
        this.type(type);
        this.next(next);
        this.vertexCapacityInput(vertexCapacityInput);
        this.vertexCountOutput(vertexCountOutput);
        this.vertices(vertices);
        return this;
    }

    public XrSceneMeshVertexBufferMSFT set(XrSceneMeshVertexBufferMSFT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSceneMeshVertexBufferMSFT malloc() {
        return XrSceneMeshVertexBufferMSFT.wrap(XrSceneMeshVertexBufferMSFT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrSceneMeshVertexBufferMSFT calloc() {
        return XrSceneMeshVertexBufferMSFT.wrap(XrSceneMeshVertexBufferMSFT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrSceneMeshVertexBufferMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrSceneMeshVertexBufferMSFT.wrap(XrSceneMeshVertexBufferMSFT.class, MemoryUtil.memAddress(container), container);
    }

    public static XrSceneMeshVertexBufferMSFT create(long address) {
        return XrSceneMeshVertexBufferMSFT.wrap(XrSceneMeshVertexBufferMSFT.class, address);
    }

    @Nullable
    public static XrSceneMeshVertexBufferMSFT createSafe(long address) {
        return address == 0L ? null : XrSceneMeshVertexBufferMSFT.wrap(XrSceneMeshVertexBufferMSFT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrSceneMeshVertexBufferMSFT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrSceneMeshVertexBufferMSFT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrSceneMeshVertexBufferMSFT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSceneMeshVertexBufferMSFT.__create(capacity, SIZEOF);
        return XrSceneMeshVertexBufferMSFT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrSceneMeshVertexBufferMSFT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrSceneMeshVertexBufferMSFT.wrap(Buffer.class, address, capacity);
    }

    public static XrSceneMeshVertexBufferMSFT malloc(MemoryStack stack) {
        return XrSceneMeshVertexBufferMSFT.wrap(XrSceneMeshVertexBufferMSFT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSceneMeshVertexBufferMSFT calloc(MemoryStack stack) {
        return XrSceneMeshVertexBufferMSFT.wrap(XrSceneMeshVertexBufferMSFT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrSceneMeshVertexBufferMSFT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrSceneMeshVertexBufferMSFT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nvertexCapacityInput(long struct) {
        return UNSAFE.getInt(null, struct + (long)VERTEXCAPACITYINPUT);
    }

    public static int nvertexCountOutput(long struct) {
        return UNSAFE.getInt(null, struct + (long)VERTEXCOUNTOUTPUT);
    }

    @Nullable
    public static XrVector3f.Buffer nvertices(long struct) {
        return XrVector3f.createSafe(MemoryUtil.memGetAddress(struct + (long)VERTICES), XrSceneMeshVertexBufferMSFT.nvertexCapacityInput(struct));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nvertexCapacityInput(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VERTEXCAPACITYINPUT, value);
    }

    public static void nvertexCountOutput(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VERTEXCOUNTOUTPUT, value);
    }

    public static void nvertices(long struct, @Nullable XrVector3f.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)VERTICES, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            XrSceneMeshVertexBufferMSFT.nvertexCapacityInput(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = XrSceneMeshVertexBufferMSFT.__struct(XrSceneMeshVertexBufferMSFT.__member(4), XrSceneMeshVertexBufferMSFT.__member(POINTER_SIZE), XrSceneMeshVertexBufferMSFT.__member(4), XrSceneMeshVertexBufferMSFT.__member(4), XrSceneMeshVertexBufferMSFT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        VERTEXCAPACITYINPUT = layout.offsetof(2);
        VERTEXCOUNTOUTPUT = layout.offsetof(3);
        VERTICES = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrSceneMeshVertexBufferMSFT, Buffer>
    implements NativeResource {
        private static final XrSceneMeshVertexBufferMSFT ELEMENT_FACTORY = XrSceneMeshVertexBufferMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrSceneMeshVertexBufferMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSceneMeshVertexBufferMSFT.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrSceneMeshVertexBufferMSFT.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int vertexCapacityInput() {
            return XrSceneMeshVertexBufferMSFT.nvertexCapacityInput(this.address());
        }

        @NativeType(value="uint32_t")
        public int vertexCountOutput() {
            return XrSceneMeshVertexBufferMSFT.nvertexCountOutput(this.address());
        }

        @Nullable
        @NativeType(value="XrVector3f *")
        public XrVector3f.Buffer vertices() {
            return XrSceneMeshVertexBufferMSFT.nvertices(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSceneMeshVertexBufferMSFT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000097016);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrSceneMeshVertexBufferMSFT.nnext(this.address(), value);
            return this;
        }

        public Buffer vertexCapacityInput(@NativeType(value="uint32_t") int value) {
            XrSceneMeshVertexBufferMSFT.nvertexCapacityInput(this.address(), value);
            return this;
        }

        public Buffer vertexCountOutput(@NativeType(value="uint32_t") int value) {
            XrSceneMeshVertexBufferMSFT.nvertexCountOutput(this.address(), value);
            return this;
        }

        public Buffer vertices(@Nullable @NativeType(value="XrVector3f *") XrVector3f.Buffer value) {
            XrSceneMeshVertexBufferMSFT.nvertices(this.address(), value);
            return this;
        }
    }
}

