/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneMeshBuffersMSFT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;

    public XrSceneMeshBuffersMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSceneMeshBuffersMSFT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSceneMeshBuffersMSFT.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrSceneMeshBuffersMSFT.nnext(this.address());
    }

    public XrSceneMeshBuffersMSFT type(@NativeType(value="XrStructureType") int value) {
        XrSceneMeshBuffersMSFT.ntype(this.address(), value);
        return this;
    }

    public XrSceneMeshBuffersMSFT type$Default() {
        return this.type(1000097015);
    }

    public XrSceneMeshBuffersMSFT next(@NativeType(value="void *") long value) {
        XrSceneMeshBuffersMSFT.nnext(this.address(), value);
        return this;
    }

    public XrSceneMeshBuffersMSFT set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrSceneMeshBuffersMSFT set(XrSceneMeshBuffersMSFT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSceneMeshBuffersMSFT malloc() {
        return XrSceneMeshBuffersMSFT.wrap(XrSceneMeshBuffersMSFT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrSceneMeshBuffersMSFT calloc() {
        return XrSceneMeshBuffersMSFT.wrap(XrSceneMeshBuffersMSFT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrSceneMeshBuffersMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrSceneMeshBuffersMSFT.wrap(XrSceneMeshBuffersMSFT.class, MemoryUtil.memAddress(container), container);
    }

    public static XrSceneMeshBuffersMSFT create(long address) {
        return XrSceneMeshBuffersMSFT.wrap(XrSceneMeshBuffersMSFT.class, address);
    }

    @Nullable
    public static XrSceneMeshBuffersMSFT createSafe(long address) {
        return address == 0L ? null : XrSceneMeshBuffersMSFT.wrap(XrSceneMeshBuffersMSFT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrSceneMeshBuffersMSFT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrSceneMeshBuffersMSFT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrSceneMeshBuffersMSFT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSceneMeshBuffersMSFT.__create(capacity, SIZEOF);
        return XrSceneMeshBuffersMSFT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrSceneMeshBuffersMSFT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrSceneMeshBuffersMSFT.wrap(Buffer.class, address, capacity);
    }

    public static XrSceneMeshBuffersMSFT malloc(MemoryStack stack) {
        return XrSceneMeshBuffersMSFT.wrap(XrSceneMeshBuffersMSFT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSceneMeshBuffersMSFT calloc(MemoryStack stack) {
        return XrSceneMeshBuffersMSFT.wrap(XrSceneMeshBuffersMSFT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrSceneMeshBuffersMSFT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrSceneMeshBuffersMSFT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    static {
        Struct.Layout layout = XrSceneMeshBuffersMSFT.__struct(XrSceneMeshBuffersMSFT.__member(4), XrSceneMeshBuffersMSFT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrSceneMeshBuffersMSFT, Buffer>
    implements NativeResource {
        private static final XrSceneMeshBuffersMSFT ELEMENT_FACTORY = XrSceneMeshBuffersMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrSceneMeshBuffersMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSceneMeshBuffersMSFT.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrSceneMeshBuffersMSFT.nnext(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSceneMeshBuffersMSFT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000097015);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrSceneMeshBuffersMSFT.nnext(this.address(), value);
            return this;
        }
    }
}

