/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSceneComponentMSFT;
import org.lwjgl.openxr.XrSceneMeshesMSFT;
import org.lwjgl.openxr.XrSceneObjectsMSFT;
import org.lwjgl.openxr.XrScenePlanesMSFT;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneComponentsMSFT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int COMPONENTCAPACITYINPUT;
    public static final int COMPONENTCOUNTOUTPUT;
    public static final int COMPONENTS;

    public XrSceneComponentsMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSceneComponentsMSFT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSceneComponentsMSFT.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrSceneComponentsMSFT.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int componentCapacityInput() {
        return XrSceneComponentsMSFT.ncomponentCapacityInput(this.address());
    }

    @NativeType(value="uint32_t")
    public int componentCountOutput() {
        return XrSceneComponentsMSFT.ncomponentCountOutput(this.address());
    }

    @Nullable
    @NativeType(value="XrSceneComponentMSFT *")
    public XrSceneComponentMSFT.Buffer components() {
        return XrSceneComponentsMSFT.ncomponents(this.address());
    }

    public XrSceneComponentsMSFT type(@NativeType(value="XrStructureType") int value) {
        XrSceneComponentsMSFT.ntype(this.address(), value);
        return this;
    }

    public XrSceneComponentsMSFT type$Default() {
        return this.type(1000097004);
    }

    public XrSceneComponentsMSFT next(@NativeType(value="void *") long value) {
        XrSceneComponentsMSFT.nnext(this.address(), value);
        return this;
    }

    public XrSceneComponentsMSFT next(XrSceneMeshesMSFT value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSceneComponentsMSFT next(XrSceneObjectsMSFT value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSceneComponentsMSFT next(XrScenePlanesMSFT value) {
        return this.next(value.next(this.next()).address());
    }

    public XrSceneComponentsMSFT componentCapacityInput(@NativeType(value="uint32_t") int value) {
        XrSceneComponentsMSFT.ncomponentCapacityInput(this.address(), value);
        return this;
    }

    public XrSceneComponentsMSFT componentCountOutput(@NativeType(value="uint32_t") int value) {
        XrSceneComponentsMSFT.ncomponentCountOutput(this.address(), value);
        return this;
    }

    public XrSceneComponentsMSFT components(@Nullable @NativeType(value="XrSceneComponentMSFT *") XrSceneComponentMSFT.Buffer value) {
        XrSceneComponentsMSFT.ncomponents(this.address(), value);
        return this;
    }

    public XrSceneComponentsMSFT set(int type, long next, int componentCapacityInput, int componentCountOutput, @Nullable XrSceneComponentMSFT.Buffer components) {
        this.type(type);
        this.next(next);
        this.componentCapacityInput(componentCapacityInput);
        this.componentCountOutput(componentCountOutput);
        this.components(components);
        return this;
    }

    public XrSceneComponentsMSFT set(XrSceneComponentsMSFT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSceneComponentsMSFT malloc() {
        return XrSceneComponentsMSFT.wrap(XrSceneComponentsMSFT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrSceneComponentsMSFT calloc() {
        return XrSceneComponentsMSFT.wrap(XrSceneComponentsMSFT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrSceneComponentsMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrSceneComponentsMSFT.wrap(XrSceneComponentsMSFT.class, MemoryUtil.memAddress(container), container);
    }

    public static XrSceneComponentsMSFT create(long address) {
        return XrSceneComponentsMSFT.wrap(XrSceneComponentsMSFT.class, address);
    }

    @Nullable
    public static XrSceneComponentsMSFT createSafe(long address) {
        return address == 0L ? null : XrSceneComponentsMSFT.wrap(XrSceneComponentsMSFT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrSceneComponentsMSFT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrSceneComponentsMSFT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrSceneComponentsMSFT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSceneComponentsMSFT.__create(capacity, SIZEOF);
        return XrSceneComponentsMSFT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrSceneComponentsMSFT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrSceneComponentsMSFT.wrap(Buffer.class, address, capacity);
    }

    public static XrSceneComponentsMSFT malloc(MemoryStack stack) {
        return XrSceneComponentsMSFT.wrap(XrSceneComponentsMSFT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSceneComponentsMSFT calloc(MemoryStack stack) {
        return XrSceneComponentsMSFT.wrap(XrSceneComponentsMSFT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrSceneComponentsMSFT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrSceneComponentsMSFT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int ncomponentCapacityInput(long struct) {
        return UNSAFE.getInt(null, struct + (long)COMPONENTCAPACITYINPUT);
    }

    public static int ncomponentCountOutput(long struct) {
        return UNSAFE.getInt(null, struct + (long)COMPONENTCOUNTOUTPUT);
    }

    @Nullable
    public static XrSceneComponentMSFT.Buffer ncomponents(long struct) {
        return XrSceneComponentMSFT.createSafe(MemoryUtil.memGetAddress(struct + (long)COMPONENTS), XrSceneComponentsMSFT.ncomponentCapacityInput(struct));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void ncomponentCapacityInput(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COMPONENTCAPACITYINPUT, value);
    }

    public static void ncomponentCountOutput(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COMPONENTCOUNTOUTPUT, value);
    }

    public static void ncomponents(long struct, @Nullable XrSceneComponentMSFT.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)COMPONENTS, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            XrSceneComponentsMSFT.ncomponentCapacityInput(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = XrSceneComponentsMSFT.__struct(XrSceneComponentsMSFT.__member(4), XrSceneComponentsMSFT.__member(POINTER_SIZE), XrSceneComponentsMSFT.__member(4), XrSceneComponentsMSFT.__member(4), XrSceneComponentsMSFT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        COMPONENTCAPACITYINPUT = layout.offsetof(2);
        COMPONENTCOUNTOUTPUT = layout.offsetof(3);
        COMPONENTS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<XrSceneComponentsMSFT, Buffer>
    implements NativeResource {
        private static final XrSceneComponentsMSFT ELEMENT_FACTORY = XrSceneComponentsMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrSceneComponentsMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSceneComponentsMSFT.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrSceneComponentsMSFT.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int componentCapacityInput() {
            return XrSceneComponentsMSFT.ncomponentCapacityInput(this.address());
        }

        @NativeType(value="uint32_t")
        public int componentCountOutput() {
            return XrSceneComponentsMSFT.ncomponentCountOutput(this.address());
        }

        @Nullable
        @NativeType(value="XrSceneComponentMSFT *")
        public XrSceneComponentMSFT.Buffer components() {
            return XrSceneComponentsMSFT.ncomponents(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSceneComponentsMSFT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000097004);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrSceneComponentsMSFT.nnext(this.address(), value);
            return this;
        }

        public Buffer next(XrSceneMeshesMSFT value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrSceneObjectsMSFT value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer next(XrScenePlanesMSFT value) {
            return this.next(value.next(this.next()).address());
        }

        public Buffer componentCapacityInput(@NativeType(value="uint32_t") int value) {
            XrSceneComponentsMSFT.ncomponentCapacityInput(this.address(), value);
            return this;
        }

        public Buffer componentCountOutput(@NativeType(value="uint32_t") int value) {
            XrSceneComponentsMSFT.ncomponentCountOutput(this.address(), value);
            return this;
        }

        public Buffer components(@Nullable @NativeType(value="XrSceneComponentMSFT *") XrSceneComponentMSFT.Buffer value) {
            XrSceneComponentsMSFT.ncomponents(this.address(), value);
            return this;
        }
    }
}

