/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrSceneComponentLocationMSFT;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneComponentLocationsMSFT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int LOCATIONCOUNT;
    public static final int LOCATIONS;

    public XrSceneComponentLocationsMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrSceneComponentLocationsMSFT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrSceneComponentLocationsMSFT.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrSceneComponentLocationsMSFT.nnext(this.address());
    }

    @NativeType(value="uint32_t")
    public int locationCount() {
        return XrSceneComponentLocationsMSFT.nlocationCount(this.address());
    }

    @Nullable
    @NativeType(value="XrSceneComponentLocationMSFT *")
    public XrSceneComponentLocationMSFT.Buffer locations() {
        return XrSceneComponentLocationsMSFT.nlocations(this.address());
    }

    public XrSceneComponentLocationsMSFT type(@NativeType(value="XrStructureType") int value) {
        XrSceneComponentLocationsMSFT.ntype(this.address(), value);
        return this;
    }

    public XrSceneComponentLocationsMSFT type$Default() {
        return this.type(1000097006);
    }

    public XrSceneComponentLocationsMSFT next(@NativeType(value="void *") long value) {
        XrSceneComponentLocationsMSFT.nnext(this.address(), value);
        return this;
    }

    public XrSceneComponentLocationsMSFT locationCount(@NativeType(value="uint32_t") int value) {
        XrSceneComponentLocationsMSFT.nlocationCount(this.address(), value);
        return this;
    }

    public XrSceneComponentLocationsMSFT locations(@Nullable @NativeType(value="XrSceneComponentLocationMSFT *") XrSceneComponentLocationMSFT.Buffer value) {
        XrSceneComponentLocationsMSFT.nlocations(this.address(), value);
        return this;
    }

    public XrSceneComponentLocationsMSFT set(int type, long next, int locationCount, @Nullable XrSceneComponentLocationMSFT.Buffer locations) {
        this.type(type);
        this.next(next);
        this.locationCount(locationCount);
        this.locations(locations);
        return this;
    }

    public XrSceneComponentLocationsMSFT set(XrSceneComponentLocationsMSFT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrSceneComponentLocationsMSFT malloc() {
        return XrSceneComponentLocationsMSFT.wrap(XrSceneComponentLocationsMSFT.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrSceneComponentLocationsMSFT calloc() {
        return XrSceneComponentLocationsMSFT.wrap(XrSceneComponentLocationsMSFT.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrSceneComponentLocationsMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrSceneComponentLocationsMSFT.wrap(XrSceneComponentLocationsMSFT.class, MemoryUtil.memAddress(container), container);
    }

    public static XrSceneComponentLocationsMSFT create(long address) {
        return XrSceneComponentLocationsMSFT.wrap(XrSceneComponentLocationsMSFT.class, address);
    }

    @Nullable
    public static XrSceneComponentLocationsMSFT createSafe(long address) {
        return address == 0L ? null : XrSceneComponentLocationsMSFT.wrap(XrSceneComponentLocationsMSFT.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrSceneComponentLocationsMSFT.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrSceneComponentLocationsMSFT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrSceneComponentLocationsMSFT.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSceneComponentLocationsMSFT.__create(capacity, SIZEOF);
        return XrSceneComponentLocationsMSFT.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrSceneComponentLocationsMSFT.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrSceneComponentLocationsMSFT.wrap(Buffer.class, address, capacity);
    }

    public static XrSceneComponentLocationsMSFT malloc(MemoryStack stack) {
        return XrSceneComponentLocationsMSFT.wrap(XrSceneComponentLocationsMSFT.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSceneComponentLocationsMSFT calloc(MemoryStack stack) {
        return XrSceneComponentLocationsMSFT.wrap(XrSceneComponentLocationsMSFT.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrSceneComponentLocationsMSFT.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrSceneComponentLocationsMSFT.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static int nlocationCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)LOCATIONCOUNT);
    }

    @Nullable
    public static XrSceneComponentLocationMSFT.Buffer nlocations(long struct) {
        return XrSceneComponentLocationMSFT.createSafe(MemoryUtil.memGetAddress(struct + (long)LOCATIONS), XrSceneComponentLocationsMSFT.nlocationCount(struct));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void nlocationCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LOCATIONCOUNT, value);
    }

    public static void nlocations(long struct, @Nullable XrSceneComponentLocationMSFT.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)LOCATIONS, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            XrSceneComponentLocationsMSFT.nlocationCount(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = XrSceneComponentLocationsMSFT.__struct(XrSceneComponentLocationsMSFT.__member(4), XrSceneComponentLocationsMSFT.__member(POINTER_SIZE), XrSceneComponentLocationsMSFT.__member(4), XrSceneComponentLocationsMSFT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        LOCATIONCOUNT = layout.offsetof(2);
        LOCATIONS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<XrSceneComponentLocationsMSFT, Buffer>
    implements NativeResource {
        private static final XrSceneComponentLocationsMSFT ELEMENT_FACTORY = XrSceneComponentLocationsMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrSceneComponentLocationsMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrSceneComponentLocationsMSFT.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrSceneComponentLocationsMSFT.nnext(this.address());
        }

        @NativeType(value="uint32_t")
        public int locationCount() {
            return XrSceneComponentLocationsMSFT.nlocationCount(this.address());
        }

        @Nullable
        @NativeType(value="XrSceneComponentLocationMSFT *")
        public XrSceneComponentLocationMSFT.Buffer locations() {
            return XrSceneComponentLocationsMSFT.nlocations(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrSceneComponentLocationsMSFT.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000097006);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrSceneComponentLocationsMSFT.nnext(this.address(), value);
            return this;
        }

        public Buffer locationCount(@NativeType(value="uint32_t") int value) {
            XrSceneComponentLocationsMSFT.nlocationCount(this.address(), value);
            return this;
        }

        public Buffer locations(@Nullable @NativeType(value="XrSceneComponentLocationMSFT *") XrSceneComponentLocationMSFT.Buffer value) {
            XrSceneComponentLocationsMSFT.nlocations(this.address(), value);
            return this;
        }
    }
}

