/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrRenderModelPathInfoFB
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int PATH;

    public XrRenderModelPathInfoFB(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrRenderModelPathInfoFB.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrRenderModelPathInfoFB.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrRenderModelPathInfoFB.nnext(this.address());
    }

    @NativeType(value="XrPath")
    public long path() {
        return XrRenderModelPathInfoFB.npath(this.address());
    }

    public XrRenderModelPathInfoFB type(@NativeType(value="XrStructureType") int value) {
        XrRenderModelPathInfoFB.ntype(this.address(), value);
        return this;
    }

    public XrRenderModelPathInfoFB type$Default() {
        return this.type(1000119000);
    }

    public XrRenderModelPathInfoFB next(@NativeType(value="void *") long value) {
        XrRenderModelPathInfoFB.nnext(this.address(), value);
        return this;
    }

    public XrRenderModelPathInfoFB path(@NativeType(value="XrPath") long value) {
        XrRenderModelPathInfoFB.npath(this.address(), value);
        return this;
    }

    public XrRenderModelPathInfoFB set(int type, long next, long path) {
        this.type(type);
        this.next(next);
        this.path(path);
        return this;
    }

    public XrRenderModelPathInfoFB set(XrRenderModelPathInfoFB src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrRenderModelPathInfoFB malloc() {
        return XrRenderModelPathInfoFB.wrap(XrRenderModelPathInfoFB.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrRenderModelPathInfoFB calloc() {
        return XrRenderModelPathInfoFB.wrap(XrRenderModelPathInfoFB.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrRenderModelPathInfoFB create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrRenderModelPathInfoFB.wrap(XrRenderModelPathInfoFB.class, MemoryUtil.memAddress(container), container);
    }

    public static XrRenderModelPathInfoFB create(long address) {
        return XrRenderModelPathInfoFB.wrap(XrRenderModelPathInfoFB.class, address);
    }

    @Nullable
    public static XrRenderModelPathInfoFB createSafe(long address) {
        return address == 0L ? null : XrRenderModelPathInfoFB.wrap(XrRenderModelPathInfoFB.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrRenderModelPathInfoFB.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrRenderModelPathInfoFB.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrRenderModelPathInfoFB.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrRenderModelPathInfoFB.__create(capacity, SIZEOF);
        return XrRenderModelPathInfoFB.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrRenderModelPathInfoFB.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrRenderModelPathInfoFB.wrap(Buffer.class, address, capacity);
    }

    public static XrRenderModelPathInfoFB malloc(MemoryStack stack) {
        return XrRenderModelPathInfoFB.wrap(XrRenderModelPathInfoFB.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrRenderModelPathInfoFB calloc(MemoryStack stack) {
        return XrRenderModelPathInfoFB.wrap(XrRenderModelPathInfoFB.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrRenderModelPathInfoFB.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrRenderModelPathInfoFB.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long npath(long struct) {
        return UNSAFE.getLong(null, struct + (long)PATH);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void npath(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)PATH, value);
    }

    static {
        Struct.Layout layout = XrRenderModelPathInfoFB.__struct(XrRenderModelPathInfoFB.__member(4), XrRenderModelPathInfoFB.__member(POINTER_SIZE), XrRenderModelPathInfoFB.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        PATH = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrRenderModelPathInfoFB, Buffer>
    implements NativeResource {
        private static final XrRenderModelPathInfoFB ELEMENT_FACTORY = XrRenderModelPathInfoFB.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrRenderModelPathInfoFB getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrRenderModelPathInfoFB.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrRenderModelPathInfoFB.nnext(this.address());
        }

        @NativeType(value="XrPath")
        public long path() {
            return XrRenderModelPathInfoFB.npath(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrRenderModelPathInfoFB.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000119000);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrRenderModelPathInfoFB.nnext(this.address(), value);
            return this;
        }

        public Buffer path(@NativeType(value="XrPath") long value) {
            XrRenderModelPathInfoFB.npath(this.address(), value);
            return this;
        }
    }
}

