/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrExtent2Di;
import org.lwjgl.openxr.XrOffset2Di;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrRect2Di
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OFFSET;
    public static final int EXTENT;

    public XrRect2Di(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrRect2Di.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public XrOffset2Di offset() {
        return XrRect2Di.noffset(this.address());
    }

    public XrExtent2Di extent() {
        return XrRect2Di.nextent(this.address());
    }

    public XrRect2Di offset(XrOffset2Di value) {
        XrRect2Di.noffset(this.address(), value);
        return this;
    }

    public XrRect2Di offset(Consumer<XrOffset2Di> consumer) {
        consumer.accept(this.offset());
        return this;
    }

    public XrRect2Di extent(XrExtent2Di value) {
        XrRect2Di.nextent(this.address(), value);
        return this;
    }

    public XrRect2Di extent(Consumer<XrExtent2Di> consumer) {
        consumer.accept(this.extent());
        return this;
    }

    public XrRect2Di set(XrOffset2Di offset, XrExtent2Di extent) {
        this.offset(offset);
        this.extent(extent);
        return this;
    }

    public XrRect2Di set(XrRect2Di src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrRect2Di malloc() {
        return XrRect2Di.wrap(XrRect2Di.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrRect2Di calloc() {
        return XrRect2Di.wrap(XrRect2Di.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrRect2Di create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrRect2Di.wrap(XrRect2Di.class, MemoryUtil.memAddress(container), container);
    }

    public static XrRect2Di create(long address) {
        return XrRect2Di.wrap(XrRect2Di.class, address);
    }

    @Nullable
    public static XrRect2Di createSafe(long address) {
        return address == 0L ? null : XrRect2Di.wrap(XrRect2Di.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrRect2Di.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrRect2Di.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrRect2Di.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrRect2Di.__create(capacity, SIZEOF);
        return XrRect2Di.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrRect2Di.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrRect2Di.wrap(Buffer.class, address, capacity);
    }

    public static XrRect2Di malloc(MemoryStack stack) {
        return XrRect2Di.wrap(XrRect2Di.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrRect2Di calloc(MemoryStack stack) {
        return XrRect2Di.wrap(XrRect2Di.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrRect2Di.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrRect2Di.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static XrOffset2Di noffset(long struct) {
        return XrOffset2Di.create(struct + (long)OFFSET);
    }

    public static XrExtent2Di nextent(long struct) {
        return XrExtent2Di.create(struct + (long)EXTENT);
    }

    public static void noffset(long struct, XrOffset2Di value) {
        MemoryUtil.memCopy(value.address(), struct + (long)OFFSET, XrOffset2Di.SIZEOF);
    }

    public static void nextent(long struct, XrExtent2Di value) {
        MemoryUtil.memCopy(value.address(), struct + (long)EXTENT, XrExtent2Di.SIZEOF);
    }

    static {
        Struct.Layout layout = XrRect2Di.__struct(XrRect2Di.__member(XrOffset2Di.SIZEOF, XrOffset2Di.ALIGNOF), XrRect2Di.__member(XrExtent2Di.SIZEOF, XrExtent2Di.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OFFSET = layout.offsetof(0);
        EXTENT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrRect2Di, Buffer>
    implements NativeResource {
        private static final XrRect2Di ELEMENT_FACTORY = XrRect2Di.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrRect2Di getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public XrOffset2Di offset() {
            return XrRect2Di.noffset(this.address());
        }

        public XrExtent2Di extent() {
            return XrRect2Di.nextent(this.address());
        }

        public Buffer offset(XrOffset2Di value) {
            XrRect2Di.noffset(this.address(), value);
            return this;
        }

        public Buffer offset(Consumer<XrOffset2Di> consumer) {
            consumer.accept(this.offset());
            return this;
        }

        public Buffer extent(XrExtent2Di value) {
            XrRect2Di.nextent(this.address(), value);
            return this;
        }

        public Buffer extent(Consumer<XrExtent2Di> consumer) {
            consumer.accept(this.extent());
            return this;
        }
    }
}

