/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrQuaternionf;
import org.lwjgl.openxr.XrVector3f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrPosef
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ORIENTATION;
    public static final int POSITION;

    public XrPosef(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrPosef.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public XrQuaternionf orientation() {
        return XrPosef.norientation(this.address());
    }

    public XrVector3f position$() {
        return XrPosef.nposition$(this.address());
    }

    public XrPosef orientation(XrQuaternionf value) {
        XrPosef.norientation(this.address(), value);
        return this;
    }

    public XrPosef orientation(Consumer<XrQuaternionf> consumer) {
        consumer.accept(this.orientation());
        return this;
    }

    public XrPosef position$(XrVector3f value) {
        XrPosef.nposition$(this.address(), value);
        return this;
    }

    public XrPosef position$(Consumer<XrVector3f> consumer) {
        consumer.accept(this.position$());
        return this;
    }

    public XrPosef set(XrQuaternionf orientation, XrVector3f position$) {
        this.orientation(orientation);
        this.position$(position$);
        return this;
    }

    public XrPosef set(XrPosef src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrPosef malloc() {
        return XrPosef.wrap(XrPosef.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrPosef calloc() {
        return XrPosef.wrap(XrPosef.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrPosef create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrPosef.wrap(XrPosef.class, MemoryUtil.memAddress(container), container);
    }

    public static XrPosef create(long address) {
        return XrPosef.wrap(XrPosef.class, address);
    }

    @Nullable
    public static XrPosef createSafe(long address) {
        return address == 0L ? null : XrPosef.wrap(XrPosef.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrPosef.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrPosef.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrPosef.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrPosef.__create(capacity, SIZEOF);
        return XrPosef.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrPosef.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrPosef.wrap(Buffer.class, address, capacity);
    }

    public static XrPosef malloc(MemoryStack stack) {
        return XrPosef.wrap(XrPosef.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrPosef calloc(MemoryStack stack) {
        return XrPosef.wrap(XrPosef.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrPosef.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrPosef.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static XrQuaternionf norientation(long struct) {
        return XrQuaternionf.create(struct + (long)ORIENTATION);
    }

    public static XrVector3f nposition$(long struct) {
        return XrVector3f.create(struct + (long)POSITION);
    }

    public static void norientation(long struct, XrQuaternionf value) {
        MemoryUtil.memCopy(value.address(), struct + (long)ORIENTATION, XrQuaternionf.SIZEOF);
    }

    public static void nposition$(long struct, XrVector3f value) {
        MemoryUtil.memCopy(value.address(), struct + (long)POSITION, XrVector3f.SIZEOF);
    }

    static {
        Struct.Layout layout = XrPosef.__struct(XrPosef.__member(XrQuaternionf.SIZEOF, XrQuaternionf.ALIGNOF), XrPosef.__member(XrVector3f.SIZEOF, XrVector3f.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ORIENTATION = layout.offsetof(0);
        POSITION = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrPosef, Buffer>
    implements NativeResource {
        private static final XrPosef ELEMENT_FACTORY = XrPosef.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrPosef getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public XrQuaternionf orientation() {
            return XrPosef.norientation(this.address());
        }

        public XrVector3f position$() {
            return XrPosef.nposition$(this.address());
        }

        public Buffer orientation(XrQuaternionf value) {
            XrPosef.norientation(this.address(), value);
            return this;
        }

        public Buffer orientation(Consumer<XrQuaternionf> consumer) {
            consumer.accept(this.orientation());
            return this;
        }

        public Buffer position$(XrVector3f value) {
            XrPosef.nposition$(this.address(), value);
            return this;
        }

        public Buffer position$(Consumer<XrVector3f> consumer) {
            consumer.accept(this.position$());
            return this;
        }
    }
}

