/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrInteractionProfileState
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int INTERACTIONPROFILE;

    public XrInteractionProfileState(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrInteractionProfileState.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrInteractionProfileState.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrInteractionProfileState.nnext(this.address());
    }

    @NativeType(value="XrPath")
    public long interactionProfile() {
        return XrInteractionProfileState.ninteractionProfile(this.address());
    }

    public XrInteractionProfileState type(@NativeType(value="XrStructureType") int value) {
        XrInteractionProfileState.ntype(this.address(), value);
        return this;
    }

    public XrInteractionProfileState type$Default() {
        return this.type(53);
    }

    public XrInteractionProfileState next(@NativeType(value="void *") long value) {
        XrInteractionProfileState.nnext(this.address(), value);
        return this;
    }

    public XrInteractionProfileState interactionProfile(@NativeType(value="XrPath") long value) {
        XrInteractionProfileState.ninteractionProfile(this.address(), value);
        return this;
    }

    public XrInteractionProfileState set(int type, long next, long interactionProfile) {
        this.type(type);
        this.next(next);
        this.interactionProfile(interactionProfile);
        return this;
    }

    public XrInteractionProfileState set(XrInteractionProfileState src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrInteractionProfileState malloc() {
        return XrInteractionProfileState.wrap(XrInteractionProfileState.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrInteractionProfileState calloc() {
        return XrInteractionProfileState.wrap(XrInteractionProfileState.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrInteractionProfileState create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrInteractionProfileState.wrap(XrInteractionProfileState.class, MemoryUtil.memAddress(container), container);
    }

    public static XrInteractionProfileState create(long address) {
        return XrInteractionProfileState.wrap(XrInteractionProfileState.class, address);
    }

    @Nullable
    public static XrInteractionProfileState createSafe(long address) {
        return address == 0L ? null : XrInteractionProfileState.wrap(XrInteractionProfileState.class, address);
    }

    public static Buffer malloc(int capacity) {
        return XrInteractionProfileState.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrInteractionProfileState.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrInteractionProfileState.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrInteractionProfileState.__create(capacity, SIZEOF);
        return XrInteractionProfileState.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrInteractionProfileState.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrInteractionProfileState.wrap(Buffer.class, address, capacity);
    }

    public static XrInteractionProfileState malloc(MemoryStack stack) {
        return XrInteractionProfileState.wrap(XrInteractionProfileState.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrInteractionProfileState calloc(MemoryStack stack) {
        return XrInteractionProfileState.wrap(XrInteractionProfileState.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrInteractionProfileState.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrInteractionProfileState.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long ninteractionProfile(long struct) {
        return UNSAFE.getLong(null, struct + (long)INTERACTIONPROFILE);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void ninteractionProfile(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)INTERACTIONPROFILE, value);
    }

    static {
        Struct.Layout layout = XrInteractionProfileState.__struct(XrInteractionProfileState.__member(4), XrInteractionProfileState.__member(POINTER_SIZE), XrInteractionProfileState.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        INTERACTIONPROFILE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<XrInteractionProfileState, Buffer>
    implements NativeResource {
        private static final XrInteractionProfileState ELEMENT_FACTORY = XrInteractionProfileState.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrInteractionProfileState getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrInteractionProfileState.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrInteractionProfileState.nnext(this.address());
        }

        @NativeType(value="XrPath")
        public long interactionProfile() {
            return XrInteractionProfileState.ninteractionProfile(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrInteractionProfileState.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(53);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrInteractionProfileState.nnext(this.address(), value);
            return this;
        }

        public Buffer interactionProfile(@NativeType(value="XrPath") long value) {
            XrInteractionProfileState.ninteractionProfile(this.address(), value);
            return this;
        }
    }
}

