/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrAction;
import org.lwjgl.openxr.XrBindingModificationBaseHeaderKHR;
import org.lwjgl.openxr.XrHapticBaseHeader;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrInteractionProfileAnalogThresholdVALVE
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int ACTION;
    public static final int BINDING;
    public static final int ONTHRESHOLD;
    public static final int OFFTHRESHOLD;
    public static final int ONHAPTIC;
    public static final int OFFHAPTIC;

    public XrInteractionProfileAnalogThresholdVALVE(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrInteractionProfileAnalogThresholdVALVE.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrInteractionProfileAnalogThresholdVALVE.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrInteractionProfileAnalogThresholdVALVE.nnext(this.address());
    }

    @NativeType(value="XrAction")
    public long action() {
        return XrInteractionProfileAnalogThresholdVALVE.naction(this.address());
    }

    @NativeType(value="XrPath")
    public long binding() {
        return XrInteractionProfileAnalogThresholdVALVE.nbinding(this.address());
    }

    public float onThreshold() {
        return XrInteractionProfileAnalogThresholdVALVE.nonThreshold(this.address());
    }

    public float offThreshold() {
        return XrInteractionProfileAnalogThresholdVALVE.noffThreshold(this.address());
    }

    @Nullable
    @NativeType(value="XrHapticBaseHeader const *")
    public XrHapticBaseHeader onHaptic() {
        return XrInteractionProfileAnalogThresholdVALVE.nonHaptic(this.address());
    }

    @Nullable
    @NativeType(value="XrHapticBaseHeader const *")
    public XrHapticBaseHeader offHaptic() {
        return XrInteractionProfileAnalogThresholdVALVE.noffHaptic(this.address());
    }

    public XrInteractionProfileAnalogThresholdVALVE type(@NativeType(value="XrStructureType") int value) {
        XrInteractionProfileAnalogThresholdVALVE.ntype(this.address(), value);
        return this;
    }

    public XrInteractionProfileAnalogThresholdVALVE type$Default() {
        return this.type(1000079000);
    }

    public XrInteractionProfileAnalogThresholdVALVE next(@NativeType(value="void const *") long value) {
        XrInteractionProfileAnalogThresholdVALVE.nnext(this.address(), value);
        return this;
    }

    public XrInteractionProfileAnalogThresholdVALVE action(XrAction value) {
        XrInteractionProfileAnalogThresholdVALVE.naction(this.address(), value);
        return this;
    }

    public XrInteractionProfileAnalogThresholdVALVE binding(@NativeType(value="XrPath") long value) {
        XrInteractionProfileAnalogThresholdVALVE.nbinding(this.address(), value);
        return this;
    }

    public XrInteractionProfileAnalogThresholdVALVE onThreshold(float value) {
        XrInteractionProfileAnalogThresholdVALVE.nonThreshold(this.address(), value);
        return this;
    }

    public XrInteractionProfileAnalogThresholdVALVE offThreshold(float value) {
        XrInteractionProfileAnalogThresholdVALVE.noffThreshold(this.address(), value);
        return this;
    }

    public XrInteractionProfileAnalogThresholdVALVE onHaptic(@Nullable @NativeType(value="XrHapticBaseHeader const *") XrHapticBaseHeader value) {
        XrInteractionProfileAnalogThresholdVALVE.nonHaptic(this.address(), value);
        return this;
    }

    public XrInteractionProfileAnalogThresholdVALVE offHaptic(@Nullable @NativeType(value="XrHapticBaseHeader const *") XrHapticBaseHeader value) {
        XrInteractionProfileAnalogThresholdVALVE.noffHaptic(this.address(), value);
        return this;
    }

    public XrInteractionProfileAnalogThresholdVALVE set(int type, long next, XrAction action, long binding, float onThreshold, float offThreshold, @Nullable XrHapticBaseHeader onHaptic, @Nullable XrHapticBaseHeader offHaptic) {
        this.type(type);
        this.next(next);
        this.action(action);
        this.binding(binding);
        this.onThreshold(onThreshold);
        this.offThreshold(offThreshold);
        this.onHaptic(onHaptic);
        this.offHaptic(offHaptic);
        return this;
    }

    public XrInteractionProfileAnalogThresholdVALVE set(XrInteractionProfileAnalogThresholdVALVE src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrInteractionProfileAnalogThresholdVALVE malloc() {
        return XrInteractionProfileAnalogThresholdVALVE.wrap(XrInteractionProfileAnalogThresholdVALVE.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrInteractionProfileAnalogThresholdVALVE calloc() {
        return XrInteractionProfileAnalogThresholdVALVE.wrap(XrInteractionProfileAnalogThresholdVALVE.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrInteractionProfileAnalogThresholdVALVE create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrInteractionProfileAnalogThresholdVALVE.wrap(XrInteractionProfileAnalogThresholdVALVE.class, MemoryUtil.memAddress(container), container);
    }

    public static XrInteractionProfileAnalogThresholdVALVE create(long address) {
        return XrInteractionProfileAnalogThresholdVALVE.wrap(XrInteractionProfileAnalogThresholdVALVE.class, address);
    }

    @Nullable
    public static XrInteractionProfileAnalogThresholdVALVE createSafe(long address) {
        return address == 0L ? null : XrInteractionProfileAnalogThresholdVALVE.wrap(XrInteractionProfileAnalogThresholdVALVE.class, address);
    }

    public static XrInteractionProfileAnalogThresholdVALVE create(XrBindingModificationBaseHeaderKHR value) {
        return XrInteractionProfileAnalogThresholdVALVE.wrap(XrInteractionProfileAnalogThresholdVALVE.class, value);
    }

    public static Buffer malloc(int capacity) {
        return XrInteractionProfileAnalogThresholdVALVE.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrInteractionProfileAnalogThresholdVALVE.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrInteractionProfileAnalogThresholdVALVE.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrInteractionProfileAnalogThresholdVALVE.__create(capacity, SIZEOF);
        return XrInteractionProfileAnalogThresholdVALVE.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrInteractionProfileAnalogThresholdVALVE.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrInteractionProfileAnalogThresholdVALVE.wrap(Buffer.class, address, capacity);
    }

    public static Buffer create(XrBindingModificationBaseHeaderKHR.Buffer value) {
        return XrInteractionProfileAnalogThresholdVALVE.wrap(Buffer.class, value);
    }

    public static XrInteractionProfileAnalogThresholdVALVE malloc(MemoryStack stack) {
        return XrInteractionProfileAnalogThresholdVALVE.wrap(XrInteractionProfileAnalogThresholdVALVE.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrInteractionProfileAnalogThresholdVALVE calloc(MemoryStack stack) {
        return XrInteractionProfileAnalogThresholdVALVE.wrap(XrInteractionProfileAnalogThresholdVALVE.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrInteractionProfileAnalogThresholdVALVE.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrInteractionProfileAnalogThresholdVALVE.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static long naction(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)ACTION);
    }

    public static long nbinding(long struct) {
        return UNSAFE.getLong(null, struct + (long)BINDING);
    }

    public static float nonThreshold(long struct) {
        return UNSAFE.getFloat(null, struct + (long)ONTHRESHOLD);
    }

    public static float noffThreshold(long struct) {
        return UNSAFE.getFloat(null, struct + (long)OFFTHRESHOLD);
    }

    @Nullable
    public static XrHapticBaseHeader nonHaptic(long struct) {
        return XrHapticBaseHeader.createSafe(MemoryUtil.memGetAddress(struct + (long)ONHAPTIC));
    }

    @Nullable
    public static XrHapticBaseHeader noffHaptic(long struct) {
        return XrHapticBaseHeader.createSafe(MemoryUtil.memGetAddress(struct + (long)OFFHAPTIC));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    public static void naction(long struct, XrAction value) {
        MemoryUtil.memPutAddress(struct + (long)ACTION, value.address());
    }

    public static void nbinding(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)BINDING, value);
    }

    public static void nonThreshold(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)ONTHRESHOLD, value);
    }

    public static void noffThreshold(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)OFFTHRESHOLD, value);
    }

    public static void nonHaptic(long struct, @Nullable XrHapticBaseHeader value) {
        MemoryUtil.memPutAddress(struct + (long)ONHAPTIC, MemoryUtil.memAddressSafe(value));
    }

    public static void noffHaptic(long struct, @Nullable XrHapticBaseHeader value) {
        MemoryUtil.memPutAddress(struct + (long)OFFHAPTIC, MemoryUtil.memAddressSafe(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)ACTION));
    }

    static {
        Struct.Layout layout = XrInteractionProfileAnalogThresholdVALVE.__struct(XrInteractionProfileAnalogThresholdVALVE.__member(4), XrInteractionProfileAnalogThresholdVALVE.__member(POINTER_SIZE), XrInteractionProfileAnalogThresholdVALVE.__member(POINTER_SIZE), XrInteractionProfileAnalogThresholdVALVE.__member(8), XrInteractionProfileAnalogThresholdVALVE.__member(4), XrInteractionProfileAnalogThresholdVALVE.__member(4), XrInteractionProfileAnalogThresholdVALVE.__member(POINTER_SIZE), XrInteractionProfileAnalogThresholdVALVE.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        ACTION = layout.offsetof(2);
        BINDING = layout.offsetof(3);
        ONTHRESHOLD = layout.offsetof(4);
        OFFTHRESHOLD = layout.offsetof(5);
        ONHAPTIC = layout.offsetof(6);
        OFFHAPTIC = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<XrInteractionProfileAnalogThresholdVALVE, Buffer>
    implements NativeResource {
        private static final XrInteractionProfileAnalogThresholdVALVE ELEMENT_FACTORY = XrInteractionProfileAnalogThresholdVALVE.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrInteractionProfileAnalogThresholdVALVE getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrInteractionProfileAnalogThresholdVALVE.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrInteractionProfileAnalogThresholdVALVE.nnext(this.address());
        }

        @NativeType(value="XrAction")
        public long action() {
            return XrInteractionProfileAnalogThresholdVALVE.naction(this.address());
        }

        @NativeType(value="XrPath")
        public long binding() {
            return XrInteractionProfileAnalogThresholdVALVE.nbinding(this.address());
        }

        public float onThreshold() {
            return XrInteractionProfileAnalogThresholdVALVE.nonThreshold(this.address());
        }

        public float offThreshold() {
            return XrInteractionProfileAnalogThresholdVALVE.noffThreshold(this.address());
        }

        @Nullable
        @NativeType(value="XrHapticBaseHeader const *")
        public XrHapticBaseHeader onHaptic() {
            return XrInteractionProfileAnalogThresholdVALVE.nonHaptic(this.address());
        }

        @Nullable
        @NativeType(value="XrHapticBaseHeader const *")
        public XrHapticBaseHeader offHaptic() {
            return XrInteractionProfileAnalogThresholdVALVE.noffHaptic(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrInteractionProfileAnalogThresholdVALVE.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1000079000);
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrInteractionProfileAnalogThresholdVALVE.nnext(this.address(), value);
            return this;
        }

        public Buffer action(XrAction value) {
            XrInteractionProfileAnalogThresholdVALVE.naction(this.address(), value);
            return this;
        }

        public Buffer binding(@NativeType(value="XrPath") long value) {
            XrInteractionProfileAnalogThresholdVALVE.nbinding(this.address(), value);
            return this;
        }

        public Buffer onThreshold(float value) {
            XrInteractionProfileAnalogThresholdVALVE.nonThreshold(this.address(), value);
            return this;
        }

        public Buffer offThreshold(float value) {
            XrInteractionProfileAnalogThresholdVALVE.noffThreshold(this.address(), value);
            return this;
        }

        public Buffer onHaptic(@Nullable @NativeType(value="XrHapticBaseHeader const *") XrHapticBaseHeader value) {
            XrInteractionProfileAnalogThresholdVALVE.nonHaptic(this.address(), value);
            return this;
        }

        public Buffer offHaptic(@Nullable @NativeType(value="XrHapticBaseHeader const *") XrHapticBaseHeader value) {
            XrInteractionProfileAnalogThresholdVALVE.noffHaptic(this.address(), value);
            return this;
        }
    }
}

