/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrHapticVibration;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrHapticBaseHeader
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;

    public XrHapticBaseHeader(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), XrHapticBaseHeader.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrHapticBaseHeader.ntype(this.address());
    }

    @NativeType(value="void const *")
    public long next() {
        return XrHapticBaseHeader.nnext(this.address());
    }

    public XrHapticBaseHeader type(@NativeType(value="XrStructureType") int value) {
        XrHapticBaseHeader.ntype(this.address(), value);
        return this;
    }

    public XrHapticBaseHeader next(@NativeType(value="void const *") long value) {
        XrHapticBaseHeader.nnext(this.address(), value);
        return this;
    }

    public XrHapticBaseHeader set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrHapticBaseHeader set(XrHapticBaseHeader src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static XrHapticBaseHeader malloc() {
        return XrHapticBaseHeader.wrap(XrHapticBaseHeader.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static XrHapticBaseHeader calloc() {
        return XrHapticBaseHeader.wrap(XrHapticBaseHeader.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static XrHapticBaseHeader create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return XrHapticBaseHeader.wrap(XrHapticBaseHeader.class, MemoryUtil.memAddress(container), container);
    }

    public static XrHapticBaseHeader create(long address) {
        return XrHapticBaseHeader.wrap(XrHapticBaseHeader.class, address);
    }

    @Nullable
    public static XrHapticBaseHeader createSafe(long address) {
        return address == 0L ? null : XrHapticBaseHeader.wrap(XrHapticBaseHeader.class, address);
    }

    public static XrHapticBaseHeader create(XrHapticVibration value) {
        return XrHapticBaseHeader.wrap(XrHapticBaseHeader.class, value);
    }

    public static Buffer malloc(int capacity) {
        return XrHapticBaseHeader.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(XrHapticBaseHeader.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return XrHapticBaseHeader.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrHapticBaseHeader.__create(capacity, SIZEOF);
        return XrHapticBaseHeader.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return XrHapticBaseHeader.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : XrHapticBaseHeader.wrap(Buffer.class, address, capacity);
    }

    public static Buffer create(XrHapticVibration.Buffer value) {
        return XrHapticBaseHeader.wrap(Buffer.class, value);
    }

    public static XrHapticBaseHeader malloc(MemoryStack stack) {
        return XrHapticBaseHeader.wrap(XrHapticBaseHeader.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrHapticBaseHeader calloc(MemoryStack stack) {
        return XrHapticBaseHeader.wrap(XrHapticBaseHeader.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return XrHapticBaseHeader.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return XrHapticBaseHeader.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)NEXT);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)NEXT, value);
    }

    static {
        Struct.Layout layout = XrHapticBaseHeader.__struct(XrHapticBaseHeader.__member(4), XrHapticBaseHeader.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrHapticBaseHeader, Buffer>
    implements NativeResource {
        private static final XrHapticBaseHeader ELEMENT_FACTORY = XrHapticBaseHeader.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected XrHapticBaseHeader getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrHapticBaseHeader.ntype(this.address());
        }

        @NativeType(value="void const *")
        public long next() {
            return XrHapticBaseHeader.nnext(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrHapticBaseHeader.ntype(this.address(), value);
            return this;
        }

        public Buffer next(@NativeType(value="void const *") long value) {
            XrHapticBaseHeader.nnext(this.address(), value);
            return this;
        }
    }
}

